/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yuudaari.soulus.common.compat.jei.JeiDescriptionRegistry;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.essence.ConfigColor;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.recipe.ingredient.IngredientPotentialEssence;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.EssenceType;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class Essence
extends Registration.Item {
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG;

    public static ItemStack getStack(String essenceType) {
        return Essence.getStack(essenceType, 1);
    }

    public static ItemStack getStack(String essenceType, Integer count) {
        ItemStack stack = new ItemStack((Item)ItemRegistry.ESSENCE, count.intValue());
        EssenceType.setEssenceType(stack, essenceType);
        return stack;
    }

    public static int getColor(String essenceType, int index) {
        if (essenceType == null) {
            return -1;
        }
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(essenceType));
        if (entry == null) {
            return -1;
        }
        ConfigEssence essenceConfig = CONFIG.get(essenceType);
        if (essenceConfig == null) {
            return -1;
        }
        ConfigColor colors = essenceConfig.colors;
        if (colors == null) {
            EntityList.EntityEggInfo eggInfo = entry.getEgg();
            if (eggInfo == null) {
                return -1;
            }
            colors = new ConfigColor(eggInfo);
        }
        return index == 0 ? colors.primary : colors.secondary;
    }

    public Essence() {
        super("essence");
        this.setMaxStackSize(64);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.registerColorHandler((stack, tintIndex) -> {
                String essenceType = EssenceType.getEssenceType(stack);
                return Essence.getColor(essenceType, tintIndex);
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String essenceType = EssenceType.getEssenceType(stack);
        ConfigEssence config = CONFIG.get(essenceType);
        if (essenceType == null || config == null) {
            return Translation.localize(this.func_77658_a() + ".unfocused.name", new Object[0]).trim();
        }
        String alignment = config.name;
        if (alignment == null) {
            alignment = Translation.localizeEntity(essenceType);
        }
        return Translation.localize(this.func_77658_a() + ".focused.name", alignment).trim();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (ConfigEssence essence : Essence.CONFIG.essences) {
            if (essence.essence.equals("NONE")) continue;
            items.add((Object)Essence.getStack(essence.essence));
        }
    }

    @Override
    public void onRegisterDescription(JeiDescriptionRegistry registry) {
        registry.add(new IngredientPotentialEssence(false, false), this.getRegistryName());
    }
}

