/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config.misc;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import yuudaari.soulus.common.config.ConfigFile;
import yuudaari.soulus.common.config.ConfigProfile;
import yuudaari.soulus.common.util.serializer.DefaultMapSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@ConfigFile(file="misc/breeding", id="soulus", profile="none")
@Serializable
public class ConfigBreeding {
    @ConfigProfile
    public static ConfigBreeding none = new ConfigBreeding().blacklist("*");
    @ConfigProfile
    public static ConfigBreeding all = new ConfigBreeding();
    @Serialized(value=ConfigBreedingMapSerializer.class, topLevel=true)
    public Map<String, Double> breeding = new HashMap<String, Double>();

    public ConfigBreeding blacklist(String creature) {
        this.breeding.put(creature, 0.0);
        return this;
    }

    public ConfigBreeding whitelist(String creature) {
        this.breeding.put(creature, 1.0);
        return this;
    }

    public ConfigBreeding setChance(String creature, double chance) {
        this.breeding.put(creature, chance);
        return this;
    }

    public double getChance(String creature) {
        if (this.breeding.containsKey(creature)) {
            return this.breeding.get(creature);
        }
        String domain = new ResourceLocation(creature).func_110624_b() + ":*";
        if (this.breeding.containsKey(domain)) {
            return this.breeding.get(domain);
        }
        return this.breeding.getOrDefault("*", 1.0);
    }

    public static class ConfigBreedingMapSerializer
    extends DefaultMapSerializer<Double> {
        @Override
        public Class<Double> getValueClass() {
            return Double.class;
        }
    }
}

