/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.client.exporter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Keyboard;
import scala.Tuple2;
import yuudaari.soulus.client.exporter.GuiExporterLoading;
import yuudaari.soulus.client.exporter.Renderer;
import yuudaari.soulus.client.exporter.exports.ItemExport;
import yuudaari.soulus.client.exporter.exports.RecipeExport;
import yuudaari.soulus.common.CreativeTab;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.IBlockRegistration;
import yuudaari.soulus.common.registration.IItemRegistration;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.JSON;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.Translation;
import yuudaari.soulus.common.util.serializer.Serializer;

public class Exporter {
    private static final Map<String, File> modFolders = Maps.newHashMap();

    private static File getModFolder(String modid, File exportFolder) {
        File modFolder = modFolders.get(modid);
        if (modFolder == null) {
            modFolder = new File(exportFolder.getPath() + "/" + modid + "/");
            modFolders.put(modid, modFolder);
        }
        return modFolder;
    }

    private static String sanitize(String str) {
        return str.replaceAll("[^A-Za-z0-9-_ ]", "_");
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> export() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiIngameMenu());
        modFolders.clear();
        File exportFolder = new File("export/");
        try {
            FileUtils.deleteDirectory((File)exportFolder);
        }
        catch (IOException e) {
            Logger.error("Unable to clear export folder");
            Logger.error(e);
        }
        Tuple2<List<ItemStack>, List<IRecipe>> toExport = Exporter.getExports();
        List itemsToExport = (List)toExport._1;
        List recipesToExport = (List)toExport._2;
        HashMap renderedItems = Maps.newHashMap();
        long lastUpdate = 0L;
        int exportCount = 0;
        Renderer.setUpRenderState();
        for (ItemStack stack : (List)toExport._1) {
            if (Keyboard.isKeyDown((int)1)) break;
            ResourceLocation registryName = stack.func_77973_b().getRegistryName();
            String modid = registryName.func_110624_b();
            File modFolder = Exporter.getModFolder(modid, exportFolder);
            String imagePath = Renderer.render(stack, Exporter.sanitize(registryName.func_110623_a()), modFolder);
            if (imagePath != null) {
                Tuple2 renders = (Tuple2)renderedItems.get(stack.func_77973_b());
                if (renders == null) {
                    renders = new Tuple2((Object)Lists.newArrayList(), (Object)exportCount);
                    renderedItems.put(stack.func_77973_b(), renders);
                }
                ((List)renders._1).add(new Tuple2((Object)stack, (Object)imagePath));
            }
            ++exportCount;
            if (Minecraft.func_71386_F() - lastUpdate <= 33L) continue;
            Renderer.tearDownRenderState();
            String rendering = Translation.localize("gui.rendering", itemsToExport.size(), modid);
            String progress = Translation.localize("gui.progress", exportCount, itemsToExport.size(), itemsToExport.size() - exportCount);
            GuiExporterLoading.renderLoadingScreen(rendering, progress, stack, (float)exportCount / (float)itemsToExport.size());
            lastUpdate = Minecraft.func_71386_F();
            Renderer.setUpRenderState();
        }
        Exporter.writeItemsJson(renderedItems, exportFolder);
        Exporter.writeRecipesJson(recipesToExport, exportFolder);
        ArrayList result = Lists.newArrayList();
        if (exportCount < itemsToExport.size()) {
            String cancelled = Translation.localize("gui.renderCancelled", new Object[0]);
            String progress = Translation.localize("gui.progress", exportCount, itemsToExport.size(), itemsToExport.size() - exportCount);
            result.add(cancelled);
            result.add(progress);
            GuiExporterLoading.renderLoadingScreen(cancelled, progress, null, (float)exportCount / (float)itemsToExport.size());
        } else {
            String rendered = Translation.localize("gui.rendered", exportCount);
            result.add(rendered);
            GuiExporterLoading.renderLoadingScreen(rendered, "", null, 1.0f);
        }
        Renderer.tearDownRenderState();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private static void writeItemsJson(Map<Item, Tuple2<List<Tuple2<ItemStack, String>>, Integer>> renderedItems, File exportFolder) {
        JsonArray itemExportsJson = new JsonArray();
        renderedItems.entrySet().stream().sorted((a, b) -> (Integer)((Tuple2)a.getValue())._2 - (Integer)((Tuple2)b.getValue())._2).forEach(renderedItem -> {
            Item item = (Item)renderedItem.getKey();
            ArrayList stackExports = Lists.newArrayList();
            for (Tuple2 renderedStack : (List)((Tuple2)renderedItem.getValue())._1) {
                String imagePath = item.getRegistryName().func_110624_b() + "/" + (String)renderedStack._2;
                stackExports.add(new ItemExport.StackExport(imagePath, (ItemStack)renderedStack._1));
            }
            ItemExport export = new ItemExport(item, stackExports);
            itemExportsJson.add(Serializer.serialize(export));
        });
        JSON.writeFile((JsonElement)itemExportsJson, new File(exportFolder, "items.json"));
    }

    private static void writeRecipesJson(List<IRecipe> recipes, File exportFolder) {
        JsonArray recipeExportsJson = new JsonArray();
        recipes.stream().map(recipe -> Serializer.serialize(new RecipeExport((IRecipe)recipe))).forEach(arg_0 -> ((JsonArray)recipeExportsJson).add(arg_0));
        JSON.writeFile((JsonElement)recipeExportsJson, new File(exportFolder, "recipes.json"));
    }

    private static Tuple2<List<ItemStack>, List<IRecipe>> getExports() {
        NonNullList tabList;
        StackMap items = new StackMap();
        for (IBlockRegistration block : BlockRegistry.blocks) {
            tabList = NonNullList.func_191196_a();
            block.getSubBlocks(CreativeTab.INSTANCE, (NonNullList<ItemStack>)tabList);
            items.add((List<ItemStack>)tabList);
        }
        for (IItemRegistration item : ItemRegistry.items) {
            tabList = NonNullList.func_191196_a();
            item.getSubItems(CreativeTab.INSTANCE, (NonNullList<ItemStack>)tabList);
            items.add((List<ItemStack>)tabList);
        }
        ArrayList matchingRecipeItems = Lists.newArrayList();
        ArrayList matchingRecipes = Lists.newArrayList();
        block2: for (IRecipe recipe : ForgeRegistries.RECIPES.getValues()) {
            ItemStack output = recipe.func_77571_b();
            List ingredients = recipe.func_192400_c().stream().flatMap(ingredient -> Arrays.stream(ingredient.func_193365_a())).collect(Collectors.toList());
            for (Item item : items.items()) {
                if (!output.func_77973_b().equals(item) && !ingredients.stream().anyMatch(stack -> stack.func_77973_b().equals(item))) continue;
                matchingRecipes.add(recipe);
                matchingRecipeItems.add(output);
                matchingRecipeItems.addAll(ingredients);
                continue block2;
            }
        }
        items.add(matchingRecipeItems);
        return new Tuple2(items.stacks(), (Object)matchingRecipes);
    }

    private static class StackMap {
        private final Map<Item, List<Tuple2<ItemStack, Integer>>> internalMap = Maps.newHashMap();
        private int index = 0;

        private StackMap() {
        }

        public void add(List<ItemStack> stacks) {
            for (ItemStack stack : stacks) {
                ArrayList itemList = this.internalMap.get(stack.func_77973_b());
                if (itemList == null) {
                    itemList = Lists.newArrayList();
                    this.internalMap.put(stack.func_77973_b(), itemList);
                }
                if (itemList.stream().anyMatch(existingStack -> this.areStacksEqual(stack, (ItemStack)existingStack._1))) continue;
                itemList.add(new Tuple2((Object)stack, (Object)this.index++));
                Logger.info(stack.func_77973_b().getRegistryName() + " (" + stack.func_82833_r() + ")");
            }
        }

        public Set<Item> items() {
            return this.internalMap.keySet();
        }

        public List<ItemStack> stacks() {
            return this.internalMap.values().stream().flatMap(stackList -> stackList.stream()).sorted((a, b) -> (Integer)a._2 - (Integer)b._2).map(stack -> (ItemStack)stack._1).collect(Collectors.toList());
        }

        private boolean areStacksEqual(ItemStack a, ItemStack b) {
            return a.func_77973_b().equals(b.func_77973_b()) && a.func_77960_j() == b.func_77960_j() && a.func_77978_p() == null == (b.func_77978_p() == null) && (a.func_77978_p() == null || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible(b);
        }
    }
}

