/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import yuudaari.soulus.client.ModRenderers;
import yuudaari.soulus.common.ModGenerators;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.compat.GameStages;
import yuudaari.soulus.common.compat.crafttweaker.ZenComposer;
import yuudaari.soulus.common.compat.top.TheOneProbe;
import yuudaari.soulus.common.config.Config;
import yuudaari.soulus.common.misc.BoneChunks;
import yuudaari.soulus.common.misc.MidnightDraught;
import yuudaari.soulus.common.network.SoulsPacketHandler;
import yuudaari.soulus.common.network.packet.client.SendConfig;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.DebugHelper;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.server.command.SoulusCommand;

@Mod(modid="soulus", name="Soulus", version="1.12.2-4.2.4-9558cf7", acceptedMinecraftVersions="[1.12.2]", dependencies="after:crafttweaker")
@Mod.EventBusSubscriber
public class Soulus {
    public static final String NAME = "Soulus";
    public static final String MODID = "soulus";
    public static Config config;
    @Mod.Instance(value="soulus")
    public static Soulus INSTANCE;
    public static final Set<PreInitEventHandler> preInitHandlers;
    public static final Set<InitEventHandler> initHandlers;
    public static final Set<PostInitEventHandler> postInitHandlers;
    public static final Set<ConfigReloadEventHandler> configReloadHandlers;

    public static ResourceLocation getRegistryName(String name) {
        int index = name.lastIndexOf(58);
        String prefix = index == -1 ? MODID : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        return new ResourceLocation(prefix, name);
    }

    public static void onPreInit(PreInitEventHandler handler) {
        preInitHandlers.add(handler);
    }

    public static void onInit(InitEventHandler handler) {
        initHandlers.add(handler);
    }

    public static void onPostInit(PostInitEventHandler handler) {
        postInitHandlers.add(handler);
    }

    public static void onConfigReload(ConfigReloadEventHandler handler) {
        configReloadHandlers.add(handler);
    }

    public static void removeConfigReloadHandler(ConfigReloadEventHandler handler) {
        configReloadHandlers.remove(handler);
    }

    public static void reloadConfigs(boolean syncToClients, boolean serialize) {
        try {
            config.deserialize(false);
            Logger.info("Reloaded client-side configs.");
            if (serialize) {
                try {
                    config.serialize();
                    Logger.info("Written updated configs to disk.");
                }
                catch (Exception e) {
                    Logger.error(e);
                }
            }
            config.deserialize(true);
            Logger.info("Reloaded configs.");
            if (syncToClients && FMLCommonHandler.instance().getSide() == Side.SERVER) {
                Soulus.syncConfigs();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (ConfigReloadEventHandler handler : configReloadHandlers.toArray(new ConfigReloadEventHandler[0])) {
            handler.handle();
        }
    }

    public static void syncConfigs() {
        SendConfig packet = new SendConfig(Config.INSTANCES.get((Object)MODID).SERVER_CONFIGS);
        SoulsPacketHandler.INSTANCE.sendToAll((IMessage)packet);
        Logger.info("Synced configs to clients.");
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TheOneProbe.register();
        }
        String configPath = event.getModConfigurationDirectory().getAbsolutePath() + "/soulus/";
        config = new Config(event.getAsmData(), configPath, MODID);
        Soulus.reloadConfigs(false, true);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, (tickets, world) -> {});
        Advancements.registerTriggers();
        DebugHelper.initialize();
        for (PreInitEventHandler handler : preInitHandlers) {
            handler.handle(event);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (InitEventHandler handler : initHandlers) {
            handler.handle(event);
        }
        MidnightDraught.register();
        if (event.getSide() == Side.CLIENT) {
            ModRenderers.init();
        }
        ModGenerators.init();
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        for (PostInitEventHandler handler : postInitHandlers) {
            handler.handle(event);
        }
        SoulsPacketHandler.register();
        if (Loader.isModLoaded((String)"crafttweaker")) {
            ZenComposer.apply();
        }
        if (Loader.isModLoaded((String)"gamestages")) {
            MinecraftForge.EVENT_BUS.register((Object)new GameStages());
        }
        BoneChunks.registerEssenceDrops((FMLStateEvent)event);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistry.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ItemRegistry.registerItems((IForgeRegistry<Item>)registry);
        BlockRegistry.registerItems((IForgeRegistry<Item>)registry);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        ItemRegistry.registerModels();
        BlockRegistry.registerModels();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        ItemRegistry.registerRecipes((IForgeRegistry<IRecipe>)registry);
        BlockRegistry.registerRecipes((IForgeRegistry<IRecipe>)registry);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new SoulusCommand());
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public static void clientConnect(PlayerEvent.PlayerLoggedInEvent event) {
        if (!Soulus.reloadAllIfGameStagesTweaks()) {
            SendConfig packet = new SendConfig(Config.INSTANCES.get((Object)MODID).SERVER_CONFIGS);
            SoulsPacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)event.player);
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public static void clientDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Soulus.reloadAllIfGameStagesTweaks();
    }

    private static boolean reloadAllIfGameStagesTweaks() {
        if (Loader.isModLoaded((String)"gamestages") && Config.CONFIGS_HAVE_GAME_STAGES_TWEAKS) {
            Soulus.reloadConfigs(true, false);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void disconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Soulus.config.SERVER_CONFIGS.clear();
        Soulus.reloadConfigs(false, false);
    }

    static {
        FluidRegistry.enableUniversalBucket();
        preInitHandlers = new HashSet<PreInitEventHandler>();
        initHandlers = new HashSet<InitEventHandler>();
        postInitHandlers = new HashSet<PostInitEventHandler>();
        configReloadHandlers = new HashSet<ConfigReloadEventHandler>();
    }

    public static interface ConfigReloadEventHandler {
        public void handle();
    }

    public static interface PostInitEventHandler {
        public void handle(FMLPostInitializationEvent var1);
    }

    public static interface InitEventHandler {
        public void handle(FMLInitializationEvent var1);
    }

    public static interface PreInitEventHandler {
        public void handle(FMLPreInitializationEvent var1);
    }
}

