/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.tinkeredhegemony;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import pl.asie.tinkeredhegemony.DisabledItemClass;
import pl.asie.tinkeredhegemony.MaterialMatcher;
import pl.asie.tinkeredhegemony.TinkeredHegemony;
import slimeknights.tconstruct.library.materials.Material;

public class RecipeReplacement {
    private void checkTo(Object to) {
        if (!(to instanceof Item || to instanceof ItemStack || to instanceof String)) {
            throw new RuntimeException("Invalid RecipeReplacement target type: " + to.getClass().getName() + "!");
        }
    }

    @Nullable
    private Ingredient replaceIngredient(Ingredient ing) {
        ItemStack s;
        ItemStack[] matchingStacks;
        if (ing.getClass() == Ingredient.class && (matchingStacks = ing.func_193365_a()).length == 1 && TinkeredHegemony.itemSet.contains((s = matchingStacks[0]).func_77973_b())) {
            for (DisabledItemClass c : TinkeredHegemony.classMap) {
                Collection<Material> ms;
                if (!c.getItemPredicate().test(s.func_77973_b()) || (ms = MaterialMatcher.get(s.func_77973_b())) == null) continue;
                return c.createIngredient(ms);
            }
        }
        return null;
    }

    public void process(Iterable<IRecipe> registry) {
        for (IRecipe recipe : registry) {
            ResourceLocation recipeName = recipe.getRegistryName();
            boolean dirty = false;
            if (recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes || recipe instanceof ShapedOreRecipe || recipe instanceof ShapelessOreRecipe) {
                NonNullList ingredients = recipe.func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ing = (Ingredient)ingredients.get(i);
                    Ingredient ingNew = this.replaceIngredient(ing);
                    if (ingNew == null) continue;
                    ingredients.set(i, (Object)ingNew);
                    dirty = true;
                }
            }
            if (!dirty) continue;
            TinkeredHegemony.logger.info("Successfully edited " + recipeName + "!");
        }
    }
}

