/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common;

import com.mojang.authlib.GameProfile;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonScheduler;
import hellfirepvp.astralsorcery.common.auxiliary.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkHandler;
import hellfirepvp.astralsorcery.common.auxiliary.tick.TickManager;
import hellfirepvp.astralsorcery.common.base.FluidRarityRegistry;
import hellfirepvp.astralsorcery.common.base.HerdableAnimal;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.base.RockCrystalHandler;
import hellfirepvp.astralsorcery.common.base.ShootingStarHandler;
import hellfirepvp.astralsorcery.common.base.TileAccelerationBlacklist;
import hellfirepvp.astralsorcery.common.base.TreeTypes;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonDataManager;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonFlareManager;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.block.BlockCustomSandOre;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.charge.PlayerChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeLimiter;
import hellfirepvp.astralsorcery.common.container.ContainerAltarAttunement;
import hellfirepvp.astralsorcery.common.container.ContainerAltarConstellation;
import hellfirepvp.astralsorcery.common.container.ContainerAltarDiscovery;
import hellfirepvp.astralsorcery.common.container.ContainerAltarTrait;
import hellfirepvp.astralsorcery.common.container.ContainerJournal;
import hellfirepvp.astralsorcery.common.container.ContainerObservatory;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.research.ResearchIOThread;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantHelper;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletHolderCapability;
import hellfirepvp.astralsorcery.common.enchantment.amulet.PlayerAmuletHandler;
import hellfirepvp.astralsorcery.common.enchantment.amulet.registry.AmuletEnchantmentRegistry;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerCapeEffects;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerEntity;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerIO;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerMisc;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerNetwork;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerServer;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationBloodMagic;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationChisel;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationCrafttweaker;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationThaumcraft;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.ItemJournal;
import hellfirepvp.astralsorcery.common.item.gem.GemAttributeHelper;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.migration.MappingMigrationHandler;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktLightningEffect;
import hellfirepvp.astralsorcery.common.registry.RegistryAdvancements;
import hellfirepvp.astralsorcery.common.registry.RegistryConstellations;
import hellfirepvp.astralsorcery.common.registry.RegistryEntities;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.registry.RegistryKnowledgeFragments;
import hellfirepvp.astralsorcery.common.registry.RegistryPerks;
import hellfirepvp.astralsorcery.common.registry.RegistryRecipes;
import hellfirepvp.astralsorcery.common.registry.RegistryResearch;
import hellfirepvp.astralsorcery.common.registry.RegistryStructures;
import hellfirepvp.astralsorcery.common.registry.internal.InternalRegistryPrimer;
import hellfirepvp.astralsorcery.common.registry.internal.PrimerEventHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightNetworkRegistry;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChunkTracker;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.structure.change.StructureIntegrityObserver;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileBore;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.tile.TileOreGenerator;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.util.ASDataSerializers;
import hellfirepvp.astralsorcery.common.util.AltarRecipeEffectRecovery;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.DamageSourceUtil;
import hellfirepvp.astralsorcery.common.util.LootTableUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.ParticleEffectWatcher;
import hellfirepvp.astralsorcery.common.util.PlayerActivityManager;
import hellfirepvp.astralsorcery.common.util.TreeCaptureHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopController;
import hellfirepvp.astralsorcery.common.util.log.LogUtil;
import hellfirepvp.astralsorcery.common.world.AstralWorldGenerator;
import hellfirepvp.astralsorcery.common.world.retrogen.ChunkVersionController;
import hellfirepvp.astralsorcery.common.world.retrogen.RetroGenController;
import java.awt.Color;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class CommonProxy
implements IGuiHandler {
    public static DamageSource dmgSourceBleed = DamageSourceUtil.newType("as.bleed").func_76348_h();
    public static DamageSource dmgSourceStellar = DamageSourceUtil.newType("as.stellar").func_76348_h().func_82726_p();
    public static DamageSource dmgSourceReflect = DamageSourceUtil.newType("thorns");
    public static InternalRegistryPrimer registryPrimer;
    public static AstralWorldGenerator worldGenerator;
    private CommonScheduler commonScheduler = new CommonScheduler();

    public void setupConfiguration() {
        worldGenerator.pushConfigEntries();
        ConstellationEffectRegistry.addDynamicConfigEntries();
        CapeEffectRegistry.addDynamicConfigEntries();
        Config.addDynamicEntry(TileTreeBeacon.ConfigEntryTreeBeacon.instance);
        Config.addDynamicEntry(TileOreGenerator.ConfigEntryMultiOre.instance);
        Config.addDynamicEntry(TileChalice.ConfigEntryChalice.instance);
        Config.addDynamicEntry(TileBore.CfgEntry.instance);
        Config.addDynamicEntry(new AmuletEnchantHelper.CfgEntry());
        Config.addDynamicEntry(new GemAttributeHelper.CfgEntry());
        Config.addDynamicEntry(new TileAccelerationBlacklist.TileAccelBlacklistEntry());
        Config.addDynamicEntry(new ShootingStarHandler.StarConfigEntry());
        Config.addDynamicEntry(PerkLevelManager.INSTANCE);
        Config.addDynamicEntry(new LogUtil.CfgEntry());
    }

    public void registerConfigDataRegistries() {
        Config.addDataRegistry(OreTypes.RITUAL_MINERALIS);
        Config.addDataRegistry(OreTypes.AEVITAS_ORE_PERK);
        Config.addDataRegistry(OreTypes.TREASURE_SHRINE_GEN);
        Config.addDataRegistry(OreTypes.PERK_VOID_TRASH_REPLACEMENT);
        Config.addDataRegistry(FluidRarityRegistry.INSTANCE);
        Config.addDataRegistry(AmuletEnchantmentRegistry.INSTANCE);
        Config.addDataRegistry(HerdableAnimal.HerdableAdapter.INSTANCE);
    }

    public void preInit() {
        registryPrimer = new InternalRegistryPrimer();
        MinecraftForge.EVENT_BUS.register((Object)new PrimerEventHandler(registryPrimer));
        RegistryItems.setupDefaults();
        RegistryConstellations.init();
        ASDataSerializers.registerSerializers();
        RegistryAdvancements.init();
        PacketChannel.init();
        RegistryEntities.init();
        SourceClassRegistry.setupRegistry();
        TransmissionClassRegistry.setupRegistry();
        StarlightNetworkRegistry.setupRegistry();
        LootTableUtil.initLootTable();
        ConstellationEffectRegistry.init();
        if (Mods.THAUMCRAFT.isPresent()) {
            MinecraftForge.EVENT_BUS.register((Object)ModIntegrationThaumcraft.INSTANCE);
        }
        RegistryPerks.initPerkTree();
        this.registerCapabilities();
        if (Mods.CRAFTTWEAKER.isPresent()) {
            AstralSorcery.log.info("Crafttweaker found! Adding recipe handlers...");
            ModIntegrationCrafttweaker.instance.load();
        } else {
            AstralSorcery.log.info("Crafttweaker not found!");
        }
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(FluidRarityRegistry.ChunkFluidEntry.class, (Capability.IStorage)new Capability.IStorage<FluidRarityRegistry.ChunkFluidEntry>(){

            @Nullable
            public NBTBase writeNBT(Capability<FluidRarityRegistry.ChunkFluidEntry> capability, FluidRarityRegistry.ChunkFluidEntry instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<FluidRarityRegistry.ChunkFluidEntry> capability, FluidRarityRegistry.ChunkFluidEntry instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, (Callable)new FluidRarityRegistry.ChunkFluidEntryFactory());
        CapabilityManager.INSTANCE.register(AmuletHolderCapability.class, (Capability.IStorage)new Capability.IStorage<AmuletHolderCapability>(){

            @Nullable
            public NBTBase writeNBT(Capability<AmuletHolderCapability> capability, AmuletHolderCapability instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<AmuletHolderCapability> capability, AmuletHolderCapability instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, (Callable)new AmuletHolderCapability.Factory());
        CapabilityManager.INSTANCE.register(RockCrystalHandler.RockCrystalPositions.class, (Capability.IStorage)new Capability.IStorage<RockCrystalHandler.RockCrystalPositions>(){

            @Nullable
            public NBTBase writeNBT(Capability<RockCrystalHandler.RockCrystalPositions> capability, RockCrystalHandler.RockCrystalPositions instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<RockCrystalHandler.RockCrystalPositions> capability, RockCrystalHandler.RockCrystalPositions instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, (Callable)new RockCrystalHandler.ChunkFluidEntryFactory());
    }

    public void registerOreDictEntries() {
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)BlockMarble.MarbleBlockType.RAW.asStack());
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)BlockMarble.MarbleBlockType.BRICKS.asStack());
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)BlockMarble.MarbleBlockType.PILLAR.asStack());
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)BlockMarble.MarbleBlockType.ARCH.asStack());
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)BlockMarble.MarbleBlockType.CHISELED.asStack());
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)BlockMarble.MarbleBlockType.ENGRAVED.asStack());
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)BlockMarble.MarbleBlockType.RUNED.asStack());
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)BlockMarble.MarbleBlockType.RAW.asStack());
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)BlockMarble.MarbleBlockType.BRICKS.asStack());
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)BlockMarble.MarbleBlockType.PILLAR.asStack());
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)BlockMarble.MarbleBlockType.ARCH.asStack());
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)BlockMarble.MarbleBlockType.CHISELED.asStack());
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)BlockMarble.MarbleBlockType.ENGRAVED.asStack());
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)BlockMarble.MarbleBlockType.RUNED.asStack());
        OreDictionary.registerOre((String)"oreAstralStarmetal", (ItemStack)BlockCustomOre.OreType.STARMETAL.asStack());
        OreDictionary.registerOre((String)OreDictAlias.ITEM_STARMETAL_INGOT, (ItemStack)ItemCraftingComponent.MetaType.STARMETAL_INGOT.asStack());
        OreDictionary.registerOre((String)OreDictAlias.ITEM_STARMETAL_DUST, (ItemStack)ItemCraftingComponent.MetaType.STARDUST.asStack());
        OreDictionary.registerOre((String)"oreAquamarine", (ItemStack)BlockCustomSandOre.OreType.AQUAMARINE.asStack());
        OreDictionary.registerOre((String)OreDictAlias.ITEM_AQUAMARINE, (ItemStack)ItemCraftingComponent.MetaType.AQUAMARINE.asStack());
    }

    public void init() {
        RegistryStructures.init();
        RegistryResearch.init();
        RegistryRecipes.initGrindstoneOreRecipes();
        SextantFinder.initialize();
        RegistryKnowledgeFragments.init();
        PatreonDataManager.loadPatreonEffects();
        RegistryConstellations.initMapEffects();
        if (Mods.CRAFTTWEAKER.isPresent()) {
            ModIntegrationCrafttweaker.instance.pushChanges();
        }
        ModIntegrationChisel.sendVariantIMC();
        MappingMigrationHandler.init();
        ModIntegrationBloodMagic.sendIMC();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)AstralSorcery.instance, (IGuiHandler)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)TreeCaptureHelper.eventInstance);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerNetwork());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerServer());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerMisc());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerEntity());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerIO());
        MinecraftForge.EVENT_BUS.register((Object)TransmissionChunkTracker.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)TickManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)StarlightTransmissionHandler.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)new LootTableUtil());
        MinecraftForge.EVENT_BUS.register((Object)BlockDropCaptureAssist.instance);
        MinecraftForge.EVENT_BUS.register((Object)ChunkVersionController.instance);
        MinecraftForge.EVENT_BUS.register((Object)CelestialGatewaySystem.instance);
        MinecraftForge.EVENT_BUS.register((Object)EventHandlerCapeEffects.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TimeStopController.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)FluidRarityRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RockCrystalHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)PlayerAmuletHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)PerkEffectHelper.EVENT_INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)AttributeTypeLimiter.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)PlayerActivityManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)StructureIntegrityObserver.INSTANCE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator.setupAttributes(), (int)50);
        if (Config.enableRetroGen) {
            MinecraftForge.EVENT_BUS.register((Object)new RetroGenController());
        }
        TickManager manager = TickManager.getInstance();
        this.registerTickHandlers(manager);
        SyncDataHolder.initialize();
        TileAccelerationBlacklist.init();
        HerdableAnimal.init();
        TreeTypes.init();
    }

    protected void registerTickHandlers(TickManager manager) {
        manager.register(ConstellationSkyHandler.getInstance());
        manager.register(StarlightTransmissionHandler.getInstance());
        manager.register(StarlightUpdateHandler.getInstance());
        manager.register(WorldCacheManager.getInstance());
        manager.register(new LinkHandler());
        manager.register(SyncDataHolder.getTickInstance());
        manager.register(this.commonScheduler);
        manager.register(PlayerChargeHandler.INSTANCE);
        manager.register(EventHandlerCapeEffects.INSTANCE);
        manager.register(TimeStopController.INSTANCE);
        manager.register(PlayerAmuletHandler.INSTANCE);
        manager.register(PatreonFlareManager.INSTANCE);
        manager.register(PerkEffectHelper.EVENT_INSTANCE);
        manager.register(ShootingStarHandler.getInstance());
        manager.register(ParticleEffectWatcher.INSTANCE);
        manager.register(PlayerActivityManager.INSTANCE);
        manager.register(EventHandlerEntity.spawnDenyRegions);
        manager.register(EventHandlerEntity.invulnerabilityCooldown);
        manager.register(EventHandlerEntity.ritualFlight);
        manager.register(PerkEffectHelper.perkCooldowns);
        manager.register(PerkEffectHelper.perkCooldownsClient);
    }

    public void postInit() {
        AltarRecipeEffectRecovery.attemptRecipeRecovery();
        RegistryPerks.postProcessPerks();
        AstralSorcery.log.info("Post compile recipes");
        CraftingAccessManager.compile();
        ResearchIOThread.startIOThread();
    }

    public void clientFinishedLoading() {
        ItemHandle.ignoreGatingRequirement = false;
    }

    public FakePlayer getASFakePlayerServer(WorldServer world) {
        return FakePlayerFactory.get((WorldServer)world, (GameProfile)new GameProfile(UUID.randomUUID(), "AS-FakePlayer"));
    }

    public void registerVariantName(Item item, String name) {
    }

    public void registerBlockRender(Block block, int metadata, String name) {
    }

    public void registerItemRender(Item item, int metadata, String name) {
    }

    public <T extends Item> void registerItemRender(T item, int metadata, String name, boolean variant) {
    }

    public void registerFromSubItems(Item item, String name) {
    }

    public void scheduleClientside(Runnable r, int tickDelay) {
    }

    public void scheduleClientside(Runnable r) {
        this.scheduleClientside(r, 0);
    }

    public void scheduleDelayed(Runnable r, int tickDelay) {
        this.commonScheduler.addRunnable(r, tickDelay);
    }

    public void scheduleDelayed(Runnable r) {
        this.scheduleDelayed(r, 0);
    }

    public void fireLightning(World world, Vector3 from, Vector3 to) {
        this.fireLightning(world, from, to, null);
    }

    public void fireLightning(World world, Vector3 from, Vector3 to, Color overlay) {
        PktLightningEffect effect = new PktLightningEffect(from, to);
        if (overlay != null) {
            effect.setColorOverlay(overlay);
        }
        PacketChannel.CHANNEL.sendToAllAround((IMessage)effect, PacketChannel.pointFromPos(world, (Vec3i)from.toBlockPos(), 40.0));
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id < 0 || id >= EnumGuiId.values().length) {
            return null;
        }
        EnumGuiId guiType = EnumGuiId.values()[id];
        TileEntity t = null;
        if (guiType.getTileClass() != null && (t = MiscUtils.getTileAt((IBlockAccess)world, new BlockPos(x, y, z), guiType.getTileClass(), true)) == null) {
            return null;
        }
        switch (guiType) {
            case ALTAR_DISCOVERY: {
                return new ContainerAltarDiscovery(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_ATTUNEMENT: {
                return new ContainerAltarAttunement(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_CONSTELLATION: {
                return new ContainerAltarConstellation(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_TRAIT: {
                return new ContainerAltarTrait(player.field_71071_by, (TileAltar)t);
            }
            case JOURNAL_STORAGE: {
                ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
                if (!held.func_190926_b() && held.func_77973_b() instanceof ItemJournal) {
                    return new ContainerJournal(player.field_71071_by, held, player.field_71071_by.field_70461_c);
                }
            }
            case OBSERVATORY: {
                return new ContainerObservatory();
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void openGui(EnumGuiId guiId, EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)AstralSorcery.instance, guiId.ordinal(), world, x, y, z);
    }

    static {
        worldGenerator = new AstralWorldGenerator();
    }

    public static enum EnumGuiId {
        TELESCOPE(TileTelescope.class),
        HAND_TELESCOPE,
        CONSTELLATION_PAPER,
        ALTAR_DISCOVERY(TileAltar.class),
        ALTAR_ATTUNEMENT(TileAltar.class),
        ALTAR_CONSTELLATION(TileAltar.class),
        ALTAR_TRAIT(TileAltar.class),
        MAP_DRAWING(TileMapDrawingTable.class),
        JOURNAL,
        JOURNAL_STORAGE,
        OBSERVATORY(TileObservatory.class),
        SEXTANT,
        KNOWLEDGE_CONSTELLATION;

        private final Class<? extends TileEntity> tileClass;

        private EnumGuiId() {
            this(null);
        }

        private EnumGuiId(Class<? extends TileEntity> tileClass) {
            this.tileClass = tileClass;
        }

        public Class<? extends TileEntity> getTileClass() {
            return this.tileClass;
        }
    }
}

