/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.gui.GuiConstellationPaper;
import hellfirepvp.astralsorcery.client.gui.GuiHandTelescope;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.GuiKnowledgeFragment;
import hellfirepvp.astralsorcery.client.gui.GuiMapDrawing;
import hellfirepvp.astralsorcery.client.gui.GuiObservatory;
import hellfirepvp.astralsorcery.client.gui.GuiSextantSelector;
import hellfirepvp.astralsorcery.client.gui.GuiTelescope;
import hellfirepvp.astralsorcery.client.gui.container.GuiAltarAttunement;
import hellfirepvp.astralsorcery.client.gui.container.GuiAltarConstellation;
import hellfirepvp.astralsorcery.client.gui.container.GuiAltarDiscovery;
import hellfirepvp.astralsorcery.client.gui.container.GuiAltarTrait;
import hellfirepvp.astralsorcery.client.gui.container.GuiJournalContainer;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.item.ItemJournal;
import hellfirepvp.astralsorcery.common.item.knowledge.ItemKnowledgeFragment;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientGuiHandler {
    @SideOnly(value=Side.CLIENT)
    public static Object openGui(CommonProxy.EnumGuiId guiType, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity t = null;
        if (guiType.getTileClass() != null && (t = MiscUtils.getTileAt((IBlockAccess)world, new BlockPos(x, y, z), guiType.getTileClass(), true)) == null) {
            return null;
        }
        switch (guiType) {
            case TELESCOPE: {
                return new GuiTelescope(player, (TileTelescope)t);
            }
            case HAND_TELESCOPE: {
                return new GuiHandTelescope();
            }
            case CONSTELLATION_PAPER: {
                IConstellation c = ConstellationRegistry.getConstellationById(x);
                if (c == null) {
                    AstralSorcery.log.info("Tried opening ConstellationPaper GUI with out-of-range constellation id!");
                    return null;
                }
                return new GuiConstellationPaper(c);
            }
            case ALTAR_DISCOVERY: {
                return new GuiAltarDiscovery(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_ATTUNEMENT: {
                return new GuiAltarAttunement(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_CONSTELLATION: {
                return new GuiAltarConstellation(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_TRAIT: {
                return new GuiAltarTrait(player.field_71071_by, (TileAltar)t);
            }
            case MAP_DRAWING: {
                return new GuiMapDrawing((TileMapDrawingTable)t);
            }
            case JOURNAL: {
                return GuiJournalProgression.getOpenJournalInstance();
            }
            case JOURNAL_STORAGE: {
                ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
                if (!held.func_190926_b() && held.func_77973_b() instanceof ItemJournal) {
                    return new GuiJournalContainer(player.field_71071_by, held, player.field_71071_by.field_70461_c);
                }
            }
            case OBSERVATORY: {
                return new GuiObservatory(player, (TileObservatory)t);
            }
            case SEXTANT: {
                Tuple<EnumHand, ItemStack> heldSextant = MiscUtils.getMainOrOffHand((EntityLivingBase)player, ItemsAS.sextant);
                if (heldSextant != null) {
                    return new GuiSextantSelector((ItemStack)heldSextant.value, (EnumHand)heldSextant.key);
                }
            }
            case KNOWLEDGE_CONSTELLATION: {
                Tuple<EnumHand, ItemStack> handFragment = MiscUtils.getMainOrOffHand((EntityLivingBase)player, ItemsAS.knowledgeFragment);
                Tuple<IConstellation, List<MoonPhase>> cstInfo = ItemKnowledgeFragment.getConstellationInformation((ItemStack)handFragment.value);
                if (cstInfo == null) break;
                return new GuiKnowledgeFragment((IConstellation)cstInfo.key, (List)cstInfo.value);
            }
        }
        return null;
    }
}

