/*
 * Decompiled with CFR 0.152.
 */
package com.deflatedpickle.heartdrops.configs;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="heartdrops")
@Config(modid="heartdrops", name="heartdrops", category="general")
@Config.LangKey(value="config.heartdrops.general")
public class GeneralConfig {
    @Config.Name(value="Drop Range")
    @Config.Comment(value={"The range of hearts that can drop"})
    @Config.LangKey(value="config.heartdrops.dropRange")
    public static Integer dropRange = 3;
    @Config.Name(value="Default Drop Amount")
    @Config.Comment(value={"Changes the default amount of hearts that will drop from mobs who don't implement IDropHearts."})
    @Config.LangKey(value="config.heartdrops.defaultAmount")
    public static Integer defaultAmount = 1;
    @Config.Name(value="Golden Heart Chance")
    @Config.Comment(value={"The chance for a golden heart to drop (lower = more chance, higher = less chance)."})
    @Config.LangKey(value="config.heartdrops.goldHeartChance")
    public static Integer goldHeartChance = 50;
    @Config.Name(value="Golden Heart Looting Multiplier")
    @Config.Comment(value={"A multiplier that increases your chance to get a golden heart."})
    @Config.LangKey(value="config.heartdrops.goldHeartLootingMultiplier")
    public static Integer goldHeartLootingMultiplier = 5;
    @Config.Name(value="Drop Golden Hearts")
    @Config.Comment(value={"Whether or not golden hearts will drop."})
    @Config.LangKey(value="config.heartdrops.dropGoldHearts")
    public static Boolean dropGoldHearts = true;
    @Config.Name(value="Drop When")
    @Config.Comment(value={"Changes when the hearts will drop."})
    @Config.LangKey(value="config.heartdrops.dropWhen")
    public static When dropWhen = When.HURT;
    @Config.Name(value="Drop On Hardcore")
    @Config.Comment(value={"Changes whether hearts drop on hardcore mode or not."})
    @Config.LangKey(value="config.heartdrops.dropHardcore")
    public static Boolean dropHardcore = false;
    @Config.Name(value="Drop On Difficulty")
    @Config.Comment(value={"Changes what difficulty hearts drop on."})
    @Config.LangKey(value="config.heartdrops.dropGamemode")
    public static Difficulty dropDifficulty = Difficulty.ALL;

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("heartdrops")) {
            ConfigManager.sync((String)"heartdrops", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static enum GameMode {
        SURVIVAL,
        CREATIVE,
        ADVENTURE,
        ALL;

    }

    public static enum Difficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD,
        ALL;

    }

    public static enum When {
        HURT,
        ALWAYS,
        NEVER;

    }
}

