/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static boolean hasTag(NBTTagCompound nbt, String keyName) {
        return nbt != null && nbt.func_74764_b(keyName);
    }

    public static void removeTag(NBTTagCompound nbt, String keyName) {
        if (nbt != null) {
            nbt.func_82580_o(keyName);
        }
    }

    private static void initNBTTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public static NBTTagList getList(ItemStack stack, String tag, int objtype, boolean nullifyOnFail) {
        NBTHelper.initNBTTagCompound(stack);
        return NBTHelper.hasTag(stack.func_77978_p(), tag) ? stack.func_77978_p().func_150295_c(tag, objtype) : (nullifyOnFail ? null : new NBTTagList());
    }

    public static void setList(ItemStack stack, String tag, NBTTagList list) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74782_a(tag, (NBTBase)list);
    }

    public static NBTTagList createList(NBTBase ... list) {
        NBTTagList tagList = new NBTTagList();
        for (NBTBase b : list) {
            tagList.func_74742_a(b);
        }
        return tagList;
    }

    public static NBTTagList createList(List<NBTBase> list) {
        NBTTagList tagList = new NBTTagList();
        for (NBTBase b : list) {
            tagList.func_74742_a(b);
        }
        return tagList;
    }

    public static String getString(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            return null;
        }
        return stack.func_77978_p().func_74779_i(keyName);
    }

    public static void setString(ItemStack stack, String keyName, String keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        if (keyValue != null) {
            stack.func_77978_p().func_74778_a(keyName, keyValue);
        }
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setBoolean(stack, keyName, false);
        }
        return stack.func_77978_p().func_74767_n(keyName);
    }

    public static void setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74757_a(keyName, keyValue);
    }

    public static byte getByte(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setByte(stack, keyName, (byte)0);
        }
        return stack.func_77978_p().func_74771_c(keyName);
    }

    public static void setByte(ItemStack stack, String keyName, byte keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74774_a(keyName, keyValue);
    }

    public static short getShort(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setShort(stack, keyName, (short)0);
        }
        return stack.func_77978_p().func_74765_d(keyName);
    }

    public static void setShort(ItemStack stack, String keyName, short keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74777_a(keyName, keyValue);
    }

    public static int getInteger(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setInteger(stack, keyName, 0);
        }
        return stack.func_77978_p().func_74762_e(keyName);
    }

    public static void setInteger(ItemStack stack, String keyName, int keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74768_a(keyName, keyValue);
    }

    public static long getLong(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setLong(stack, keyName, 0L);
        }
        return stack.func_77978_p().func_74763_f(keyName);
    }

    public static void setLong(ItemStack stack, String keyName, long keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74772_a(keyName, keyValue);
    }

    public static float getFloat(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setFloat(stack, keyName, 0.0f);
        }
        return stack.func_77978_p().func_74760_g(keyName);
    }

    public static void setFloat(ItemStack stack, String keyName, float keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74776_a(keyName, keyValue);
    }

    public static double getDouble(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setDouble(stack, keyName, 0.0);
        }
        return stack.func_77978_p().func_74769_h(keyName);
    }

    public static void setDouble(ItemStack stack, String keyName, double keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        stack.func_77978_p().func_74780_a(keyName, keyValue);
    }

    public static ItemStack getItemStack(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setItemStack(stack, keyName, null);
        }
        NBTTagCompound res = (NBTTagCompound)stack.func_77978_p().func_74781_a(keyName);
        return new ItemStack(res);
    }

    public static void setItemStack(ItemStack stack, String keyName, ItemStack keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        NBTTagCompound res = new NBTTagCompound();
        if (keyValue != null) {
            keyValue.func_77955_b(res);
        }
        stack.func_77978_p().func_74782_a(keyName, (NBTBase)res);
    }

    public static <E extends Enum<E>> E getEnum(ItemStack stack, String keyName, Class<E> clazz) {
        NBTHelper.initNBTTagCompound(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            return null;
        }
        String s = stack.func_77978_p().func_74779_i(keyName);
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!e.toString().equals(s)) continue;
            return (E)e;
        }
        return null;
    }

    public static <E extends Enum<E>> void setEnum(ItemStack stack, String keyName, E keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        if (keyValue != null) {
            stack.func_77978_p().func_74778_a(keyName, keyValue.toString());
        }
    }

    public static List<String> getStringList(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        ArrayList<String> lis = new ArrayList<String>();
        int size = NBTHelper.getInteger(stack, keyName + "Size");
        for (int i = 0; i < size; ++i) {
            lis.add(NBTHelper.getString(stack, keyName + ":" + i));
        }
        return lis;
    }

    public static void setStringList(ItemStack stack, String keyName, List<String> keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        if (keyValue != null) {
            NBTHelper.setInteger(stack, keyName + "Size", keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                String s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setString(stack, keyName + ":" + i, s);
            }
        }
    }

    public static List<Boolean> getBooleanList(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        ArrayList<Boolean> lis = new ArrayList<Boolean>();
        int size = NBTHelper.getInteger(stack, keyName + "Size");
        for (int i = 0; i < size; ++i) {
            lis.add(NBTHelper.getBoolean(stack, keyName + ":" + i));
        }
        return lis;
    }

    public static void setBooleanList(ItemStack stack, String keyName, List<Boolean> keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        if (keyValue != null) {
            NBTHelper.setInteger(stack, keyName + "Size", keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Boolean s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setBoolean(stack, keyName + ":" + i, s);
            }
        }
    }

    public static List<Integer> getIntegerList(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        ArrayList<Integer> lis = new ArrayList<Integer>();
        int size = NBTHelper.getInteger(stack, keyName + "Size");
        for (int i = 0; i < size; ++i) {
            lis.add(NBTHelper.getInteger(stack, keyName + ":" + i));
        }
        return lis;
    }

    public static void setIntegerList(ItemStack stack, String keyName, List<Integer> keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        if (keyValue != null) {
            NBTHelper.setInteger(stack, keyName + "Size", keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Integer s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setInteger(stack, keyName + ":" + i, s);
            }
        }
    }

    public static List<Double> getDoubleList(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        ArrayList<Double> lis = new ArrayList<Double>();
        int size = NBTHelper.getInteger(stack, keyName + "Size");
        for (int i = 0; i < size; ++i) {
            lis.add(NBTHelper.getDouble(stack, keyName + ":" + i));
        }
        return lis;
    }

    public static void setDoubleList(ItemStack stack, String keyName, List<Double> keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        if (keyValue != null) {
            NBTHelper.setInteger(stack, keyName + "Size", keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                Double s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setDouble(stack, keyName + ":" + i, s);
            }
        }
    }

    public static List<ItemStack> getItemStackList(ItemStack stack, String keyName) {
        NBTHelper.initNBTTagCompound(stack);
        ArrayList<ItemStack> lis = new ArrayList<ItemStack>();
        int size = NBTHelper.getInteger(stack, keyName + "Size");
        for (int i = 0; i < size; ++i) {
            lis.add(NBTHelper.getItemStack(stack, keyName + ":" + i));
        }
        return lis;
    }

    public static void setItemStackList(ItemStack stack, String keyName, List<ItemStack> keyValue) {
        NBTHelper.initNBTTagCompound(stack);
        if (keyValue != null) {
            NBTHelper.setInteger(stack, keyName + "Size", keyValue.size());
            for (int i = 0; i < keyValue.size(); ++i) {
                ItemStack s = keyValue.get(i);
                if (s == null) continue;
                NBTHelper.setItemStack(stack, keyName + ":" + i, s);
            }
        }
    }
}

