/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.gui.fb;

import com.lothrazar.cyclicmagic.ModCyclic;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.gui.IStorageContainer;
import mrriegel.storagenetwork.network.StackRefreshClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import shadows.fastbench.gui.ContainerFastBench;
import shadows.fastbench.gui.SlotCraftingSucks;

public abstract class ContainerFastNetworkCrafter
extends ContainerFastBench
implements IStorageContainer {
    protected boolean forceSync = true;
    protected final World field_75161_g;
    protected final EntityPlayer field_192390_i;

    public ContainerFastNetworkCrafter(EntityPlayer player, World world, BlockPos pos) {
        super(player, world, pos);
        if (player.field_70170_p.field_72995_K != world.field_72995_K) {
            throw new RuntimeException("Player and World remoteness are not the same!");
        }
        this.field_75161_g = world;
        this.field_192390_i = player;
        this.useNormalTransfer = true;
    }

    @Override
    public abstract TileMaster getTileMaster();

    public abstract void bindHotbar(EntityPlayer var1);

    protected void bindPlayerInvo(InventoryPlayer playerInv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 174 + i * 18));
            }
        }
    }

    protected void bindGrid() {
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.field_75162_e, index++, 8 + j * 18, 110 + i * 18));
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        if (this.field_75161_g.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack slotCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            slotCopy = slotStack.func_77946_l();
            TileMaster tileMaster = this.getTileMaster();
            if (tileMaster == null) {
                return ItemStack.field_190927_a;
            }
            if (index == 0) {
                int num = slotCopy.func_77976_d() / slotCopy.func_190916_E();
                IRecipe rec = this.lastRecipe;
                for (int i = 0; i < num && rec == this.lastRecipe; ++i) {
                    try {
                        super.func_82846_b(player, index);
                        continue;
                    }
                    catch (Throwable e) {
                        ModCyclic.logger.error("Caught third party error trying to transfer stack", new Object[]{e});
                    }
                }
                return ItemStack.field_190927_a;
            }
            if (tileMaster != null) {
                int rest = tileMaster.insertStack(slotStack, false);
                ItemStack stack = rest == 0 ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)slotStack, (int)rest);
                slot.func_75215_d(stack);
                this.func_75142_b();
                List<ItemStack> list = tileMaster.getStacks();
                PacketRegistry.INSTANCE.sendTo((IMessage)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), (EntityPlayerMP)player);
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(player, slotStack);
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
            if (slotStack.func_190916_E() == slotCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return super.func_82846_b(player, index);
    }

    @Override
    public InventoryCrafting getCraftMatrix() {
        return this.field_75162_e;
    }

    @Override
    public void slotChanged() {
    }

    public static final void tryRestockGridEntirely(InventoryCrafting matrix, SlotCraftingNetwork slot, IRecipe recipe, ItemStack[] requests) {
        if (slot.getTileMaster() == null) {
            return;
        }
        boolean simple = true;
        for (Ingredient ing : recipe.func_192400_c()) {
            if (ing.isSimple()) continue;
            simple = false;
            break;
        }
        boolean one = false;
        boolean two = false;
        for (ItemStack i : requests) {
            if (!i.func_190926_b()) {
                one = true;
                continue;
            }
            if (!one || i.func_190926_b()) continue;
            two = true;
            break;
        }
        if (!simple) {
            for (int i = 0; i < 9; ++i) {
                ItemStack cached;
                if (!matrix.func_70301_a(i).func_190926_b() || (cached = requests[i]).func_190926_b()) continue;
                matrix.field_70466_a.set(i, (Object)slot.getTileMaster().request(new ItemStackMatcher(cached, true, false, cached.func_77942_o()), two ? 1 : cached.func_77976_d(), false));
            }
            return;
        }
        ItemStack requested = new ItemStack[9];
        Arrays.fill((Object[])requested, ItemStack.field_190927_a);
        boolean matrixFull = true;
        for (int i = 0; i < 9; ++i) {
            if (!matrix.func_70301_a(i).func_190926_b()) continue;
            ItemStack cached = requests[i];
            if (!cached.func_190926_b()) {
                requested[i] = slot.getTileMaster().request(new ItemStackMatcher(cached, true, false, cached.func_77942_o()), cached.func_77976_d(), false);
            }
            matrixFull = false;
        }
        if (matrixFull) {
            return;
        }
        Int2IntOpenHashMap collected = new Int2IntOpenHashMap();
        for (ItemStack s : requested) {
            if (s.func_190926_b()) continue;
            int stack = RecipeItemHelper.func_194113_b((ItemStack)s);
            int num = collected.get(stack);
            collected.put(stack, num + s.func_190916_E());
        }
        Int2IntOpenHashMap types = new Int2IntOpenHashMap();
        for (ItemStack s : requests) {
            if (s.func_190926_b()) continue;
            int stack = RecipeItemHelper.func_194113_b((ItemStack)s);
            int num = types.get(stack);
            types.put(stack, ++num);
        }
        Int2IntOpenHashMap taken = new Int2IntOpenHashMap();
        for (int i = 0; i < 9; ++i) {
            int desired;
            float available;
            ItemStack oldStack = requests[i];
            ItemStack curStack = matrix.func_70301_a(i);
            if (!curStack.func_190926_b()) {
                int curStackPack = RecipeItemHelper.func_194113_b((ItemStack)curStack);
                available = collected.get(curStackPack);
                desired = Math.max(curStack.func_190916_E(), Math.min((int)Math.floor(available / (float)types.get(curStackPack)), curStack.func_77976_d()));
                taken.put(curStackPack, taken.get(curStackPack) + desired - curStack.func_190916_E());
                curStack.func_190920_e(desired);
                continue;
            }
            if (oldStack.func_190926_b()) continue;
            int oldStackPack = RecipeItemHelper.func_194113_b((ItemStack)oldStack);
            available = collected.get(oldStackPack);
            desired = Math.min((int)Math.floor(available / (float)types.get(oldStackPack)), oldStack.func_77976_d());
            taken.put(oldStackPack, taken.get(oldStackPack) + desired);
            ItemStack stack = oldStack.func_77946_l();
            stack.func_190920_e(desired);
            matrix.field_70466_a.set(i, (Object)stack);
        }
        for (Int2IntMap.Entry ent : taken.int2IntEntrySet()) {
            int collect = collected.get(ent.getIntKey());
            collected.put(ent.getIntKey(), collect -= ent.getIntValue());
        }
        TileMaster master = slot.getTileMaster();
        for (Int2IntMap.Entry ent : collected.int2IntEntrySet()) {
            ItemStack s = RecipeItemHelper.func_194115_b((int)ent.getIntKey());
            for (int num = ent.getIntValue(); num > 0; num -= s.func_190916_E()) {
                if (num > s.func_77976_d()) {
                    ItemStack n = s.func_77946_l();
                    n.func_190920_e(s.func_77976_d());
                    num -= n.func_190916_E();
                    master.insertStack(n, false);
                }
                s.func_190920_e(num);
                master.insertStack(s, false);
            }
        }
    }

    protected final class SlotCraftingNetwork
    extends SlotCraftingSucks {
        protected TileMaster tileMaster;

        public SlotCraftingNetwork(EntityPlayer player, InventoryCrafting matrix, InventoryCraftResult result, int index, int x, int y) {
            super((ContainerFastBench)ContainerFastNetworkCrafter.this, player, matrix, result, index, x, y);
        }

        public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
            if (!ContainerFastNetworkCrafter.this.field_75161_g.field_72995_K) {
                ItemStack[] lastItems = new ItemStack[9];
                for (int i = 0; i < 9; ++i) {
                    lastItems[i] = this.field_75239_a.func_70301_a(i).func_77946_l();
                }
                IRecipe rec = ContainerFastNetworkCrafter.this.lastRecipe;
                ItemStack take = super.func_190901_a(player, stack);
                if (!ContainerFastNetworkCrafter.this.field_75161_g.field_72995_K) {
                    ContainerFastNetworkCrafter.tryRestockGridEntirely(this.field_75239_a, this, rec, lastItems);
                }
                ContainerFastNetworkCrafter.this.func_75130_a((IInventory)this.field_75239_a);
                ContainerFastNetworkCrafter.this.func_75142_b();
                if (ContainerFastNetworkCrafter.this.lastRecipe != null && player instanceof EntityPlayerMP) {
                    EntityPlayerMP mp = (EntityPlayerMP)player;
                    mp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(ContainerFastNetworkCrafter.this.field_75152_c, 0, ContainerFastNetworkCrafter.this.lastRecipe.func_77571_b()));
                }
                ContainerFastNetworkCrafter.this.forceSync = true;
                return take;
            }
            return stack;
        }

        public TileMaster getTileMaster() {
            return this.tileMaster;
        }

        public void setTileMaster(TileMaster tileMaster) {
            this.tileMaster = tileMaster;
        }
    }
}

