/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.capability.IConnectable;
import mrriegel.storagenetwork.api.capability.IConnectableItemAutoIO;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.api.data.EnumStorageDirection;
import mrriegel.storagenetwork.api.data.EnumUpgradeType;
import mrriegel.storagenetwork.api.data.IItemStackMatcher;
import mrriegel.storagenetwork.api.network.INetworkMaster;
import mrriegel.storagenetwork.capabilities.CapabilityConnectable;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.util.inventory.FilterItemStackHandler;
import mrriegel.storagenetwork.util.inventory.UpgradesItemStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityConnectableAutoIO
implements INBTSerializable<NBTTagCompound>,
IConnectableItemAutoIO {
    public IConnectable connectable;
    public EnumStorageDirection direction;
    public UpgradesItemStackHandler upgrades = new UpgradesItemStackHandler();
    public FilterItemStackHandler filters = new FilterItemStackHandler();
    public ItemStack operationStack = ItemStack.field_190927_a;
    public int operationLimit = 0;
    public boolean operationMustBeSmaller = true;
    public int priority = 0;
    protected EnumFacing inventoryFace;

    public CapabilityConnectableAutoIO(EnumStorageDirection direction) {
        this.connectable = new CapabilityConnectable();
        this.direction = direction;
    }

    public CapabilityConnectableAutoIO(TileEntity tile, EnumStorageDirection direction) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null);
        this.direction = direction;
        if (direction == EnumStorageDirection.OUT) {
            this.filters.setIsWhitelist(true);
        }
    }

    public void setInventoryFace(EnumFacing inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = new NBTTagCompound();
        NBTTagCompound upgrades = this.upgrades.serializeNBT();
        result.func_74782_a("upgrades", (NBTBase)upgrades);
        NBTTagCompound filters = this.filters.serializeNBT();
        result.func_74782_a("filters", (NBTBase)filters);
        NBTTagCompound operation = new NBTTagCompound();
        operation.func_74782_a("stack", (NBTBase)this.operationStack.serializeNBT());
        operation.func_74757_a("mustBeSmaller", this.operationMustBeSmaller);
        operation.func_74768_a("limit", this.operationLimit);
        result.func_74782_a("operation", (NBTBase)operation);
        result.func_74768_a("prio", this.priority);
        if (this.inventoryFace != null) {
            result.func_74778_a("inventoryFace", this.inventoryFace.toString());
        }
        return result;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound upgrades = nbt.func_74775_l("upgrades");
        this.upgrades.deserializeNBT(upgrades);
        NBTTagCompound filters = nbt.func_74775_l("filters");
        this.filters.deserializeNBT(filters);
        NBTTagCompound operation = nbt.func_74775_l("operation");
        this.operationLimit = operation.func_74762_e("limit");
        this.operationMustBeSmaller = operation.func_74767_n("mustBeSmaller");
        this.operationStack = operation.func_150297_b("stack", 10) ? new ItemStack(operation.func_74775_l("stack")) : ItemStack.field_190927_a;
        this.priority = nbt.func_74762_e("prio");
        if (nbt.func_74764_b("inventoryFace")) {
            this.inventoryFace = EnumFacing.func_176739_a((String)nbt.func_74779_i("inventoryFace"));
        }
    }

    @Override
    public EnumStorageDirection ioDirection() {
        return this.direction;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getTransferRate() {
        return this.upgrades.getUpgradesOfType(EnumUpgradeType.STACK) > 0 ? 64 : 4;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.direction == EnumStorageDirection.IN) {
            return stack;
        }
        if (this.inventoryFace == null) {
            return stack;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
    }

    public List<ItemStack> getStacksForFilter() {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            StorageNetwork.error("getStacksForFilter    null itemhandler connection ");
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b()) continue;
            StorageNetwork.log(slot + "getStacksForFilter    " + stack + this.filters.exactStackAlreadyInList(stack));
            if (this.filters.exactStackAlreadyInList(stack)) continue;
            result.add(stack.func_77946_l());
            StorageNetwork.log("getStacksForFilter   size up   " + result.size());
            if (result.size() < 18) continue;
            return result;
        }
        return result;
    }

    @Override
    public ItemStack extractNextStack(int size, boolean simulate) {
        if (this.direction == EnumStorageDirection.OUT) {
            return ItemStack.field_190927_a;
        }
        if (this.inventoryFace == null) {
            return ItemStack.field_190927_a;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b() || this.filters.isStackFiltered(stack)) continue;
            int extractSize = Math.min(size, stack.func_190916_E());
            return itemHandler.extractItem(slot, extractSize, simulate);
        }
        return ItemStack.field_190927_a;
    }

    private boolean doesPassOperationFilterLimit(INetworkMaster master) {
        if (this.upgrades.getUpgradesOfType(EnumUpgradeType.OPERATION) < 1) {
            return true;
        }
        if (this.operationStack == null || this.operationStack.func_190926_b()) {
            return true;
        }
        ItemStack availableStack = master.getAmount(new ItemStackMatcher(this.operationStack, this.filters.meta, this.filters.ores, this.filters.nbt));
        if (this.operationMustBeSmaller) {
            return this.operationLimit >= availableStack.func_190916_E();
        }
        return this.operationLimit < availableStack.func_190916_E();
    }

    @Override
    public boolean runNow(DimPos connectablePos, INetworkMaster master) {
        int speed = Math.max(this.upgrades.getUpgradesOfType(EnumUpgradeType.SPEED) + 1, 1);
        int speedRatio = 30 / speed;
        if (speedRatio <= 1) {
            speedRatio = 1;
        }
        boolean cooldownOk = connectablePos.getWorld().func_82737_E() % (long)speedRatio == 0L;
        boolean operationLimitOk = this.doesPassOperationFilterLimit(master);
        return cooldownOk && operationLimitOk;
    }

    @Override
    public List<IItemStackMatcher> getAutoExportList() {
        return this.filters.getStackMatchers();
    }

    @Override
    public boolean isStockMode() {
        return this.upgrades.getUpgradesOfType(EnumUpgradeType.STOCK) > 0;
    }

    @Override
    public EnumFacing facingInventory() {
        return this.inventoryFace;
    }

    public static class Storage
    implements Capability.IStorage<IConnectableItemAutoIO> {
        @Nullable
        public NBTBase writeNBT(Capability<IConnectableItemAutoIO> capability, IConnectableItemAutoIO rawInstance, EnumFacing side) {
            CapabilityConnectableAutoIO instance = (CapabilityConnectableAutoIO)rawInstance;
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IConnectableItemAutoIO> capability, IConnectableItemAutoIO rawInstance, EnumFacing side, NBTBase nbt) {
            CapabilityConnectableAutoIO instance = (CapabilityConnectableAutoIO)rawInstance;
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }

    public static class Factory
    implements Callable<IConnectableItemAutoIO> {
        @Override
        public IConnectableItemAutoIO call() throws Exception {
            return new CapabilityConnectableAutoIO(EnumStorageDirection.IN);
        }
    }
}

