/*
 * Decompiled with CFR 0.152.
 */
package leppa.planarartifice.tiles;

import javax.annotation.Nullable;
import leppa.planarartifice.potion.PotionCatalouges;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TilePotionMixer
extends TileEntity
implements ITickable,
IAspectContainer,
IEssentiaTransport {
    public ItemStackHandler inventory = new ItemStackHandler(7);
    public int currentProgress;
    public int maxProgress = 200;
    public AspectList recipe = new AspectList();
    public AspectList recipeProgress = new AspectList();
    public Aspect currentSuction = null;
    public PotionCatalouges currentPossibilities;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("currentProgress", this.currentProgress);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.currentProgress = compound.func_74762_e("currentProgress");
        super.func_145839_a(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public void func_73660_a() {
        ItemStack catalyst = this.inventory.getStackInSlot(3);
        if (catalyst == null) {
            this.currentPossibilities = null;
        } else if (catalyst.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150331_J)) {
            this.currentPossibilities = PotionCatalouges.piston;
        } else if (catalyst.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150432_aD)) {
            this.currentPossibilities = PotionCatalouges.ice;
        } else if (catalyst.func_77973_b() == Items.field_151042_j) {
            this.currentPossibilities = PotionCatalouges.iron;
        } else if (catalyst.func_77973_b() == Items.field_151034_e) {
            this.currentPossibilities = PotionCatalouges.apple;
        } else if (catalyst.func_77973_b() == Items.field_151115_aP && catalyst.func_77952_i() == 3) {
            this.currentPossibilities = PotionCatalouges.pufferfish;
        } else if (catalyst.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150359_w)) {
            this.currentPossibilities = PotionCatalouges.glass;
        } else if (catalyst.func_77973_b() == Items.field_151078_bh) {
            this.currentPossibilities = PotionCatalouges.rotten_flesh;
        } else if (catalyst.func_77973_b() == Items.field_151043_k) {
            this.currentPossibilities = PotionCatalouges.gold;
        }
    }

    public boolean isConnectable(EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN;
    }

    public boolean canInputFrom(EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN;
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
        this.currentSuction = aspect;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return this.currentSuction;
    }

    public int getSuctionAmount(EnumFacing face) {
        return this.currentSuction != null ? 128 : 0;
    }

    public int takeEssentia(Aspect aspect, int amount, EnumFacing face) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, EnumFacing face) {
        return 0;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return null;
    }

    public int getEssentiaAmount(EnumFacing face) {
        return 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public AspectList getAspects() {
        return this.recipeProgress;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    public int addToContainer(Aspect tag, int amount) {
        int ce = this.recipe.getAmount(tag) - this.recipeProgress.getAmount(tag);
        if (this.recipe == null || ce <= 0) {
            return amount;
        }
        int add = Math.min(ce, amount);
        this.recipeProgress.add(tag, add);
        this.func_70296_d();
        return amount - add;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.recipeProgress.getAmount(tag) >= amount) {
            this.recipeProgress.remove(tag, amount);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.recipeProgress.getAmount(tag) >= amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return this.recipeProgress.getAmount(tag);
    }
}

