/*
 * Decompiled with CFR 0.152.
 */
package leppa.planarartifice.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusMedium;
import thaumcraft.api.casters.FocusMediumRoot;
import thaumcraft.api.casters.FocusMod;
import thaumcraft.api.casters.FocusModSplit;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.casters.Trajectory;

public class PAFocusEngine {
    private static ArrayList<String> damageResistList = new ArrayList();
    static HashMap<Integer, Long> cooldownServer = new HashMap();
    static HashMap<Integer, Long> cooldownClient = new HashMap();

    public static void castFocusPackageWithMultiplier(EntityLivingBase caster, FocusPackage focusPackage, boolean nocopy, float multiplier) {
        FocusPackage focusPackageCopy = nocopy ? focusPackage : focusPackage.copy(caster);
        focusPackageCopy.initialize(caster);
        focusPackageCopy.setUniqueID(UUID.randomUUID());
        for (FocusEffect effect : focusPackageCopy.getFocusEffects()) {
            effect.onCast((Entity)caster);
        }
        PAFocusEngine.runFocusPackageWithEffectMultiplier(focusPackageCopy, null, null, multiplier);
    }

    public static void castFocusPackageWithMultiplier(EntityLivingBase caster, FocusPackage focusPackage, float multiplier) {
        PAFocusEngine.castFocusPackageWithMultiplier(caster, focusPackage, false, multiplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runFocusPackageWithEffectMultiplier(FocusPackage focusPackage, Trajectory[] trajectories, RayTraceResult[] targets, float multiplier) {
        List list;
        Trajectory[] prevTrajectories = trajectories;
        RayTraceResult[] prevTargets = targets;
        List list2 = list = focusPackage.nodes;
        synchronized (list2) {
            if (!(focusPackage.nodes.get(0) instanceof FocusMediumRoot)) {
                focusPackage.nodes.add(0, new FocusMediumRoot(trajectories, targets));
            }
            for (int idx = 0; idx < focusPackage.nodes.size(); ++idx) {
                focusPackage.setExecutionIndex(idx);
                IFocusElement node = (IFocusElement)focusPackage.nodes.get(idx);
                if (idx > 0 && ((FocusNode)node).getParent() == null) {
                    IFocusElement nodePrev = (IFocusElement)focusPackage.nodes.get(idx - 1);
                    if (node instanceof FocusNode && nodePrev instanceof FocusNode) {
                        ((FocusNode)node).setParent((FocusNode)nodePrev);
                    }
                }
                if (node instanceof FocusNode && ((FocusNode)node).getPackage() == null) {
                    ((FocusNode)node).setPackage(focusPackage);
                }
                if (node instanceof FocusNode) {
                    focusPackage.multiplyPower(((FocusNode)node).getPowerMultiplier());
                }
                if (node instanceof FocusPackage) {
                    FocusEngine.runFocusPackage((FocusPackage)((FocusPackage)node), (Trajectory[])prevTrajectories, (RayTraceResult[])prevTargets);
                    break;
                }
                if (node instanceof FocusMedium) {
                    FocusMedium medium = (FocusMedium)node;
                    if (prevTrajectories != null) {
                        for (Trajectory trajectory : prevTrajectories) {
                            medium.execute(trajectory);
                        }
                    }
                    if (medium.hasIntermediary()) {
                        break;
                    }
                } else if (node instanceof FocusMod) {
                    if (node instanceof FocusModSplit) {
                        FocusModSplit split = (FocusModSplit)node;
                        for (FocusPackage sp : split.getSplitPackages()) {
                            split.setPackage(sp);
                            sp.multiplyPower(focusPackage.getPower());
                            split.execute();
                            FocusEngine.runFocusPackage((FocusPackage)sp, (Trajectory[])split.supplyTrajectories(), (RayTraceResult[])split.supplyTargets());
                        }
                        break;
                    }
                    ((FocusMod)node).execute();
                } else if (node instanceof FocusEffect) {
                    focusPackage.multiplyPower(multiplier);
                    FocusEffect effect = (FocusEffect)node;
                    if (prevTargets != null) {
                        int num = 0;
                        for (RayTraceResult target : prevTargets) {
                            if (target.field_72308_g != null) {
                                String k = "" + target.field_72308_g.func_145782_y() + focusPackage.getUniqueID().toString();
                                if (damageResistList.contains(k) && target.field_72308_g.field_70172_ad > 0) {
                                    target.field_72308_g.field_70172_ad = 0;
                                } else {
                                    if (damageResistList.size() > 10) {
                                        damageResistList.remove(0);
                                    }
                                    damageResistList.add(k);
                                }
                            }
                            Trajectory tra = prevTrajectories != null ? (prevTrajectories.length == prevTargets.length ? prevTrajectories[num] : prevTrajectories[0]) : null;
                            effect.execute(target, tra, focusPackage.getPower(), num);
                            ++num;
                        }
                    }
                }
                if (!(node instanceof FocusNode)) continue;
                prevTrajectories = ((FocusNode)node).supplyTrajectories();
                prevTargets = ((FocusNode)node).supplyTargets();
            }
        }
    }

    public static void setCooldown(EntityLivingBase entityLiving, int cd) {
        if (cd == 0) {
            cooldownClient.remove(entityLiving.func_145782_y());
            cooldownServer.remove(entityLiving.func_145782_y());
        } else if (entityLiving.field_70170_p.field_72995_K) {
            cooldownClient.put(entityLiving.func_145782_y(), System.currentTimeMillis() + (long)(cd * 50));
        } else {
            cooldownServer.put(entityLiving.func_145782_y(), System.currentTimeMillis() + (long)(cd * 50));
        }
    }

    static boolean isOnCooldown(EntityLivingBase entityLiving) {
        if (entityLiving.field_70170_p.field_72995_K && cooldownClient.containsKey(entityLiving.func_145782_y())) {
            return cooldownClient.get(entityLiving.func_145782_y()) > System.currentTimeMillis();
        }
        if (!entityLiving.field_70170_p.field_72995_K && cooldownServer.containsKey(entityLiving.func_145782_y())) {
            return cooldownServer.get(entityLiving.func_145782_y()) > System.currentTimeMillis();
        }
        return false;
    }

    public static float getCooldown(EntityLivingBase entityLiving) {
        if (entityLiving.field_70170_p.field_72995_K && cooldownClient.containsKey(entityLiving.func_145782_y())) {
            return (float)(cooldownClient.get(entityLiving.func_145782_y()) - System.currentTimeMillis()) / 1000.0f;
        }
        return 0.0f;
    }
}

