/*
 * Decompiled with CFR 0.152.
 */
package leppa.planarartifice.aspects;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import leppa.planarartifice.PlanarArtifice;
import leppa.planarartifice.blocks.PABlocks;
import leppa.planarartifice.items.PAItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class PAAspects {
    public static Aspect DIMENSIONS;
    public static Aspect TIME;
    public static Aspect COLOUR;
    public static ArrayList<Color> tincturaColours;
    static Class clazz;
    static Field f;

    public static void setupColours(int x) {
        try {
            Field f = clazz.getDeclaredField("color");
            f.setAccessible(true);
            f.set(COLOUR, tincturaColours.get(x % tincturaColours.size()).getRGB());
            Aspect.aspects.put("Tinctura", COLOUR);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("A thing with colors went very wrong!");
        }
    }

    public static void init() {
        DIMENSIONS = new Aspect("Spatio", 4912981, new Aspect[]{Aspect.VOID, Aspect.ENTROPY}, new ResourceLocation("planarartifice", "textures/aspects/spatium.png"), 1);
        TIME = new Aspect("Tempus", 14080835, new Aspect[]{DIMENSIONS, Aspect.EXCHANGE}, new ResourceLocation("planarartifice", "textures/aspects/tempus.png"), 1);
        COLOUR = new Aspect("Tinctura", 0xFFFFFF, new Aspect[]{Aspect.EXCHANGE, Aspect.SENSES}, new ResourceLocation("planarartifice", "textures/aspects/tinctura.png"), 1);
        int timeToChange = 50;
        ArrayList tincturaColoursRed = new ArrayList();
        ArrayList tincturaColoursBlue = new ArrayList();
        ArrayList tincturaColoursGreen = new ArrayList();
        tincturaColoursRed.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(0.0, 255.0, timeToChange)));
        tincturaColoursGreen.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(255.0, 0.0, timeToChange)));
        tincturaColoursBlue.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(255.0, 255.0, timeToChange)));
        tincturaColoursRed.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(255.0, 255.0, timeToChange)));
        tincturaColoursGreen.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(0.0, 255.0, timeToChange)));
        tincturaColoursBlue.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(255.0, 0.0, timeToChange)));
        tincturaColoursRed.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(255.0, 0.0, timeToChange)));
        tincturaColoursGreen.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(255.0, 255.0, timeToChange)));
        tincturaColoursBlue.addAll(Ints.asList((int[])PlanarArtifice.interpolateInt(0.0, 255.0, timeToChange)));
        for (int g = 3 * timeToChange; g > 0; --g) {
            Color Q = new Color((Integer)tincturaColoursRed.get(g), (Integer)tincturaColoursGreen.get(g), (Integer)tincturaColoursBlue.get(g));
            tincturaColours.add(Q);
        }
    }

    public static void addAspectsToItems() {
        PAAspects.addAspectsToItem(new ItemStack(Items.field_151113_aN), new AspectList().add(TIME, 10));
        PAAspects.addAspectsToItem(new ItemStack(Items.field_151079_bi), new AspectList().add(DIMENSIONS, 10).add(TIME, 5));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_150477_bB), new AspectList().add(DIMENSIONS, 12));
        PAAspects.addAspectsToItem(new ItemStack(PABlocks.flux_scrubber), new AspectList().add(DIMENSIONS, 6));
        PAAspects.addAspectsToItem(new ItemStack(PAItems.dimensional_curiosity), new AspectList().add(DIMENSIONS, 25));
        PAAspects.addAspectsToItem(new ItemStack(PAItems.bismuth_ingot), new AspectList().add(DIMENSIONS, 3));
        PAAspects.addAspectsToItem(new ItemStack(PAItems.dimensional_singularity), new AspectList().add(DIMENSIONS, 30).add(TIME, 30));
        PAAspects.addAspectsToItem(new ItemStack(Items.field_151103_aS), new AspectList().add(COLOUR, 5));
        PAAspects.addAspectsToItem(new ItemStack(Items.field_151114_aO), new AspectList().add(COLOUR, 5));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_150325_L), new AspectList().add(COLOUR, 5));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_150368_y), new AspectList().add(COLOUR, 180));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_150369_x), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack((Block)Blocks.field_150328_O), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack((Block)Blocks.field_150327_N), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack((Block)Blocks.field_150434_aF), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack((Block)Blocks.field_150398_cm), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_150426_aN), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192442_dQ), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192427_dB), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192431_dF), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192438_dM), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192439_dN), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192441_dP), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192430_dE), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192434_dI), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192436_dK), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192440_dO), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192432_dG), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192429_dD), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192428_dC), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192433_dH), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192437_dL), new AspectList().add(COLOUR, 15));
        PAAspects.addAspectsToItem(new ItemStack(Blocks.field_192435_dJ), new AspectList().add(COLOUR, 15));
        for (int i = 0; i < 16; ++i) {
            PAAspects.addAspectsToItem(new ItemStack(Blocks.field_150406_ce, 1, i), new AspectList().add(COLOUR, 10));
            PAAspects.addAspectsToItem(new ItemStack(Items.field_151100_aR, 1, i), new AspectList().add(COLOUR, 20));
            PAAspects.addAspectsToItem(new ItemStack((Block)Blocks.field_150399_cn, 1, i), new AspectList().add(COLOUR, 15));
        }
        PAAspects.setItemAspects(new ItemStack(PAItems.condensed_crystal_cluster), new AspectList().add(Aspect.FIRE, 12).add(Aspect.AIR, 12).add(Aspect.EARTH, 12).add(Aspect.ORDER, 12).add(Aspect.ENTROPY, 12).add(Aspect.MAGIC, 12).add(Aspect.ENERGY, 12).add(Aspect.WATER, 12));
    }

    public static void addAspectsToItem(ItemStack itemstack, AspectList aspects) {
        ThaumcraftApi.registerObjectTag((ItemStack)itemstack, (AspectList)AspectHelper.getObjectAspects((ItemStack)itemstack).add(aspects));
    }

    public static void setItemAspects(ItemStack itemstack, AspectList aspects) {
        ThaumcraftApi.registerObjectTag((ItemStack)itemstack, (AspectList)aspects);
    }

    static {
        tincturaColours = new ArrayList();
        clazz = Aspect.class;
    }
}

