/*
 * Decompiled with CFR 0.152.
 */
package leppa.planarartifice.aspects;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public enum EnumInfusionEnchantmentII {
    TRANSMUTATIVE((Set<String>)ImmutableSet.of((Object)"axe", (Object)"pickaxe", (Object)"shovel", (Object)"weapon"), 1, "INFUSIONENCHANTMENTII"),
    AURAINFUSING((Set<String>)ImmutableSet.of((Object)"weapon"), 1, "INFUSIONENCHANTMENTII"),
    PROJECTING((Set<String>)ImmutableSet.of((Object)"weapon", (Object)"axe", (Object)"pickaxe", (Object)"shovel"), 5, "INFUSIONENCHANTMENTII");

    public Set<String> toolClasses;
    public int maxLevel;
    public String research;

    private EnumInfusionEnchantmentII(Set<String> toolClasses, int ml, String research) {
        this.toolClasses = toolClasses;
        this.maxLevel = ml;
        this.research = research;
    }

    public static NBTTagList getInfusionEnchantmentTagList(ItemStack stack) {
        return stack == null || stack.func_190926_b() || stack.func_77978_p() == null ? null : stack.func_77978_p().func_150295_c("infenchplanar", 10);
    }

    public static List<EnumInfusionEnchantmentII> getInfusionEnchantments(ItemStack stack) {
        NBTTagList nbttaglist = EnumInfusionEnchantmentII.getInfusionEnchantmentTagList(stack);
        ArrayList<EnumInfusionEnchantmentII> list = new ArrayList<EnumInfusionEnchantmentII>();
        if (nbttaglist != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (k < 0 || k >= EnumInfusionEnchantmentII.values().length) continue;
                list.add(EnumInfusionEnchantmentII.values()[k]);
            }
        }
        return list;
    }

    public static int getInfusionEnchantmentLevel(ItemStack stack, EnumInfusionEnchantmentII enchantment) {
        NBTTagList nbttaglist = EnumInfusionEnchantmentII.getInfusionEnchantmentTagList(stack);
        ArrayList list = new ArrayList();
        if (nbttaglist != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (k < 0 || k >= EnumInfusionEnchantmentII.values().length || EnumInfusionEnchantmentII.values()[k] != enchantment) continue;
                return l;
            }
        }
        return 0;
    }

    public static void addInfusionEnchantment(ItemStack stack, EnumInfusionEnchantmentII ie, int level) {
        if (stack == null || stack.func_190926_b() || level > ie.maxLevel) {
            System.out.println("uwu");
            return;
        }
        NBTTagList nbttaglist = EnumInfusionEnchantmentII.getInfusionEnchantmentTagList(stack);
        if (nbttaglist != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (k != ie.ordinal()) continue;
                if (level <= l) {
                    return;
                }
                nbttaglist.func_150305_b(j).func_74777_a("lvl", (short)level);
                stack.func_77983_a("infenchplanar", (NBTBase)nbttaglist);
                if (ie == PROJECTING) {
                    EnumInfusionEnchantmentII.handleProjecting(stack);
                }
                return;
            }
        } else {
            nbttaglist = new NBTTagList();
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74777_a("id", (short)ie.ordinal());
        nbttagcompound.func_74777_a("lvl", (short)level);
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        if (nbttaglist.func_74745_c() > 0) {
            stack.func_77983_a("infenchplanar", (NBTBase)nbttaglist);
        }
        if (ie == PROJECTING) {
            EnumInfusionEnchantmentII.handleProjecting(stack);
        }
    }

    private static void handleProjecting(ItemStack stack) {
        double reach;
        NBTTagCompound nbt = stack.func_77978_p();
        Multimap map = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        Collection reachCollection = map.get((Object)EntityPlayer.REACH_DISTANCE.func_111108_a());
        Collection damageCollection = map.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        Collection speedCollection = map.get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
        try {
            AttributeModifier reachModifier = (AttributeModifier)reachCollection.toArray()[0];
            System.out.println(reachModifier.func_111164_d());
            reach = reachModifier.func_111164_d() + 2.0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            reach = 2.0;
            System.out.println("WHAT");
        }
        AttributeModifier reachDistance = new AttributeModifier("reachDistance", reach, 0);
        AttributeModifier attackDamage = (AttributeModifier)damageCollection.toArray()[0];
        AttributeModifier attackSpeed = (AttributeModifier)speedCollection.toArray()[0];
        NBTTagCompound reachNBT = EnumInfusionEnchantmentII.writeAttributeModifierToNBT(EntityPlayer.REACH_DISTANCE, reachDistance, EntityEquipmentSlot.MAINHAND);
        NBTTagCompound damageNBT = EnumInfusionEnchantmentII.writeAttributeModifierToNBT(SharedMonsterAttributes.field_111264_e, attackDamage, EntityEquipmentSlot.MAINHAND);
        NBTTagCompound speedNBT = EnumInfusionEnchantmentII.writeAttributeModifierToNBT(SharedMonsterAttributes.field_188790_f, attackSpeed, EntityEquipmentSlot.MAINHAND);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)reachNBT);
        list.func_74742_a((NBTBase)damageNBT);
        list.func_74742_a((NBTBase)speedNBT);
        nbt.func_74782_a("AttributeModifiers", (NBTBase)list);
    }

    private static NBTTagCompound writeAttributeModifierToNBT(IAttribute attribute, AttributeModifier modifier, EntityEquipmentSlot slot) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("AttributeName", attribute.func_111108_a());
        nbt.func_74778_a("Name", modifier.func_111166_b());
        nbt.func_74778_a("Slot", slot.func_188450_d());
        nbt.func_74780_a("Amount", modifier.func_111164_d());
        nbt.func_74768_a("Operation", modifier.func_111169_c());
        nbt.func_74772_a("UUIDMost", modifier.func_111167_a().getMostSignificantBits());
        nbt.func_74772_a("UUIDLeast", modifier.func_111167_a().getLeastSignificantBits());
        return nbt;
    }
}

