/*
 * Decompiled with CFR 0.152.
 */
package leppa.planarartifice;

import baubles.api.BaublesApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import leppa.planarartifice.PlanarTab;
import leppa.planarartifice.ReflectionUtils;
import leppa.planarartifice.aspects.CrucibleRecipieRandomCrystal;
import leppa.planarartifice.aspects.EnumInfusionEnchantmentII;
import leppa.planarartifice.aspects.InfusionEnchantmentRecipeII;
import leppa.planarartifice.aspects.PAAspects;
import leppa.planarartifice.blocks.PABlocks;
import leppa.planarartifice.foci.FocusEffectColourized;
import leppa.planarartifice.foci.FocusEffectPrismLight;
import leppa.planarartifice.items.PAItems;
import leppa.planarartifice.multiblocks.PAMultiblocks;
import leppa.planarartifice.network.MessageProjectingAttack;
import leppa.planarartifice.network.PacketRequestUpdateTeleporter;
import leppa.planarartifice.network.PacketUpdateTeleporter;
import leppa.planarartifice.proxy.CommonProxy;
import leppa.planarartifice.proxy.GuiProxy;
import leppa.planarartifice.tconstruct.TConstructHandler;
import leppa.planarartifice.tiles.TileAlkimiumSmeltery;
import leppa.planarartifice.tiles.TileFluxScrubber;
import leppa.planarartifice.tiles.TilePotionMixer;
import leppa.planarartifice.tiles.TileTeleporter;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.IngredientNBTTC;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.parts.GolemMaterial;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ScanBlock;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.common.items.casters.ItemCaster;

@Mod.EventBusSubscriber
@Mod(modid="planarartifice", version="0.13", name="Planar Artifice", dependencies="required-after:thaumcraft;after:tconstruct", acceptedMinecraftVersions="[1.12.2]")
public class PlanarArtifice
implements ForgeChunkManager.LoadingCallback {
    public static final String MODID = "planarartifice";
    public static final String NAME = "Planar Artifice";
    public static final String VERSION = "0.13";
    public static final PlanarTab creativetab = new PlanarTab();
    static ResourceLocation defaultGroup = new ResourceLocation("");
    public static SimpleNetworkWrapper network;
    public static boolean isSingleplayer;
    public static ArrayList<FocusEffect> focusEffects;
    public static int currentFocusEffect;
    public static int currentColourPicked;
    static HashMap p;
    public static HashMap<UUID, ArrayList<ItemStack>> inventoriesToConserve;
    public static HashMap<Item, Item> transmutations;
    @Mod.Instance(value="planarartifice")
    public static PlanarArtifice instance;
    @SidedProxy(serverSide="leppa.planarartifice.proxy.ServerProxy", clientSide="leppa.planarartifice.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static int serverTickCount;

    public PlanarArtifice() {
        p = (HashMap)ReflectionUtils.getPrivateObject("elementColor", new FocusEngine());
        transmutations.put(Items.field_151078_bh, Items.field_151076_bf);
        transmutations.put(Items.field_151016_H, Items.field_151114_aO);
        transmutations.put(Items.field_151007_F, Items.field_151008_G);
        transmutations.put(Items.field_151079_bi, Items.field_151061_bv);
        transmutations.put(Items.field_151070_bp, Items.field_151071_bq);
        transmutations.put(Items.field_151123_aH, Items.field_151064_bs);
        transmutations.put(Items.field_151114_aO, Items.field_151065_br);
        transmutations.put(Items.field_151042_j, Items.field_151043_k);
        transmutations.put(Items.field_151043_k, Items.field_151042_j);
        transmutations.put(Items.field_191525_da, Items.field_151074_bl);
        transmutations.put(Items.field_151074_bl, Items.field_191525_da);
        transmutations.put(Items.field_151102_aT, Items.field_151137_ax);
        transmutations.put(Items.field_151137_ax, ItemsTC.salisMundus);
        transmutations.put(Items.field_151103_aS, Items.field_151044_h);
        transmutations.put(Items.field_151045_i, Items.field_151166_bC);
        transmutations.put(Items.field_151166_bC, Items.field_151045_i);
        transmutations.put(Items.field_185163_cU, Items.field_151014_N);
        transmutations.put(Items.field_151014_N, Items.field_151081_bc);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        GameRegistry.registerTileEntity(TileTeleporter.class, (ResourceLocation)new ResourceLocation("planarartifice:mirrorTeleporter"));
        GameRegistry.registerTileEntity(TileFluxScrubber.class, (ResourceLocation)new ResourceLocation("planarartifice:fluxScrubber"));
        GameRegistry.registerTileEntity(TilePotionMixer.class, (ResourceLocation)new ResourceLocation("planarartifice:potionMixer"));
        GameRegistry.registerTileEntity(TileAlkimiumSmeltery.class, (ResourceLocation)new ResourceLocation("planarartifice:alkimiumSmeltery"));
        PAAspects.init();
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage((IMessageHandler)new PacketUpdateTeleporter.Handler(), PacketUpdateTeleporter.class, 0, Side.CLIENT);
        network.registerMessage((IMessageHandler)new PacketRequestUpdateTeleporter.Handler(), PacketRequestUpdateTeleporter.class, 1, Side.SERVER);
        network.registerMessage((IMessageHandler)new MessageProjectingAttack.Handler(), MessageProjectingAttack.class, 2, Side.SERVER);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiProxy());
        proxy.registerRenderers();
        if (Loader.isModLoaded((String)"tconstruct")) {
            TConstructHandler.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        System.out.println("Initialising Planar Artifice");
        proxy.init(event);
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("planarartifice:research/planarartifice.json"));
        ResearchCategories.registerCategory((String)"PLANARARTIFICE", null, (AspectList)new AspectList().add(Aspect.AURA, 1), (ResourceLocation)new ResourceLocation("planarartifice:textures/research/cat_planarartifice.png"), (ResourceLocation)new ResourceLocation("planarartifice:textures/research/gui_research_back_2.jpg"));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimium_ingot"), (CrucibleRecipe)new CrucibleRecipe("METALLURGY@2", new ItemStack(PAItems.alkimium_ingot), (Object)new ItemStack(ItemsTC.ingots, 1, 2), new AspectList().add(Aspect.ALCHEMY, 5).add(Aspect.ORDER, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:magic_apple"), (CrucibleRecipe)new CrucibleRecipe("RAREITEMS@4", new ItemStack(PAItems.magic_apple), (Object)new ItemStack(Items.field_151034_e), new AspectList().add(Aspect.MAGIC, 10).add(Aspect.LIFE, 70).add(Aspect.BEAST, 25).add(Aspect.EARTH, 15)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:alchemical_scribing_tools"), (CrucibleRecipe)new CrucibleRecipe("ALCHEMICALSCIBETOOLS", new ItemStack(PAItems.alchemical_scribing_tools), (Object)new ItemStack(ItemsTC.scribingTools, 1), new AspectList().add(Aspect.AURA, 15).add(Aspect.ALCHEMY, 15)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:bismuth"), (CrucibleRecipe)new CrucibleRecipe("!Portal", new ItemStack(PAItems.bismuth_ingot), (Object)new ItemStack(ItemsTC.ingots, 1, 0), new AspectList().add(Aspect.AURA, 20).add(Aspect.ENERGY, 20)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:condensed_crystal_cluster1"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(PAItems.condensed_crystal_cluster), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.FIRE, 50)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:condensed_crystal_cluster2"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(PAItems.condensed_crystal_cluster), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.WATER, 50)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:condensed_crystal_cluster3"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(PAItems.condensed_crystal_cluster), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.AIR, 50)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:condensed_crystal_cluster4"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(PAItems.condensed_crystal_cluster), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.EARTH, 50)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:condensed_crystal_cluster5"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(PAItems.condensed_crystal_cluster), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.ORDER, 50)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:condensed_crystal_cluster6"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(PAItems.condensed_crystal_cluster), (Object)new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.ENTROPY, 50)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:random_vis_crystal1"), (CrucibleRecipe)new CrucibleRecipieRandomCrystal("MOREALCHEMY", new ItemStack(ItemsTC.salisMundus), new AspectList().add(Aspect.FLUX, 4)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:random_vis_crystal2"), (CrucibleRecipe)new CrucibleRecipieRandomCrystal("MOREALCHEMY", new ItemStack(ItemsTC.salisMundus), new AspectList().add(PAAspects.COLOUR, 20)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:endereye"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(Items.field_151061_bv), (Object)new ItemStack(Items.field_151070_bp), new AspectList().add(Aspect.FIRE, 10).add(Aspect.ELDRITCH, 20)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:redstone"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(Items.field_151137_ax), (Object)new ItemStack(Items.field_151016_H), new AspectList().add(Aspect.ENERGY, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:iron"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(Items.field_151043_k), (Object)new ItemStack(Items.field_151042_j), new AspectList().add(Aspect.DESIRE, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:gold"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(Items.field_151042_j), (Object)new ItemStack(Items.field_151043_k), new AspectList().add(Aspect.METAL, 7)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:blaze_powder"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(Items.field_151065_br, 2), (Object)new ItemStack(Items.field_151016_H), new AspectList().add(Aspect.FIRE, 14).add(Aspect.MAGIC, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:ender_pearls"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(Items.field_151079_bi, 2), (Object)new ItemStack(Items.field_151079_bi), new AspectList().add(Aspect.ELDRITCH, 20)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("planarartifice:redstone2"), (CrucibleRecipe)new CrucibleRecipe("MOREALCHEMY", new ItemStack(Items.field_151137_ax, 2), (Object)new ItemStack(Items.field_151137_ax), new AspectList().add(Aspect.ENERGY, 20)));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimium_smeltery"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "ALKIMIUMAPPLICATIONS", 100, new AspectList().add(Aspect.WATER, 1), new ItemStack(PABlocks.alkimium_smeltery), new Object[]{"#C#", "ADA", "AAA", Character.valueOf('#'), new ItemStack(PAItems.alkimium_plate, 1, 0), Character.valueOf('A'), "plateBrass", Character.valueOf('C'), new ItemStack(BlocksTC.smelterBasic), Character.valueOf('D'), new ItemStack(PABlocks.alchemical_alkimium_construct)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimium_smeltery_thaumium"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "ALKIMIUMTHAUMIUMSMELTERY", 100, new AspectList().add(Aspect.WATER, 1), new ItemStack(PABlocks.alkimium_smeltery_thaumium), new Object[]{"#C#", "ADA", "AAA", Character.valueOf('#'), new ItemStack(PAItems.alkimium_plate), Character.valueOf('A'), new ItemStack(ItemsTC.plate, 1, 2), Character.valueOf('C'), new ItemStack(PABlocks.alkimium_smeltery), Character.valueOf('D'), new ItemStack(PABlocks.alchemical_alkimium_construct)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimium_smeltery_void"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "ALKIMIUMVOIDSMELTERY@2", 100, new AspectList().add(Aspect.WATER, 1), new ItemStack(PABlocks.alkimium_smeltery_void), new Object[]{"#C#", "ADA", "AAA", Character.valueOf('#'), new ItemStack(PAItems.alkimium_plate, 1, 0), Character.valueOf('A'), new ItemStack(ItemsTC.plate, 1, 3), Character.valueOf('C'), new ItemStack(PABlocks.alkimium_smeltery_thaumium), Character.valueOf('D'), new ItemStack(BlocksTC.metalAlchemicalAdvanced)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alchemical_alkimium_construct"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "ALKIMIUM@2", 100, new AspectList().add(Aspect.WATER, 1), new ItemStack(PABlocks.alchemical_alkimium_construct), new Object[]{"#v#", "pwp", "#v#", Character.valueOf('#'), PAItems.alkimium_plate, Character.valueOf('p'), BlocksTC.tube, Character.valueOf('v'), BlocksTC.tubeValve, Character.valueOf('w'), BlocksTC.plankSilverwood}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:teleporter_matrix"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "MIRRORTELEPORTER@2", 300, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack(PABlocks.teleporter_matrix), new Object[]{"AHA", "MDM", "AHA", Character.valueOf('A'), BlocksTC.stoneArcaneBrick, Character.valueOf('M'), ItemsTC.mirroredGlass, Character.valueOf('H'), ItemsTC.alumentum, Character.valueOf('D'), PAItems.dimensional_singularity}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:teleporter_matrix2"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "MIRRORTELEPORTER@2", 300, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack(PABlocks.teleporter_matrix), new Object[]{"AHA", "MDM", "AHA", Character.valueOf('A'), BlocksTC.stoneArcaneBrick, Character.valueOf('M'), ItemsTC.mirroredGlass, Character.valueOf('H'), ItemsTC.alumentum, Character.valueOf('D'), PAItems.dimensional_curiosity}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:flux_scrubber"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "FLUXSCRUBBER", 275, new AspectList().add(Aspect.ORDER, 1).add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1), new ItemStack(PABlocks.flux_scrubber), new Object[]{"IGI", "IAI", "BQB", Character.valueOf('B'), new ItemStack(PAItems.bismuth_ingot), Character.valueOf('A'), new ItemStack(PABlocks.alchemical_alkimium_construct), Character.valueOf('G'), new ItemStack(ItemsTC.mechanismSimple), Character.valueOf('I'), "plateIron", Character.valueOf('Q'), new ItemStack(ItemsTC.alumentum)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimiumimproveddistillationaux1"), (IArcaneRecipe)new ShapelessArcaneRecipe(defaultGroup, "ALKIMIUMDISTILLATION", 70, new AspectList().add(Aspect.ORDER, 1), new ItemStack(PABlocks.smelter_aux), new Object[]{BlocksTC.smelterAux, PABlocks.alchemical_alkimium_construct}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimiumimproveddistillationaux2"), (IArcaneRecipe)new ShapelessArcaneRecipe(defaultGroup, "ALKIMIUMDISTILLATION", 70, new AspectList().add(Aspect.ORDER, 1), new ItemStack(PABlocks.smelter_vent), new Object[]{BlocksTC.smelterVent, PABlocks.alchemical_alkimium_construct}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimiumimproveddistillationaux3"), (IArcaneRecipe)new ShapelessArcaneRecipe(defaultGroup, "ALKIMIUMDISTILLATION", 70, new AspectList().add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.smelterAux), new Object[]{PABlocks.smelter_aux}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimiumimproveddistillationaux4"), (IArcaneRecipe)new ShapelessArcaneRecipe(defaultGroup, "ALKIMIUMDISTILLATION", 70, new AspectList().add(Aspect.ENTROPY, 1), new ItemStack(BlocksTC.smelterVent), new Object[]{PABlocks.smelter_vent}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:flux_vent"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "BISMUTHCASTERSGAUNTLET@1", 75, new AspectList(), new ItemStack(PAItems.flux_venting_circuit), new Object[]{" # ", "QRV", Character.valueOf('#'), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), Character.valueOf('Q'), new ItemStack(Items.field_151128_bU), Character.valueOf('R'), new ItemStack(Items.field_151107_aW), Character.valueOf('V'), new ItemStack(Blocks.field_150429_aA)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:bismuth_caster"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "BISMUTHCASTERSGAUNTLET", 175, new AspectList().add(Aspect.ORDER, 1).add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1), new ItemStack(PAItems.bismuth_caster), new Object[]{" VO", "MGB", "BB ", Character.valueOf('B'), new ItemStack(PAItems.bismuth_ingot), Character.valueOf('V'), new ItemStack(PAItems.flux_venting_circuit), Character.valueOf('M'), new ItemStack(ItemsTC.mirroredGlass), Character.valueOf('O'), new ItemStack(ItemsTC.visResonator), Character.valueOf('G'), new ItemStack(ItemsTC.casterBasic)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:aura_meter"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "BISMUTH", 25, new AspectList().add(Aspect.ORDER, 1).add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1), new ItemStack(PAItems.aura_meter), new Object[]{"A", "B", "C", Character.valueOf('A'), Blocks.field_150410_aZ, Character.valueOf('B'), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR), Character.valueOf('C'), PAItems.bismuth_ingot}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:alkimium_goggles"), (InfusionRecipe)new InfusionRecipe("ALKIMIUMGOGGLES", (Object)new ItemStack(PAItems.alkimium_goggles), 1, new AspectList().add(Aspect.ALCHEMY, 50).add(Aspect.AURA, 25), (Object)new ItemStack(ItemsTC.goggles), new Object[]{new ItemStack(PAItems.alkimium_plate), new ItemStack(PAItems.alkimium_plate), new ItemStack(PAItems.alkimium_plate), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AURA)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:belt_of_suspension"), (InfusionRecipe)new InfusionRecipe("BELTOFSUSPENSION", (Object)new ItemStack(PAItems.belt_of_suspension), 5, new AspectList().add(Aspect.AURA, 50).add(Aspect.AIR, 75).add(Aspect.MECHANISM, 15).add(Aspect.MOTION, 75).add(Aspect.ENERGY, 65).add(Aspect.FLIGHT, 125).add(Aspect.TOOL, 15), (Object)new ItemStack(ItemsTC.baubles, 1, 2), new Object[]{new ItemStack(Items.field_151008_G), new ItemStack(ItemsTC.ringCloud), new ItemStack(Items.field_151102_aT), new ItemStack(ItemsTC.alumentum), new ItemStack(BlocksTC.levitator), new ItemStack(BlocksTC.pavingStoneBarrier), new ItemStack((Block)Blocks.field_150331_J), new ItemStack(BlocksTC.crystalAir)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:dimensional_singularity"), (InfusionRecipe)new InfusionRecipe("DIMENSIONALSINGULARITY", (Object)new ItemStack(PAItems.dimensional_singularity), 5, new AspectList().add(Aspect.AURA, 75).add(Aspect.ENTROPY, 15).add(PAAspects.DIMENSIONS, 45).add(PAAspects.TIME, 10).add(Aspect.EXCHANGE, 25).add(Aspect.ENERGY, 200), (Object)new ItemStack(ItemsTC.salisMundus), new Object[]{new ItemStack(ItemsTC.mirroredGlass), new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150318_D), new ItemStack(ItemsTC.alumentum), new ItemStack(Blocks.field_150451_bX), new ItemStack(ItemsTC.visResonator)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:mirrored_amulet"), (InfusionRecipe)new InfusionRecipe("MIRROREDAMULET", (Object)new ItemStack(PAItems.mirrored_amulet), 8, new AspectList().add(Aspect.AURA, 50).add(Aspect.CRYSTAL, 25).add(Aspect.ENERGY, 35).add(Aspect.TOOL, 20).add(PAAspects.DIMENSIONS, 65).add(Aspect.EXCHANGE, 64), (Object)new ItemStack(ItemsTC.baubles, 1, 4), new Object[]{new ItemStack(PAItems.dimensional_singularity), new ItemStack((Block)Blocks.field_150438_bZ), new ItemStack(BlocksTC.hungryChest), new ItemStack(BlocksTC.crystalOrder), new ItemStack(Items.field_151057_cb), new ItemStack(BlocksTC.mirror)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:mirrored_amulet2"), (InfusionRecipe)new InfusionRecipe("MIRROREDAMULET", (Object)new ItemStack(PAItems.mirrored_amulet), 8, new AspectList().add(Aspect.AURA, 50).add(Aspect.CRYSTAL, 25).add(Aspect.ENERGY, 35).add(Aspect.TOOL, 20).add(PAAspects.DIMENSIONS, 65).add(Aspect.EXCHANGE, 64), (Object)new ItemStack(ItemsTC.baubles, 1, 4), new Object[]{new ItemStack(PAItems.dimensional_curiosity), new ItemStack((Block)Blocks.field_150438_bZ), new ItemStack(BlocksTC.hungryChest), new ItemStack(BlocksTC.crystalOrder), new ItemStack(Items.field_151057_cb), new ItemStack(BlocksTC.mirror)}));
        InfusionEnchantmentRecipeII IETransmutative = new InfusionEnchantmentRecipeII(EnumInfusionEnchantmentII.TRANSMUTATIVE, new AspectList().add(Aspect.ALCHEMY, 60).add(Aspect.FLUX, 45), new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(PABlocks.alkimium_block));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:IETransmutative"), (InfusionRecipe)IETransmutative);
        ItemStack recipeStack = new ItemStack(ItemsTC.thaumiumSword);
        recipeStack.func_151001_c(TextFormatting.RESET + recipeStack.func_82833_r() + " +" + TextFormatting.GOLD + "Transmutative");
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:IETransmutativeFake"), (Object)((Object)new InfusionEnchantmentRecipeII(IETransmutative, recipeStack)));
        InfusionEnchantmentRecipeII IEAuraInfusing = new InfusionEnchantmentRecipeII(EnumInfusionEnchantmentII.AURAINFUSING, new AspectList().add(Aspect.AURA, 50).add(Aspect.ENERGY, 60), new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(ItemsTC.visResonator));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:IEAuraInfusing"), (InfusionRecipe)IEAuraInfusing);
        recipeStack = new ItemStack(ItemsTC.thaumiumSword);
        recipeStack.func_151001_c(TextFormatting.RESET + recipeStack.func_82833_r() + " +" + TextFormatting.GOLD + "Aura Infusing");
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:IEAuraInfusingFake"), (Object)((Object)new InfusionEnchantmentRecipeII(IEAuraInfusing, recipeStack)));
        InfusionEnchantmentRecipeII IEProjecting = new InfusionEnchantmentRecipeII(EnumInfusionEnchantmentII.PROJECTING, new AspectList().add(Aspect.TOOL, 15).add(Aspect.AVERSION, 15).add(Aspect.MOTION, 15), new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(Items.field_151079_bi));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:IEProjecting"), (InfusionRecipe)IEProjecting);
        recipeStack = new ItemStack(ItemsTC.thaumiumSword);
        recipeStack.func_151001_c(TextFormatting.RESET + recipeStack.func_82833_r() + " +" + TextFormatting.GOLD + "Projecting");
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("planarartifice:IEProjectingFake"), (Object)((Object)new InfusionEnchantmentRecipeII(IEProjecting, recipeStack)));
        ScanningManager.addScannableThing((IScanThing)new ScanBlock("!Portal", new Block[]{Blocks.field_150427_aO}));
        FocusEngine.registerElement(FocusEffectPrismLight.class, (ResourceLocation)new ResourceLocation(MODID, "textures/foci/prism.png"), (int)0xFF00FF);
        FocusEngine.registerElement(FocusEffectColourized.class, (ResourceLocation)new ResourceLocation(MODID, "textures/foci/colourizer.png"), (int)0xFFFFFF);
        GolemMaterial.register((GolemMaterial)new GolemMaterial("ALKIMIUM", new String[]{"MATSTUDYALKIMIUM"}, new ResourceLocation(MODID, "textures/models/golem/alkimium_golem.png"), 5035138, 13, 12, 4, new ItemStack(PAItems.alkimium_ingot), new ItemStack(ItemsTC.mechanismSimple), new EnumGolemTrait[]{EnumGolemTrait.BLASTPROOF, EnumGolemTrait.LIGHT, EnumGolemTrait.FIREPROOF, EnumGolemTrait.FRAGILE}));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)this);
        PAAspects.addAspectsToItems();
        PAMultiblocks.init();
        for (int i = 0; i < FocusEngine.elements.values().size(); ++i) {
            try {
                if (!(((Class)FocusEngine.elements.values().toArray()[i]).newInstance() instanceof FocusEffect)) continue;
                focusEffects.add((FocusEffect)((Class)FocusEngine.elements.values().toArray()[i]).newInstance());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
    }

    public static Block findBlockUnderEntity(Entity parEntity) {
        int blockX = MathHelper.func_76128_c((double)parEntity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)(parEntity.field_70163_u - 0.2 - parEntity.func_70033_W()));
        int blockZ = MathHelper.func_76128_c((double)parEntity.field_70161_v);
        return parEntity.field_70170_p.func_180495_p(new BlockPos(blockX, blockY, blockZ)).func_177230_c();
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent tick) {
        PAAspects.setupColours(++serverTickCount);
        proxy.onTick();
        isSingleplayer = !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S();
        p.put("planarartifice.FOCUSCOLOURED", currentColourPicked);
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent event) {
        NBTTagCompound l;
        Item i = event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b();
        if (i instanceof ItemCaster && event.getEntityPlayer().func_184586_b(event.getHand()).func_77942_o() && (l = event.getEntityPlayer().func_184586_b(event.getHand()).func_77978_p().func_74775_l("focus").func_74775_l("tag")).func_74764_b("color")) {
            currentColourPicked = l.func_74762_e("color");
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && BaublesApi.isBaubleEquipped((EntityPlayer)((EntityPlayer)event.getEntityLiving()), (Item)PAItems.mirrored_amulet) >= 0) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            for (int i = 0; i < ((EntityPlayer)event.getEntityLiving()).field_71071_by.func_70302_i_(); ++i) {
                arrayList.add(((EntityPlayer)event.getEntityLiving()).field_71071_by.func_70301_a(i));
            }
            inventoriesToConserve.put(event.getEntityLiving().func_110124_au(), arrayList);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (inventoriesToConserve.containsKey(event.getEntityPlayer().func_110124_au())) {
            for (int i = 0; i < inventoriesToConserve.get(event.getEntityPlayer().func_110124_au()).size(); ++i) {
                if (inventoriesToConserve.get(event.getEntityPlayer().func_110124_au()).get(i).func_77973_b() == PAItems.mirrored_amulet) continue;
                event.getEntityPlayer().field_71071_by.func_70299_a(i, inventoriesToConserve.get(event.getEntityPlayer().func_110124_au()).get(i));
            }
            inventoriesToConserve.remove(event.getEntityPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public static void onPlayerDrop(PlayerDropsEvent event) {
        if (inventoriesToConserve.containsKey(event.getEntityPlayer().func_110124_au())) {
            event.setCanceled(true);
        }
    }

    public static double[] interpolate(double start, double end, int count) {
        if (count < 2) {
            throw new IllegalArgumentException("interpolate: illegal count!");
        }
        double[] array = new double[count + 1];
        for (int i = 0; i <= count; ++i) {
            array[i] = start + (double)i * (end - start) / (double)count;
        }
        return array;
    }

    public static int[] interpolateInt(double start, double end, int count) {
        if (count < 2) {
            throw new IllegalArgumentException("interpolate: illegal count!");
        }
        int[] array = new int[count + 1];
        for (int i = 0; i <= count; ++i) {
            array[i] = (int)(start + (double)i * (end - start) / (double)count);
        }
        return array;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        NBTTagList nbttaglist;
        if (event.getItemStack() != null && (nbttaglist = EnumInfusionEnchantmentII.getInfusionEnchantmentTagList(event.getItemStack())) != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                if (k < 0 || k >= EnumInfusionEnchantmentII.values().length) continue;
                String s = TextFormatting.GOLD + I18n.func_74838_a((String)("enchantment.infusion." + EnumInfusionEnchantmentII.values()[k].toString()));
                if (EnumInfusionEnchantmentII.values()[k].maxLevel > 1) {
                    s = s + " " + I18n.func_74838_a((String)("enchantment.level." + l));
                }
                event.getToolTip().add(1, s);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDropsInfusion(LivingDropsEvent event) {
        ItemStack item;
        int level;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && (level = EnumInfusionEnchantmentII.getInfusionEnchantmentLevel(item = ((EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND), EnumInfusionEnchantmentII.TRANSMUTATIVE)) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (EntityItem i : event.getDrops()) {
                ItemStack tem = i.func_92059_d();
                if (transmutations.containsKey(tem.func_77973_b())) {
                    items.add(new ItemStack(transmutations.get(tem.func_77973_b()), tem.func_190916_E()));
                    continue;
                }
                items.add(tem);
            }
            for (int i = 0; i < event.getDrops().size(); ++i) {
                ((EntityItem)event.getDrops().get(i)).func_92058_a((ItemStack)items.get(i));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        EntityPlayer p;
        ItemStack item;
        int level;
        if (event.getAttackingPlayer() != null && event.getAttackingPlayer().func_184614_ca() != null && (level = EnumInfusionEnchantmentII.getInfusionEnchantmentLevel(item = (p = event.getAttackingPlayer()).func_184614_ca(), EnumInfusionEnchantmentII.AURAINFUSING)) > 0) {
            int amount = event.getOriginalExperience();
            AuraHelper.addVis((World)p.func_130014_f_(), (BlockPos)p.func_180425_c(), (float)((float)(0.5 * (double)amount)));
            event.setCanceled(true);
        }
    }

    static {
        focusEffects = new ArrayList();
        currentFocusEffect = 0;
        currentColourPicked = 0xFFFFFF;
        inventoriesToConserve = new HashMap();
        transmutations = new HashMap();
        instance = new PlanarArtifice();
        serverTickCount = 0;
    }
}

