/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.blocks.IBlockFacingHorizontal;
import thaumcraft.common.lib.utils.RandomItemChooser;

public class TileMeatyOrb
extends TileTW
implements IAspectContainer,
IEssentiaTransport,
ITickable {
    private static final RandomItemChooser RIC = new RandomItemChooser();
    private static final int DURATION_TICKS = 300;
    private static final int CAPACITY = 250;
    public static final int MIN_FUEL = 250;
    protected static List<RandomItemChooser.Item> meats = new ArrayList<RandomItemChooser.Item>();
    protected int lifeEssentia = 0;
    protected int waterEssentia = 0;
    protected int eldritchEssentia = 0;
    protected int tickCounter = 0;
    protected int activeCounter = 0;

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.lifeEssentia = compound.func_74765_d("lifeEssentia");
        this.waterEssentia = compound.func_74765_d("waterEssentia");
        this.eldritchEssentia = compound.func_74765_d("eldritchEssentia");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74777_a("lifeEssentia", (short)this.lifeEssentia);
        compound.func_74777_a("waterEssentia", (short)this.waterEssentia);
        compound.func_74777_a("eldritchEssentia", (short)this.eldritchEssentia);
        return compound;
    }

    public void setActive(boolean active) {
        this.activeCounter = active ? 300 : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.tickCounter % 5 == 0) {
            this.fill();
        }
        if (!this.field_145850_b.field_72995_K && this.activeCounter > 0) {
            MeatEntry entry = (MeatEntry)RIC.chooseOnWeight(meats);
            if (entry != null) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.5 + 32.0 * (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble());
                double z = (double)this.field_174879_c.func_177952_p() + 0.5 + 32.0 * (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble());
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, x, (double)this.field_145850_b.func_72940_L(), z, entry.itemStack.func_77946_l()));
            }
            --this.activeCounter;
        }
    }

    protected void fill() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            IEssentiaTransport otherTile;
            TileEntity te;
            if (!this.canInputFrom(face) || this.getEssentiaAmount(face) >= 250 || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face)) == null || !(te instanceof IEssentiaTransport) || !(otherTile = (IEssentiaTransport)te).canOutputTo(face.func_176734_d()) || otherTile.getEssentiaType(face.func_176734_d()) != this.getEssentiaType(face) || otherTile.getEssentiaAmount(face.func_176734_d()) <= 0 || this.getSuctionAmount(face) <= otherTile.getSuctionAmount(face.func_176734_d()) || this.getSuctionAmount(face) < otherTile.getMinimumSuction()) continue;
            int taken = otherTile.takeEssentia(this.getEssentiaType(face), 1, face.func_176734_d());
            int leftover = this.addToContainer(this.getEssentiaType(face), taken);
            if (leftover > 0) {
                ThaumicWonders.LOGGER.info("Meaty Orb spilling {} essentia on fill", (Object)leftover);
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)leftover, (boolean)true);
            }
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    public EnumFacing getRelativeFacing(EnumFacing absFace) {
        if (this.func_145838_q() instanceof IBlockFacingHorizontal && absFace != EnumFacing.UP && absFace != EnumFacing.DOWN) {
            EnumFacing blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IBlockFacingHorizontal.FACING);
            int rotations = 0;
            EnumFacing relativeFacing = absFace;
            while (blockFacing != EnumFacing.NORTH) {
                blockFacing = blockFacing.func_176746_e();
                ++rotations;
            }
            for (int index = 0; index < rotations; ++index) {
                relativeFacing = relativeFacing.func_176746_e();
            }
            return relativeFacing;
        }
        return absFace;
    }

    public int addEssentia(Aspect aspect, int amt, EnumFacing face) {
        if (this.canInputFrom(face) && aspect == this.getEssentiaType(face)) {
            return amt - this.addToContainer(aspect, amt);
        }
        return 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        EnumFacing relFace = this.getRelativeFacing(face);
        return relFace == EnumFacing.WEST || relFace == EnumFacing.EAST || relFace == EnumFacing.SOUTH;
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public int getEssentiaAmount(EnumFacing face) {
        EnumFacing relFace = this.getRelativeFacing(face);
        if (relFace == EnumFacing.WEST) {
            return this.lifeEssentia;
        }
        if (relFace == EnumFacing.EAST) {
            return this.waterEssentia;
        }
        if (relFace == EnumFacing.SOUTH) {
            return this.eldritchEssentia;
        }
        return 0;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        EnumFacing relFace = this.getRelativeFacing(face);
        if (relFace == EnumFacing.WEST) {
            return Aspect.LIFE;
        }
        if (relFace == EnumFacing.EAST) {
            return Aspect.WATER;
        }
        if (relFace == EnumFacing.SOUTH) {
            return Aspect.ELDRITCH;
        }
        return null;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        return this.getEssentiaAmount(face) >= 250 ? 0 : 128;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return this.getEssentiaType(face);
    }

    public boolean isConnectable(EnumFacing face) {
        return this.canInputFrom(face);
    }

    public void setSuction(Aspect aspect, int amt) {
    }

    public int takeEssentia(Aspect aspect, int amt, EnumFacing face) {
        return 0;
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        int retVal = 0;
        if (toAdd == 0) {
            return 0;
        }
        if (this.lifeEssentia < 250 && aspect == Aspect.LIFE) {
            int added = Math.min(toAdd, 250 - this.lifeEssentia);
            this.lifeEssentia += added;
            retVal = toAdd - added;
        } else if (this.waterEssentia < 250 && aspect == Aspect.WATER) {
            int added = Math.min(toAdd, 250 - this.waterEssentia);
            this.waterEssentia += added;
            retVal = toAdd - added;
        } else if (this.eldritchEssentia < 250 && aspect == Aspect.ELDRITCH) {
            int added = Math.min(toAdd, 250 - this.eldritchEssentia);
            this.eldritchEssentia += added;
            retVal = toAdd - added;
        } else {
            retVal = toAdd;
        }
        this.syncTile(false);
        this.func_70296_d();
        return retVal;
    }

    public int containerContains(Aspect aspect) {
        if (aspect == Aspect.LIFE) {
            return this.lifeEssentia;
        }
        if (aspect == Aspect.WATER) {
            return this.waterEssentia;
        }
        if (aspect == Aspect.ELDRITCH) {
            return this.eldritchEssentia;
        }
        return 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return aspect == Aspect.LIFE || aspect == Aspect.WATER || aspect == Aspect.ELDRITCH;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        return aspect == Aspect.LIFE && this.lifeEssentia >= amt || aspect == Aspect.WATER && this.waterEssentia >= amt || aspect == Aspect.ELDRITCH && this.eldritchEssentia >= amt;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (this.lifeEssentia > 0) {
            list.add(Aspect.LIFE, this.lifeEssentia);
        }
        if (this.waterEssentia > 0) {
            list.add(Aspect.WATER, this.waterEssentia);
        }
        if (this.eldritchEssentia > 0) {
            list.add(Aspect.ELDRITCH, this.eldritchEssentia);
        }
        return list;
    }

    public void setAspects(AspectList aspects) {
        if (aspects != null && aspects.size() > 0) {
            this.lifeEssentia = aspects.getAmount(Aspect.LIFE);
            this.waterEssentia = aspects.getAmount(Aspect.WATER);
            this.eldritchEssentia = aspects.getAmount(Aspect.ELDRITCH);
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        if (!this.doesContainerContain(aspectList)) {
            return false;
        }
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.takeFromContainer(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        if (aspect == Aspect.LIFE && this.lifeEssentia >= amt) {
            this.lifeEssentia -= amt;
        } else if (aspect == Aspect.WATER && this.waterEssentia >= amt) {
            this.waterEssentia -= amt;
        } else if (aspect == Aspect.ELDRITCH && this.eldritchEssentia >= amt) {
            this.eldritchEssentia -= amt;
        } else {
            return false;
        }
        this.syncTile(false);
        this.func_70296_d();
        return true;
    }

    static {
        meats.add(new MeatEntry(new ItemStack(Items.field_151082_bd, 1, 0), 30));
        meats.add(new MeatEntry(new ItemStack(Items.field_151147_al, 1, 0), 25));
        meats.add(new MeatEntry(new ItemStack(Items.field_151076_bf, 1, 0), 20));
        meats.add(new MeatEntry(new ItemStack(Items.field_179561_bm, 1, 0), 15));
        meats.add(new MeatEntry(new ItemStack(Items.field_179558_bo, 1, 0), 10));
    }

    protected static class MeatEntry
    implements RandomItemChooser.Item {
        public ItemStack itemStack;
        public int weight;

        public MeatEntry(ItemStack itemStack, int weight) {
            this.itemStack = itemStack;
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

