/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.tools;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.items.ItemsTW;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;

public class ItemBoneBow
extends ItemBow
implements IRechargable {
    protected static final int VIS_CAPACITY = 200;
    protected static final int POWERED_CHARGE_TIME = 10;
    protected static final int UNPOWERED_CHARGE_TIME = 20;

    public ItemBoneBow() {
        this.func_77637_a(ThaumicWonders.CREATIVE_TAB);
        this.setRegistryName("thaumicwonders", "bone_bow");
        this.func_77655_b("thaumicwonders." + this.getRegistryName().func_110623_a());
        this.func_77625_d(1);
        this.func_77656_e(512);
        this.func_185043_a(new ResourceLocation("thaumicwonders", "pull"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                float maxCharge = RechargeHelper.getCharge((ItemStack)stack) > 0 ? 10.0f : 20.0f;
                return entityIn.func_184607_cu().func_77973_b() != ItemsTW.BONE_BOW ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / maxCharge;
            }
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77969_a(new ItemStack(Items.field_151103_aS)) ? true : super.func_82789_a(toRepair, repair);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        int ticks = this.func_77626_a(stack) - count;
        if (ticks >= 10 && RechargeHelper.getCharge((ItemStack)stack) > 0) {
            player.func_184597_cx();
        }
    }

    public static float getArrowVelocity(ItemStack stack, int charge) {
        float maxCharge = RechargeHelper.getCharge((ItemStack)stack) > 0 ? 10.0f : 20.0f;
        float f = (float)charge / maxCharge;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184592_cb())) {
            return player.func_184592_cb();
        }
        if (this.func_185058_h_(player.func_184614_ca())) {
            return player.func_184614_ca();
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.func_185060_a(entityplayer);
            int charge = this.func_77626_a(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)charge, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                float velocity;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                if ((double)(velocity = ItemBoneBow.getArrowVelocity(stack, charge)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                    if (!worldIn.field_72995_K) {
                        int punchLevels;
                        int powerLevels;
                        ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                        EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                        float velocityMultiplier = RechargeHelper.getCharge((ItemStack)stack) > 0 ? 4.0f : 3.0f;
                        entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, velocity * velocityMultiplier, 1.0f);
                        RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)entityplayer, (int)1);
                        if (velocity == 1.0f) {
                            entityarrow.func_70243_d(true);
                        }
                        if ((powerLevels = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevels * 0.5 + 0.5);
                        }
                        if ((punchLevels = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityarrow.func_70240_a(punchLevels);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                        if (flag1 || entityplayer.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)entityarrow);
                    }
                    worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                    if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            entityplayer.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                }
            }
        }
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase player) {
        return 200;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack stack, EntityLivingBase player) {
        return IRechargable.EnumChargeDisplay.NORMAL;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() == newStack.func_77973_b() && !slotChanged) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

