/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.misc;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.items.base.ItemTW;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStructureDiviner
extends ItemTW {
    public ItemStructureDiviner() {
        super("structure_diviner");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @SideOnly(value=Side.CLIENT)
            double rotation;
            @SideOnly(value=Side.CLIENT)
            double rota;
            @SideOnly(value=Side.CLIENT)
            long lastUpdateTick;

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                double angle;
                BlockPos targetPoint;
                EntityLivingBase entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean held = entityIn != null;
                Object object = entity = held ? entityIn : stack.func_82836_z();
                if (worldIn == null) {
                    worldIn = entity.func_130014_f_();
                }
                if ((targetPoint = this.getTargetPoint(stack)) != null) {
                    double entityYaw = held ? (double)entity.field_70177_z : this.getFrameRotation(stack.func_82836_z());
                    entityYaw = MathHelper.func_191273_b((double)(entityYaw / 360.0), (double)1.0);
                    angle = 0.5 - (entityYaw - 0.25 - this.getTargetPointToAngle(targetPoint, (Entity)entity));
                } else {
                    angle = Math.random();
                }
                if (held) {
                    angle = this.wobble(worldIn, angle);
                }
                return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World worldIn, double angle) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = angle - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame frame) {
                return MathHelper.func_188209_b((int)(180 + frame.field_174860_b.func_176736_b() * 90));
            }

            @SideOnly(value=Side.CLIENT)
            @Nullable
            private BlockPos getTargetPoint(ItemStack stack) {
                if (stack != null && !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("targetPoint")) {
                    return BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("targetPoint"));
                }
                return null;
            }

            @SideOnly(value=Side.CLIENT)
            private double getTargetPointToAngle(@Nonnull BlockPos targetPoint, @Nonnull Entity entity) {
                return Math.atan2((double)targetPoint.func_177952_p() - entity.field_70161_v, (double)targetPoint.func_177958_n() - entity.field_70165_t) / (Math.PI * 2);
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.openGui((Object)ThaumicWonders.INSTANCE, 5, worldIn, 0, 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }
}

