/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.verdantartifice.thaumicwonders.common.items.base.ItemTW;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;

public class ItemCleansingCharm
extends ItemTW
implements IBauble,
IRechargable {
    protected static final int VIS_CAPACITY = 200;
    protected static final int MAX_PROGRESS = 72000;
    protected static final int ENERGY_PER_VIS = 359;

    public ItemCleansingCharm() {
        super("cleansing_charm");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase player) {
        return 200;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack stack, EntityLivingBase player) {
        return IRechargable.EnumChargeDisplay.NORMAL;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.CHARM;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase elb) {
        EntityPlayer player;
        IPlayerWarp warp;
        if (elb != null && elb instanceof EntityPlayer && (warp = ThaumcraftCapabilities.getWarp((EntityPlayer)(player = (EntityPlayer)elb))).get(IPlayerWarp.EnumWarpType.NORMAL) > 0) {
            if (this.hasEnergy(itemstack)) {
                this.incrementProgress(itemstack);
                int progress = this.getProgress(itemstack);
                if (progress % 60 == 0) {
                    AuraHelper.polluteAura((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (float)0.1f, (boolean)true);
                }
                if (progress >= 72000) {
                    ThaumcraftApi.internalMethods.addWarpToPlayer(player, -1, IPlayerWarp.EnumWarpType.NORMAL);
                    this.setProgress(itemstack, 0);
                }
            }
            this.consumeEnergy(itemstack, (EntityLivingBase)player);
        }
    }

    protected void incrementProgress(ItemStack stack) {
        this.setProgress(stack, this.getProgress(stack) + 1);
    }

    protected int getProgress(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("progress");
        }
        return 0;
    }

    protected void setProgress(ItemStack stack, int progress) {
        stack.func_77983_a("progress", (NBTBase)new NBTTagInt(progress));
    }

    protected void consumeEnergy(ItemStack stack, EntityLivingBase player) {
        int energy = this.getEnergy(stack);
        if (energy > 0) {
            --energy;
        } else if (RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)player, (int)1)) {
            energy = 359;
        }
        this.setEnergy(stack, energy);
    }

    protected int getEnergy(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("energy");
        }
        return 0;
    }

    protected void setEnergy(ItemStack stack, int energy) {
        stack.func_77983_a("energy", (NBTBase)new NBTTagInt(energy));
    }

    protected boolean hasEnergy(ItemStack stack) {
        return this.getEnergy(stack) > 0 || RechargeHelper.getCharge((ItemStack)stack) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int percent = (int)((double)this.getProgress(stack) / 72000.0 * 100.0);
        tooltip.add(I18n.func_135052_a((String)"item.thaumicwonders.cleansing_charm.tooltip.progress", (Object[])new Object[]{percent}));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

