/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.armor;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.client.renderers.models.gear.ModelVoidFortressArmor;
import com.verdantartifice.thaumicwonders.common.items.armor.CustomArmorHelper;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IWarpingGear;
import thaumcraft.api.items.ItemsTC;

public class ItemVoidFortressArmor
extends ItemArmor
implements ISpecialArmor,
IWarpingGear,
IGoggles {
    public static ItemArmor.ArmorMaterial MATERIAL = EnumHelper.addArmorMaterial((String)"VOID_FORTRESS", (String)"VOID_FORTRESS", (int)50, (int[])new int[]{4, 7, 9, 4}, (int)15, (SoundEvent)SoundEvents.field_187725_r, (float)3.0f);

    public ItemVoidFortressArmor(String name, ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.setRegistryName("thaumicwonders", name);
        this.func_77655_b("thaumicwonders." + this.getRegistryName().func_110623_a());
        this.func_77637_a(ThaumicWonders.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        EntityEquipmentSlot type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        float f = type == EntityEquipmentSlot.LEGS ? 0.5f : 1.0f;
        return CustomArmorHelper.getCustomArmorModel(entityLiving, itemStack, armorSlot, (ModelBiped)new ModelVoidFortressArmor(f));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "thaumicwonders:textures/entities/armor/void_fortress_armor.png";
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77969_a(new ItemStack(ItemsTC.ingots, 1, 1)) ? true : super.func_82789_a(toRepair, repair);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (!world.field_72995_K && itemStack.func_77952_i() > 0 && player.field_70173_aa % 20 == 0) {
            itemStack.func_77972_a(-1, (EntityLivingBase)player);
        }
    }

    public int getWarp(ItemStack itemstack, EntityPlayer player) {
        return 3;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        EntityPlayer ep;
        IPlayerWarp warp;
        int priority = 0;
        double ratio = (double)this.field_77879_b / 25.0;
        if (source.func_82725_o()) {
            priority = 1;
            ratio = (double)this.field_77879_b / 35.0;
        } else if (source.func_76347_k() || source.func_94541_c()) {
            priority = 1;
            ratio = (double)this.field_77879_b / 20.0;
        } else if (source.func_76363_c()) {
            priority = 0;
            ratio = 0.0;
        }
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(priority, ratio, armor.func_77958_k() - armor.func_77952_i() + 1);
        EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.HEAD};
        int set = 0;
        for (EntityEquipmentSlot equipmentSlot : slots) {
            ItemStack piece = player.func_184582_a(equipmentSlot);
            if (piece == null || !(piece.func_77973_b() instanceof ItemVoidFortressArmor)) continue;
            ++set;
        }
        if (set >= 2) {
            ap.Armor += 1.0;
            ap.Toughness += 1.0;
        }
        if (set >= 3) {
            ap.Armor += 1.0;
        }
        if (player instanceof EntityPlayer && (warp = ThaumcraftCapabilities.getWarp((EntityPlayer)(ep = (EntityPlayer)player))) != null) {
            int pw = Math.min(100, warp.get(IPlayerWarp.EnumWarpType.PERMANENT));
            ap.Toughness += (double)pw / 25.0;
        }
        return ap;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.HEAD};
        int set = 0;
        int armorRating = 0;
        for (EntityEquipmentSlot equipmentSlot : slots) {
            ItemStack piece = player.func_184582_a(equipmentSlot);
            if (piece == null || !(piece.func_77973_b() instanceof ItemVoidFortressArmor)) continue;
            ++set;
        }
        if (set >= 2) {
            ++armorRating;
        }
        if (set >= 3) {
            ++armorRating;
        }
        return armorRating;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source != DamageSource.field_76379_h) {
            stack.func_77972_a(damage, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"enchantment.special.warpshell", (Object[])new Object[0]));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)itemstack.func_77973_b();
            return armor.field_77881_a == EntityEquipmentSlot.HEAD;
        }
        return false;
    }
}

