/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.init;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockCatalyzationChamber;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockDimensionalRipper;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockEverburningUrn;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockFluxCapacitor;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockInspirationEngine;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockMadnessEngine;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockMeatyOrb;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockMeteorb;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockOreDiviner;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockPortalAnchor;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockPortalGenerator;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockVoidBeacon;
import com.verdantartifice.thaumicwonders.common.blocks.devices.ItemBlockFluxCapacitor;
import com.verdantartifice.thaumicwonders.common.blocks.devices.ItemBlockPortalGenerator;
import com.verdantartifice.thaumicwonders.common.blocks.essentia.BlockCreativeEssentiaJar;
import com.verdantartifice.thaumicwonders.common.blocks.essentia.ItemBlockCreativeEssentiaJar;
import com.verdantartifice.thaumicwonders.common.blocks.fluids.BlockFluidQuicksilver;
import com.verdantartifice.thaumicwonders.common.blocks.misc.BlockHexamite;
import com.verdantartifice.thaumicwonders.common.blocks.misc.BlockTWPlaceholder;
import com.verdantartifice.thaumicwonders.common.fluids.FluidQuicksilver;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileCatalyzationChamber;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileDimensionalRipper;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileEverburningUrn;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileInspirationEngine;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileMadnessEngine;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileMeatyOrb;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileMeteorb;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileOreDiviner;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TilePortalAnchor;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TilePortalGenerator;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileVoidBeacon;
import com.verdantartifice.thaumicwonders.common.tiles.essentia.TileCreativeEssentiaJar;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InitBlocks {
    public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

    public static void initBlocks(IForgeRegistry<Block> forgeRegistry) {
        InitBlocks.registerBlock(forgeRegistry, new BlockEverburningUrn());
        InitBlocks.registerBlock(forgeRegistry, new BlockDimensionalRipper());
        InitBlocks.registerBlock(forgeRegistry, new BlockCreativeEssentiaJar(), ItemBlockCreativeEssentiaJar.class);
        InitBlocks.registerBlock(forgeRegistry, new BlockInspirationEngine());
        InitBlocks.registerBlock(forgeRegistry, new BlockMadnessEngine());
        InitBlocks.registerBlock(forgeRegistry, new BlockPortalAnchor());
        InitBlocks.registerBlock(forgeRegistry, new BlockPortalGenerator(), ItemBlockPortalGenerator.class);
        InitBlocks.registerBlock(forgeRegistry, new BlockCatalyzationChamber());
        InitBlocks.registerBlock(forgeRegistry, (Block)new BlockHexamite());
        InitBlocks.registerBlock(forgeRegistry, new BlockFluxCapacitor(), ItemBlockFluxCapacitor.class);
        InitBlocks.registerBlock(forgeRegistry, new BlockMeteorb());
        InitBlocks.registerBlock(forgeRegistry, new BlockOreDiviner());
        InitBlocks.registerBlock(forgeRegistry, new BlockMeatyOrb());
        InitBlocks.registerBlock(forgeRegistry, new BlockVoidBeacon());
        InitBlocks.registerBlock(forgeRegistry, new BlockTWPlaceholder("placeholder_arcane_stone"));
        InitBlocks.registerBlock(forgeRegistry, new BlockTWPlaceholder("placeholder_obsidian"));
        FluidRegistry.registerFluid((Fluid)FluidQuicksilver.INSTANCE);
        FluidRegistry.addBucketForFluid((Fluid)FluidQuicksilver.INSTANCE);
        forgeRegistry.register((IForgeRegistryEntry)new BlockFluidQuicksilver());
    }

    private static void registerBlock(IForgeRegistry<Block> forgeRegistry, Block block) {
        forgeRegistry.register((IForgeRegistryEntry)block);
        ITEM_BLOCKS.add(new ItemBlock(block));
    }

    private static <T extends ItemBlock> void registerBlock(IForgeRegistry<Block> forgeRegistry, Block block, Class<T> clazz) {
        forgeRegistry.register((IForgeRegistryEntry)block);
        try {
            ItemBlock itemBlock = (ItemBlock)clazz.getConstructors()[0].newInstance(block);
            ITEM_BLOCKS.add(itemBlock);
        }
        catch (Exception e) {
            ThaumicWonders.LOGGER.catching((Throwable)e);
        }
    }

    public static void initItemBlocks(IForgeRegistry<Item> forgeRegistry) {
        for (ItemBlock itemBlock : ITEM_BLOCKS) {
            Block block = itemBlock.func_179223_d();
            itemBlock.setRegistryName(block.getRegistryName());
            forgeRegistry.register((IForgeRegistryEntry)itemBlock);
        }
    }

    public static void initTileEntities() {
        GameRegistry.registerTileEntity(TileEverburningUrn.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileEverburningUrn"));
        GameRegistry.registerTileEntity(TileDimensionalRipper.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileDimensionalRipper"));
        GameRegistry.registerTileEntity(TileCreativeEssentiaJar.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileCreativeEssentiaJar"));
        GameRegistry.registerTileEntity(TileInspirationEngine.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileInspirationEngine"));
        GameRegistry.registerTileEntity(TileMadnessEngine.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileMadnessEngine"));
        GameRegistry.registerTileEntity(TilePortalAnchor.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TilePortalAnchor"));
        GameRegistry.registerTileEntity(TilePortalGenerator.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TilePortalGenerator"));
        GameRegistry.registerTileEntity(TileCatalyzationChamber.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileCatalyzationChamber"));
        GameRegistry.registerTileEntity(TileMeteorb.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileMeteorb"));
        GameRegistry.registerTileEntity(TileOreDiviner.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileOreDiviner"));
        GameRegistry.registerTileEntity(TileMeatyOrb.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileMeatyOrb"));
        GameRegistry.registerTileEntity(TileVoidBeacon.class, (ResourceLocation)new ResourceLocation("thaumicwonders", "TileVoidBeacon"));
    }
}

