/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.consolehud.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TooltipShulkerBoxHelper {
    public static void getLootTableTooltip(List<String> list, ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("BlockEntityTag", 10) && (nbttagcompound1 = nbttagcompound.func_74775_l("BlockEntityTag")).func_150297_b("LootTable", 8)) {
            list.add("???????");
        }
    }

    public static void getContentsTooltip(List<String> list, ItemStack stack, Style style, int rows) {
        List<ItemStack> contents = TooltipShulkerBoxHelper.contentsToList(stack);
        if (contents == null) {
            return;
        }
        if (contents.size() > rows) {
            for (ItemStack itemstack : contents.subList(0, rows - 1)) {
                list.add(new TextComponentString(String.format("%s x%d", itemstack.func_77973_b().func_77653_i(itemstack), itemstack.func_190916_E())).func_150255_a(style).func_150254_d());
            }
            list.add(new TextComponentTranslation("container.shulkerBox.more", new Object[]{contents.size() - rows + 1}).func_150255_a(style.func_150217_b(Boolean.valueOf(true))).func_150254_d());
        } else {
            for (ItemStack itemstack : contents) {
                list.add(new TextComponentString(String.format("%s x%d", itemstack.func_77973_b().func_77653_i(itemstack), itemstack.func_190916_E())).func_150255_a(style).func_150254_d());
            }
        }
    }

    private static List<ItemStack> contentsToList(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("BlockEntityTag", 10) && (nbttagcompound1 = nbttagcompound.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
            return TooltipShulkerBoxHelper.mergeInventory((List<ItemStack>)nonnulllist);
        }
        return null;
    }

    private static List<ItemStack> mergeInventory(List<ItemStack> list) {
        ArrayList contents = Lists.newArrayList();
        for (ItemStack itemstack : list) {
            if (contents.stream().anyMatch(it -> ItemStack.func_179545_c((ItemStack)it, (ItemStack)itemstack))) {
                contents.forEach(it -> {
                    if (ItemStack.func_179545_c((ItemStack)it, (ItemStack)itemstack)) {
                        it.func_190920_e(it.func_190916_E() + itemstack.func_190916_E());
                    }
                });
                continue;
            }
            if (itemstack.func_190926_b()) continue;
            contents.add(itemstack);
        }
        return contents;
    }
}

