/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.consolehud.helper;

import com.fuzs.consolehud.ConsoleHud;
import com.fuzs.consolehud.handler.ConfigHandler;
import com.fuzs.consolehud.helper.TooltipHelper;
import com.fuzs.consolehud.helper.TooltipShulkerBoxHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.ForgeEventFactory;

public class TooltipElementsHelper {
    protected ItemStack itemstack = ItemStack.field_190927_a;

    protected void getName(List<String> list, Style style, ITooltipFlag.TooltipFlags tooltipflag) {
        String s = new TextComponentString(this.itemstack.func_82833_r()).func_150255_a(new Style().func_150217_b(Boolean.valueOf(this.itemstack.func_82837_s())).func_150238_a(this.itemstack.func_77973_b().getForgeRarity(this.itemstack).getColor())).func_150254_d();
        String s2 = "";
        if (tooltipflag.func_194127_a()) {
            String s1 = "";
            if (!s.isEmpty()) {
                s2 = s2 + " (";
                s1 = ")";
            }
            int i = Item.func_150891_b((Item)this.itemstack.func_77973_b());
            s2 = this.itemstack.func_77981_g() ? s2 + String.format("#%04d/%d%s", i, this.itemstack.func_77952_i(), s1) : s2 + String.format("#%04d%s", i, s1);
        } else if (!this.itemstack.func_82837_s() && this.itemstack.func_77973_b() == Items.field_151098_aY) {
            s2 = s2 + " #" + this.itemstack.func_77952_i();
        }
        list.add(s + new TextComponentString(s2).func_150255_a(style).func_150254_d());
    }

    protected void getInformation(List<String> list, Style style, ITooltipFlag.TooltipFlags tooltipflag) {
        List<Object> information = Lists.newArrayList();
        if (this.itemstack.func_77973_b() instanceof ItemShulkerBox) {
            TooltipShulkerBoxHelper.getContentsTooltip((List<String>)information, this.itemstack, style, ConfigHandler.heldItemTooltipsConfig.rows - 1);
        } else {
            this.itemstack.func_77973_b().func_77624_a(this.itemstack, null, (List)information, (ITooltipFlag)tooltipflag);
            information = information.stream().map(it -> new TextComponentString(it).func_150255_a(style).func_150254_d()).collect(Collectors.toList());
            information.removeIf(Strings::isNullOrEmpty);
        }
        list.addAll((Collection<String>)information);
    }

    protected void getEnchantments(List<String> list, Style style) {
        if (this.itemstack.func_77942_o()) {
            NBTTagList nbttaglist = this.itemstack.func_77986_q();
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
                short k = nbttagcompound.func_74765_d("id");
                short l = nbttagcompound.func_74765_d("lvl");
                Enchantment enchantment = Enchantment.func_185262_c((int)k);
                if (enchantment == null) continue;
                list.add(new TextComponentString(enchantment.func_77316_c((int)l)).func_150255_a(style).func_150254_d());
            }
        }
    }

    protected void getColorTag(List<String> list, Style style, ITooltipFlag.TooltipFlags tooltipflag) {
        NBTTagCompound nbttagcompound;
        if (this.itemstack.func_77942_o() && this.itemstack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound = this.itemstack.func_77978_p().func_74775_l("display")).func_150297_b("color", 3)) {
            if (tooltipflag.func_194127_a()) {
                list.add(new TextComponentTranslation("item.color", new Object[]{String.format("#%06X", nbttagcompound.func_74762_e("color"))}).func_150255_a(style).func_150254_d());
            } else {
                list.add(new TextComponentTranslation("item.dyed", new Object[0]).func_150255_a(style.func_150217_b(Boolean.valueOf(true))).func_150254_d());
            }
        }
    }

    protected void getLoreTag(List<String> list, Style style) {
        NBTTagList nbttaglist;
        NBTTagCompound nbttagcompound;
        if (this.itemstack.func_77942_o() && this.itemstack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound = this.itemstack.func_77978_p().func_74775_l("display")).func_150299_b("Lore") == 9 && !(nbttaglist = nbttagcompound.func_150295_c("Lore", 8)).func_82582_d()) {
            for (int l1 = 0; l1 < nbttaglist.func_74745_c(); ++l1) {
                list.add(new TextComponentString(nbttaglist.func_150307_f(l1)).func_150255_a(style).func_150254_d());
            }
        }
    }

    protected void getUnbreakable(List<String> list, Style style) {
        if (this.itemstack.func_77942_o() && this.itemstack.func_77978_p().func_74767_n("Unbreakable")) {
            list.add(new TextComponentTranslation("item.unbreakable", new Object[0]).func_150255_a(style).func_150254_d());
        }
    }

    protected void getAdventureStats(List<String> list, Style style) {
        if (this.itemstack.func_77942_o()) {
            NBTTagList nbttaglist2;
            NBTTagList nbttaglist1;
            if (this.itemstack.func_77978_p().func_150297_b("CanDestroy", 9) && !(nbttaglist1 = this.itemstack.func_77978_p().func_150295_c("CanDestroy", 8)).func_82582_d()) {
                list.add(new TextComponentTranslation("item.canBreak", new Object[0]).func_150255_a(style).func_150254_d());
                TooltipHelper.getAdventureBlockInfo(list, style, nbttaglist1);
            }
            if (this.itemstack.func_77978_p().func_150297_b("CanPlaceOn", 9) && !(nbttaglist2 = this.itemstack.func_77978_p().func_150295_c("CanPlaceOn", 8)).func_82582_d()) {
                list.add(new TextComponentTranslation("item.canPlace", new Object[0]).func_150255_a(style).func_150254_d());
                TooltipHelper.getAdventureBlockInfo(list, style, nbttaglist2);
            }
        }
    }

    protected void getDurability(List<String> list, Style style, boolean force) {
        if ((!ConfigHandler.heldItemTooltipsConfig.appearanceConfig.showDurability || ConfigHandler.heldItemTooltipsConfig.appearanceConfig.forceDurability) && !force || !this.itemstack.func_77951_h()) {
            return;
        }
        if (!ConfigHandler.heldItemTooltipsConfig.appearanceConfig.durabilityFormat.isEmpty()) {
            try {
                list.add(new TextComponentString(String.format(ConfigHandler.heldItemTooltipsConfig.appearanceConfig.durabilityFormat, this.itemstack.func_77958_k() - this.itemstack.func_77952_i(), this.itemstack.func_77958_k())).func_150255_a(style).func_150254_d());
            }
            catch (IllegalFormatException e) {
                ConsoleHud.LOGGER.error("Caught exception while parsing string format. Go to config file > helditemtooltips > appearance > Durability Format to fix this.");
            }
        } else {
            list.add(new TextComponentTranslation("item.durability", new Object[]{this.itemstack.func_77958_k() - this.itemstack.func_77952_i(), this.itemstack.func_77958_k()}).func_150255_a(style).func_150254_d());
        }
    }

    protected void getNameID(List<String> list, Style style) {
        ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.itemstack.func_77973_b());
        if (resource != null) {
            list.add(new TextComponentString(resource.toString()).func_150255_a(style).func_150254_d());
        }
    }

    protected void getNBTAmount(List<String> list, Style style) {
        if (this.itemstack.func_77942_o()) {
            list.add(new TextComponentTranslation("item.nbt_tags", new Object[]{this.itemstack.func_77978_p().func_150296_c().size()}).func_150255_a(style).func_150254_d());
        }
    }

    protected void getForgeInformation(List<String> list, ITooltipFlag.TooltipFlags tooltipflag) {
        if (ConfigHandler.heldItemTooltipsConfig.appearanceConfig.moddedTooltips) {
            ForgeEventFactory.onItemTooltip((ItemStack)this.itemstack, null, list, (ITooltipFlag)tooltipflag);
        }
    }

    protected void getLastLine(List<String> list, Style style, int i) {
        if (!ConfigHandler.heldItemTooltipsConfig.appearanceConfig.lastLineFormat.isEmpty()) {
            try {
                list.add(new TextComponentString(String.format(ConfigHandler.heldItemTooltipsConfig.appearanceConfig.lastLineFormat, i)).func_150255_a(style).func_150254_d());
            }
            catch (IllegalFormatException e) {
                ConsoleHud.LOGGER.error("Caught exception while parsing string format. Go to config file > helditemtooltips > appearance > Last Line Format to fix this.");
            }
        } else {
            list.add(new TextComponentTranslation("container.shulkerBox.more", new Object[]{i}).func_150255_a(style).func_150254_d());
        }
    }
}

