/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.consolehud.handler;

import com.fuzs.consolehud.handler.ConfigHandler;
import com.fuzs.consolehud.helper.PaperDollHelper;
import com.fuzs.consolehud.util.EnumPositionPreset;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SaveIconHandler
extends GuiIngame {
    private static final ResourceLocation SAVE_ICONS = new ResourceLocation("consolehud", "textures/gui/auto_save.png");
    private final int width = 18;
    private final int height = 30;
    private int remainingDisplayTicks;

    public SaveIconHandler() {
        super(Minecraft.func_71410_x());
    }

    @SubscribeEvent
    public void saveWorld(WorldEvent.Save evt) {
        if (ConfigHandler.saveIcon) {
            this.remainingDisplayTicks = ConfigHandler.saveIconConfig.displayTime;
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.remainingDisplayTicks > 0) {
            --this.remainingDisplayTicks;
        }
    }

    @SubscribeEvent
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre evt) {
        if (evt.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (this.remainingDisplayTicks > 0) {
            EnumPositionPreset position = ConfigHandler.saveIconConfig.position;
            this.field_73839_d.func_110434_K().func_110577_a(SAVE_ICONS);
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            int k = position.getX(this.width, evt.getResolution().func_78326_a(), ConfigHandler.saveIconConfig.xOffset);
            int l = position.getY(this.height, evt.getResolution().func_78328_b(), ConfigHandler.saveIconConfig.yOffset);
            if (ConfigHandler.saveIconConfig.potionShift && position.shouldShift()) {
                l += PaperDollHelper.getPotionShift(this.field_73839_d.field_71439_g.func_70651_bq());
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (ConfigHandler.saveIconConfig.rotatingModel) {
                int textureX = (int)((float)(this.remainingDisplayTicks % 12) * 0.5f) * 36;
                int textureY = 30 + (int)((float)(this.remainingDisplayTicks % 48) * 0.5f) / 6 * 36;
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                this.func_73729_b(k * 2, (l + 14) * 2, textureX, textureY, 36, 36);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            } else {
                this.func_73729_b(k, l, position.isMirrored() ? 162 : 144, 0, this.width, this.height);
            }
            if (ConfigHandler.saveIconConfig.showArrow) {
                int x = (int)((float)(this.remainingDisplayTicks % 16) * 0.5f) * this.width;
                this.func_73729_b(k, l, x, 0, this.width, this.height);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }
}

