/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntitySwan;
import pavocado.exoticbirds.models.ModelSwan;
import pavocado.exoticbirds.render.RenderBird;

public class RenderSwan
extends RenderBird<EntitySwan> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_mute.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_trumpeter.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_whooper.png");
    private static final ResourceLocation birdTexture4 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_black.png");
    private static final ResourceLocation babybirdTexture1 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_cygnet_mute.png");
    private static final ResourceLocation babybirdTexture2 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_cygnet_trumpeter.png");
    private static final ResourceLocation babybirdTexture3 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_cygnet_whooper.png");
    private static final ResourceLocation babybirdTexture4 = new ResourceLocation("exoticbirds:textures/entity/swan/swan_cygnet_black.png");

    public RenderSwan(RenderManager manager) {
        super(manager, new ModelSwan(), 0.4f);
    }

    protected float handleRotationFloat(EntitySwan livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntitySwan entity) {
        if (entity.func_70631_g_()) {
            switch (entity.getBirdType()) {
                case 0: {
                    return babybirdTexture1;
                }
                case 1: {
                    return babybirdTexture2;
                }
                case 2: {
                    return babybirdTexture3;
                }
                case 3: {
                    return babybirdTexture4;
                }
            }
            return babybirdTexture1;
        }
        return this.getEntityTextureForId(entity.getBirdType());
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
            case 3: {
                return birdTexture4;
            }
        }
        return birdTexture1;
    }
}

