/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityParrot;
import pavocado.exoticbirds.models.ModelParrot;
import pavocado.exoticbirds.render.RenderBird;

public class RenderParrot
extends RenderBird<EntityParrot> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/parrot/parrot_scarlet.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/parrot/parrot_blueyellow.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/parrot/parrot_military.png");
    private static final ResourceLocation birdTexture4 = new ResourceLocation("exoticbirds:textures/entity/parrot/parrot_hyacinth.png");
    private static final ResourceLocation birdTexture5 = new ResourceLocation("exoticbirds:textures/entity/parrot/parrot_grey.png");
    private static final ResourceLocation birdTexture6 = new ResourceLocation("exoticbirds:textures/entity/parrot/parrot_galah.png");

    public RenderParrot(RenderManager manager) {
        super(manager, new ModelParrot(), 0.3f);
    }

    protected float handleRotationFloat(EntityParrot livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityParrot entity) {
        return this.getEntityTextureForId(entity.getBirdType());
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
            case 3: {
                return birdTexture4;
            }
            case 4: {
                return birdTexture5;
            }
            case 5: {
                return birdTexture6;
            }
        }
        return birdTexture1;
    }
}

