/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityHummingbird;
import pavocado.exoticbirds.models.ModelHummingbird;
import pavocado.exoticbirds.render.RenderBird;

public class RenderHummingbird
extends RenderBird<EntityHummingbird> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird1.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird2.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird3.png");
    private static final ResourceLocation birdTexture4 = new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird4.png");
    private static final ResourceLocation birdTexture5 = new ResourceLocation("exoticbirds:textures/entity/hummingbird/hummingbird5.png");

    public RenderHummingbird(RenderManager manager) {
        super(manager, new ModelHummingbird(), 0.1f);
    }

    protected float handleRotationFloat(EntityHummingbird livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    @Override
    public ResourceLocation getEntityTextureForId(int birdId) {
        switch (birdId) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
            case 3: {
                return birdTexture4;
            }
            case 4: {
                return birdTexture5;
            }
        }
        return birdTexture1;
    }
}

