/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.glu.Project;
import pavocado.exoticbirds.entity.Birds.EntityPhoenix;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsBlocks;
import pavocado.exoticbirds.render.RenderBird;
import pavocado.exoticbirds.render.RenderBluejay;
import pavocado.exoticbirds.render.RenderBooby;
import pavocado.exoticbirds.render.RenderCardinal;
import pavocado.exoticbirds.render.RenderCassowary;
import pavocado.exoticbirds.render.RenderCrane;
import pavocado.exoticbirds.render.RenderDuck;
import pavocado.exoticbirds.render.RenderFlamingo;
import pavocado.exoticbirds.render.RenderGouldianfinch;
import pavocado.exoticbirds.render.RenderHeron;
import pavocado.exoticbirds.render.RenderHummingbird;
import pavocado.exoticbirds.render.RenderKingfisher;
import pavocado.exoticbirds.render.RenderKiwi;
import pavocado.exoticbirds.render.RenderKookaburra;
import pavocado.exoticbirds.render.RenderLyrebird;
import pavocado.exoticbirds.render.RenderMagpie;
import pavocado.exoticbirds.render.RenderOstrich;
import pavocado.exoticbirds.render.RenderOwl;
import pavocado.exoticbirds.render.RenderParrot;
import pavocado.exoticbirds.render.RenderPeafowl;
import pavocado.exoticbirds.render.RenderPelican;
import pavocado.exoticbirds.render.RenderPenguin;
import pavocado.exoticbirds.render.RenderPhoenix;
import pavocado.exoticbirds.render.RenderPigeon;
import pavocado.exoticbirds.render.RenderRoadrunner;
import pavocado.exoticbirds.render.RenderRobin;
import pavocado.exoticbirds.render.RenderSeagull;
import pavocado.exoticbirds.render.RenderSwan;
import pavocado.exoticbirds.render.RenderToucan;
import pavocado.exoticbirds.render.RenderVulture;
import pavocado.exoticbirds.render.RenderWoodpecker;

public class GuiBirdBook
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("exoticbirds:textures/gui/birdbook/birdbook.png");
    private static final ResourceLocation icons = new ResourceLocation(":textures/gui/icons.png");
    int xSize = 176;
    int ySize = 166;
    private GuiTextField searchField;
    private RotateButton buttonLeft;
    private RotateButton buttonRight;
    private SpinButton buttonSpin;
    private BirdButton buttonBird1;
    private BirdButton buttonBird2;
    private BirdButton buttonBird3;
    private BirdButton buttonBird4;
    private BirdButton buttonBird5;
    private BirdButton buttonBird6;
    private BirdButton buttonBird7;
    private BirdButton buttonBird8;
    private GenderButton buttonGenderM;
    private GenderButton buttonGenderF;
    private SwitchButton buttonSwitch;
    private boolean wasClicking;
    private float currentScroll;
    private boolean isScrolling;
    private int currentId = 0;
    private int rotateAngle;
    private boolean autoRotate = true;
    private int previousTime;
    private int currentBirdType = 0;
    private EnumBirdTypes birdObject;
    private RenderBird birdRenderer;
    private List birdList = Lists.newArrayList();

    public GuiBirdBook(EntityPlayer player) {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean flag = Mouse.isButtonDown((int)0);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        int i1 = x + 69;
        int j1 = y + 22;
        int k1 = i1 + 9;
        int l1 = j1 + 136;
        if (!this.wasClicking && flag && mouseX >= i1 && mouseY >= j1 && mouseX < k1 && mouseY < l1) {
            this.isScrolling = true;
        }
        if (!flag || this.birdList.size() < 8) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - j1) - 7.5f) / ((float)(l1 - j1) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.UpdateBirdSearch();
        }
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.birdObject = EnumBirdTypes.byMetadata(this.currentId);
        this.birdRenderer = this.getBirdRenderer();
        GuiBirdBook.drawCentralText(this.field_146289_q, "\u00a7l" + I18n.func_135052_a((String)("book.exoticbirds." + this.birdObject.getLocalisation() + ".name"), (Object[])new Object[0]), x + 153, y + 5, 0x404040);
        GuiBirdBook.drawCentralText(this.field_146289_q, "\u00a7o" + I18n.func_135052_a((String)("book.exoticbirds." + this.birdObject.getLocalisation() + ".family"), (Object[])new Object[0]), x + 153, y + 15, 0x666666);
        this.buttonGenderM.field_146124_l = false;
        this.buttonGenderF.field_146124_l = false;
        this.buttonSwitch.field_146124_l = false;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)("book.exoticbirds." + this.birdObject.getLocalisation() + ".info"), (Object[])new Object[0]), x * 2 + 181, y * 2 + 53, 250, 0x5B5B5B);
        GlStateManager.func_179121_F();
        if (this.birdObject != null) {
            String healthStr = String.valueOf(this.birdObject.getMaxHealth() / 2.0);
            if (healthStr.endsWith(".0")) {
                healthStr = healthStr.substring(0, healthStr.length() - 2);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.health.line", (Object[])new Object[]{healthStr}), x * 2 + 200, y * 2 + 158, 100, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.tempt.line", (Object[])new Object[]{this.birdObject.getTemptedItemString()}), x * 2 + 190, y * 2 + 169, 120, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.breed.line", (Object[])new Object[]{this.birdObject.getBreedItemString()}), x * 2 + 190, y * 2 + 179, 120, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.tame.line", (Object[])new Object[]{this.birdObject.getTameItemString()}), x * 2 + 190, y * 2 + 189, 120, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.egg.line", (Object[])new Object[0]), x * 2 + 190, y * 2 + 209, 115, 0xFFFFFF);
            String entityNumber = this.birdObject.getNumberOfTypes() > 1 && !this.birdObject.isGendered() ? String.valueOf(this.currentBirdType % this.birdObject.getNumberOfTypes()) : "";
            String entityName = I18n.func_135052_a((String)("species.exoticbirds." + this.birdObject.getLocalisation() + entityNumber + ".name"), (Object[])new Object[0]);
            this.field_146289_q.func_78279_b(entityName, x * 2 + 317, y * 2 + 155, 90, 0xFFFFFF);
            if (this.birdObject.isGendered()) {
                String genderTranslation = this.currentBirdType % 2 == 0 ? "book.exoticbirds.gender.male" : "book.exoticbirds.gender.female";
                this.field_146289_q.func_78279_b(I18n.func_135052_a((String)genderTranslation, (Object[])new Object[0]), x * 2 + 317, y * 2 + 269, 80, 0xFFFFFF);
                this.buttonGenderM.field_146124_l = true;
                this.buttonGenderF.field_146124_l = true;
            } else {
                this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.types.line", (Object[])new Object[]{this.currentBirdType + 1, this.birdObject.getNumberOfTypes()}), x * 2 + 317, y * 2 + 269, 80, 0xFFFFFF);
                this.buttonSwitch.field_146124_l = true;
            }
            GlStateManager.func_179121_F();
            if (this.birdObject.getNumberOfTypes() == 1) {
                this.buttonSwitch.field_146124_l = false;
            }
        }
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, y, 0, 0, this.xSize, this.ySize);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.field_146297_k.func_110434_K().func_110577_a(icons);
        this.func_73729_b(x * 2 + 187, y * 2 + 157, 52, 9, 9, 9);
        this.func_73729_b(x * 2 + 187, y * 2 + 157, 52, 0, 9, 9);
        GlStateManager.func_179121_F();
        if (this.birdObject != null) {
            this.drawEntityOnScreen((float)(y + 75) - (float)mouseY);
            if (this.birdObject.GetEntityClass() == EntityPhoenix.class) {
                this.drawEgg(new ItemStack(ExoticbirdsBlocks.phoenix_egg), x / 2 + 53, y / 2 + 53);
            } else {
                this.drawEgg(new ItemStack(this.birdObject.getBirdEgg()), x / 2 + 53, y / 2 + 53);
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(background);
        if (this.birdList.size() > 8) {
            this.func_73729_b(x + 69, (int)((float)(y + 22) + 123.0f * this.currentScroll), 0, 220, 9, 13);
        } else {
            this.func_73729_b(x + 69, (int)((float)(y + 22) + 123.0f * this.currentScroll), 9, 220, 9, 13);
        }
        this.searchField.func_146194_f();
        this.rotateEntity(mouseX, mouseY);
    }

    public void func_73866_w_() {
        this.xSize = 220;
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int i = (this.field_146294_l - this.xSize) / 2;
        int j = (this.field_146295_m - this.ySize) / 2;
        this.buttonLeft = new RotateButton(1, i + 158, j + 144, true);
        this.field_146292_n.add(this.buttonLeft);
        this.buttonRight = new RotateButton(2, i + 199, j + 144, false);
        this.field_146292_n.add(this.buttonRight);
        this.buttonSpin = new SpinButton(3, i + 171, j + 145);
        this.field_146292_n.add(this.buttonSpin);
        this.buttonBird1 = new BirdButton(4, i + 6, j + 22, 0);
        this.field_146292_n.add(this.buttonBird1);
        this.buttonBird2 = new BirdButton(5, i + 6, j + 39, 0);
        this.field_146292_n.add(this.buttonBird2);
        this.buttonBird3 = new BirdButton(6, i + 6, j + 56, 0);
        this.field_146292_n.add(this.buttonBird3);
        this.buttonBird4 = new BirdButton(7, i + 6, j + 73, 0);
        this.field_146292_n.add(this.buttonBird4);
        this.buttonBird5 = new BirdButton(8, i + 6, j + 90, 0);
        this.field_146292_n.add(this.buttonBird5);
        this.buttonBird6 = new BirdButton(9, i + 6, j + 107, 0);
        this.field_146292_n.add(this.buttonBird6);
        this.buttonBird7 = new BirdButton(10, i + 6, j + 124, 0);
        this.field_146292_n.add(this.buttonBird7);
        this.buttonBird8 = new BirdButton(11, i + 6, j + 141, 0);
        this.field_146292_n.add(this.buttonBird8);
        this.buttonGenderF = new GenderButton(12, i + 111, j + 144, true);
        this.field_146292_n.add(this.buttonGenderF);
        this.buttonGenderM = new GenderButton(13, i + 91, j + 144, false);
        this.field_146292_n.add(this.buttonGenderM);
        this.buttonSwitch = new SwitchButton(14, i + 134, j + 144);
        this.field_146292_n.add(this.buttonSwitch);
        this.searchField = new GuiTextField(0, this.field_146289_q, i + 9, j + 9, 69, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(11);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.searchField.func_146180_a("");
        this.UpdateBirdSearch();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 1 || button.field_146127_k == 2) {
                this.previousTime = this.rotateAngle;
                this.autoRotate = false;
            } else if (button.field_146127_k == 3) {
                this.previousTime = this.rotateAngle;
                this.autoRotate = !this.autoRotate;
            } else if (button.field_146127_k == 12 || button.field_146127_k == 13) {
                if (this.birdObject != null && this.birdObject.isGendered()) {
                    this.currentBirdType = button.field_146127_k - 12;
                }
            } else if (button.field_146127_k == 14) {
                if (this.birdObject != null && !this.birdObject.isGendered()) {
                    this.currentBirdType = (this.currentBirdType + 1) % this.birdObject.getNumberOfTypes();
                }
            } else if (button instanceof BirdButton) {
                this.currentBirdType = 0;
                this.currentId = ((BirdButton)button).meta;
            }
        }
    }

    protected RenderBird getBirdRenderer() {
        switch (EnumBirdTypes.byMetadata(this.currentId)) {
            case CASSOWARY: {
                return new RenderCassowary(null);
            }
            case DUCK: {
                return new RenderDuck(null);
            }
            case FLAMINGO: {
                return new RenderFlamingo(null);
            }
            case GOULDIANFINCH: {
                return new RenderGouldianfinch(null);
            }
            case HUMMINGBIRD: {
                return new RenderHummingbird(null);
            }
            case KINGFISHER: {
                return new RenderKingfisher(null);
            }
            case KIWI: {
                return new RenderKiwi(null);
            }
            case LYREBIRD: {
                return new RenderLyrebird(null);
            }
            case MAGPIE: {
                return new RenderMagpie(null);
            }
            case OSTRICH: {
                return new RenderOstrich(null);
            }
            case OWL: {
                return new RenderOwl(null);
            }
            case PARROT: {
                return new RenderParrot(null);
            }
            case PEAFOWL: {
                return new RenderPeafowl(null);
            }
            case PELICAN: {
                return new RenderPelican(null);
            }
            case EMPERORPENGUIN: {
                return new RenderPenguin(null);
            }
            case PHOENIX: {
                return new RenderPhoenix(null);
            }
            case PIGEON: {
                return new RenderPigeon(null);
            }
            case ROADRUNNER: {
                return new RenderRoadrunner(null);
            }
            case SEAGULL: {
                return new RenderSeagull(null);
            }
            case SWAN: {
                return new RenderSwan(null);
            }
            case TOUCAN: {
                return new RenderToucan(null);
            }
            case VULTURE: {
                return new RenderVulture(null);
            }
            case WOODPECKER: {
                return new RenderWoodpecker(null);
            }
            case HERON: {
                return new RenderHeron(null);
            }
            case BOOBY: {
                return new RenderBooby(null);
            }
            case CARDINAL: {
                return new RenderCardinal(null);
            }
            case BLUEJAY: {
                return new RenderBluejay(null);
            }
            case ROBIN: {
                return new RenderRobin(null);
            }
            case CRANE: {
                return new RenderCrane(null);
            }
            case KOOKABURRA: {
                return new RenderKookaburra(null);
            }
        }
        return null;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.currentScroll = 0.0f;
            this.UpdateBirdSearch();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void rotateEntity(int mouseX, int mouseY) {
        boolean mouseFlag = Mouse.isButtonDown((int)0);
        if (!this.autoRotate) {
            if (mouseFlag && this.buttonLeft.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                ++this.rotateAngle;
            }
            if (mouseFlag && this.buttonRight.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                --this.rotateAngle;
            }
        } else {
            this.rotateAngle = (int)(Minecraft.func_71386_F() / 8L % 360L);
        }
        this.rotateAngle %= 360;
    }

    public static void drawCentralText(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_78276_b(text, x - fontRendererIn.func_78256_a(text) / 2, y, color);
    }

    protected void drawEgg(ItemStack item, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146296_j.func_180450_b(item, x, y);
        this.field_146296_j.func_175030_a(this.field_146289_q, item, x, y);
        GlStateManager.func_179140_f();
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        GlStateManager.func_179121_F();
    }

    public void drawEntityOnScreen(float mouseY) {
        if (this.birdObject != null && this.birdRenderer != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
            GlStateManager.func_179083_b((int)((scaledresolution.func_78326_a() - 320) / 2 * scaledresolution.func_78325_e()), (int)((scaledresolution.func_78328_b() - 240) / 2 * scaledresolution.func_78325_e()), (int)(320 * scaledresolution.func_78325_e()), (int)(240 * scaledresolution.func_78325_e()));
            Project.gluPerspective((float)90.0f, (float)1.3333334f, (float)9.0f, (float)80.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            RenderHelper.func_74519_b();
            GlStateManager.func_179109_b((float)6.5f, (float)-1.3f, (float)-11.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.birdRenderer.getEntityTextureForId(this.currentBirdType));
            float modelScale = this.birdObject.getModelScale();
            GlStateManager.func_179152_a((float)modelScale, (float)modelScale, (float)modelScale);
            float translationOffset = this.birdObject.getModelOffset();
            GlStateManager.func_179109_b((float)0.0f, (float)translationOffset, (float)0.0f);
            GlStateManager.func_179114_b((float)this.rotateAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179091_B();
            ModelBase entityModel = this.birdObject.getModel();
            entityModel.field_78091_s = false;
            entityModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, (float)Math.atan(mouseY / 40.0f) * 10.0f, 0.0625f);
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
    }

    private void UpdateBirdSearch() {
        this.birdList.clear();
        for (int i = 0; i < EnumBirdTypes.values().length; ++i) {
            String[] o = new String[]{I18n.func_135052_a((String)("book.exoticbirds." + EnumBirdTypes.byMetadata(i).getLocalisation() + ".name"), (Object[])new Object[0]), EnumBirdTypes.byMetadata(i).getLocalisation()};
            this.birdList.add(o);
        }
        Collections.sort(this.birdList, new Comparator<String[]>(){

            @Override
            public int compare(String[] first, String[] second) {
                return first[0].compareTo(second[0]);
            }
        });
        ArrayList birdList1 = Lists.newArrayList();
        String s1 = this.searchField.func_146179_b().toLowerCase();
        for (int i = 0; i < this.birdList.size(); ++i) {
            if (!TextFormatting.func_110646_a((String)I18n.func_135052_a((String)("book.exoticbirds." + ((String[])this.birdList.get(i))[1].toString() + ".name"), (Object[])new Object[0])).toLowerCase().contains(s1)) continue;
            birdList1.add(TextFormatting.func_110646_a((String)((String[])this.birdList.get(i))[1].toString()).toLowerCase());
        }
        this.birdList = birdList1;
        this.updateFilteredItems();
    }

    private void updateFilteredItems() {
        for (int i = 3; i < this.field_146292_n.size(); ++i) {
            if (!(this.field_146292_n.get(i) instanceof BirdButton)) continue;
            ((BirdButton)((Object)this.field_146292_n.get((int)i))).field_146126_j = "";
            ((BirdButton)((Object)this.field_146292_n.get((int)i))).meta = -1;
            ((BirdButton)((Object)this.field_146292_n.get((int)i))).field_146125_m = false;
        }
        for (int j = 0; j < MathHelper.func_76125_a((int)this.birdList.size(), (int)0, (int)8); ++j) {
            int q = j + MathHelper.func_76125_a((int)((int)(this.currentScroll * (float)(this.birdList.size() - 8))), (int)0, (int)this.birdList.size());
            ((BirdButton)((Object)this.field_146292_n.get((int)(j + 3)))).field_146126_j = I18n.func_135052_a((String)("book.exoticbirds." + this.birdList.get(q).toString() + ".name"), (Object[])new Object[0]);
            ((BirdButton)((Object)this.field_146292_n.get((int)(j + 3)))).meta = EnumBirdTypes.byLocalisation(this.birdList.get(q).toString());
            ((BirdButton)((Object)this.field_146292_n.get((int)(j + 3)))).field_146125_m = true;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.birdList.size() > 8) {
            int j = this.birdList.size() - 8;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.UpdateBirdSearch();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SwitchButton
    extends GuiButton {
        public SwitchButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 18, 18, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 147;
                int l = 166;
                if (!this.field_146124_l) {
                    l += this.field_146121_g * 2;
                } else if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class GenderButton
    extends GuiButton {
        public boolean female = true;

        public GenderButton(int buttonId, int x, int y, boolean genderF) {
            super(buttonId, x, y, 18, 18, "");
            this.female = genderF;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 0;
                int l = 166;
                if (this.female) {
                    k += this.field_146120_f;
                }
                if (!this.field_146124_l) {
                    l += this.field_146121_g * 2;
                } else if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class BirdButton
    extends GuiButton {
        public int meta;

        public BirdButton(int buttonId, int x, int y, int birdMeta) {
            super(buttonId, x, y, 60, 17, "");
            this.meta = birdMeta;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 85;
                int l = 166;
                if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GuiBirdBook.drawCentralText(mc.field_71466_p, this.field_146126_j, this.field_146128_h * 2 + (this.field_146120_f + 60) / 2, this.field_146129_i * 2 + (this.field_146121_g + 9) / 2, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SpinButton
    extends GuiButton {
        public SpinButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 26, 15, I18n.func_135052_a((String)"book.exoticbirds.button.spin", (Object[])new Object[0]));
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 58;
                int l = 166;
                if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GuiBirdBook.drawCentralText(mc.field_71466_p, "\u00a7l" + this.field_146126_j, this.field_146128_h * 2 + (this.field_146120_f + 26) / 2, this.field_146129_i * 2 + (this.field_146121_g + 8) / 2, 0x404040);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class RotateButton
    extends GuiButton {
        private final boolean isFlipped;

        public RotateButton(int buttonId, int x, int y, boolean mirror) {
            super(buttonId, x, y, 11, 17, "");
            this.isFlipped = mirror;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 36;
                int l = 166;
                if (flag) {
                    l += this.field_146121_g;
                }
                if (this.isFlipped) {
                    k += this.field_146120_f;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

