/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.AI.EntityAIBirdFollowOwner;
import pavocado.exoticbirds.entity.AI.EntityAIBirdSit;
import pavocado.exoticbirds.entity.AI.EntityAILayEggInNest;
import pavocado.exoticbirds.entity.Birds.EntityBirdTameable;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;

public class EntityParrot
extends EntityBirdTameable {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private EntityAITempt aiTempt;

    public EntityParrot(World worldIn) {
        super(worldIn, EnumBirdTypes.PARROT.getBirdEgg(), EnumBirdTypes.PARROT.getNumberOfTypes(), true, EnumBirdTypes.PARROT.isGendered());
        this.func_70105_a(0.5f, 0.85f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.aiSit = new EntityAIBirdSit(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILayEggInNest(this, EnumBirdTypes.PARROT.getBirdEgg()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIBirdFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.9));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.75f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EnumBirdTypes.PARROT.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected SoundEvent func_184639_G() {
        return ExoticbirdsSoundEvents.ENTITY_PARROT_AMBIENT;
    }

    protected SoundEvent getHurtSound() {
        return ExoticbirdsSoundEvents.ENTITY_PARROT_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return ExoticbirdsSoundEvents.ENTITY_PARROT_AMBIENT;
    }

    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151080_bb) {
            return false;
        }
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151057_cb) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!this.isTamed() && itemstack.func_77973_b() == Items.field_151080_bb && player.func_70068_e((Entity)this) < 9.0) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.setTamedBy(player);
                    this.playTameEffect(true);
                    this.aiSit.setSitting(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
            if (player.func_70093_af() && !this.field_70170_p.field_72995_K && !this.field_70128_L) {
                return true;
            }
            if (!this.func_70877_b(itemstack) && !this.field_70170_p.field_72995_K) {
                this.aiSit.setSitting(!this.isSitting());
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityParrot entityparrot = new EntityParrot(this.field_70170_p);
        entityparrot.setBirdType(this.getBirdType());
        if (this.isTamed()) {
            entityparrot.setOwnerId(this.func_184753_b());
            entityparrot.setTamed(true);
        }
        return entityparrot;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityParrot)) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        EntityParrot entityparrot = (EntityParrot)otherAnimal;
        if (entityparrot.getBirdType() == this.getBirdType()) {
            return this.func_70880_s() && entityparrot.func_70880_s();
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_PARROT;
    }
}

