/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageSpamlessChat;
import vazkii.quark.base.network.message.MessageUpdateAfk;

public class ImprovedSleeping
extends Feature {
    private int timeSinceKeystroke;
    private static List<String> sleepingPlayers = new ArrayList<String>();
    private static boolean enableAfk;
    private static int afkTime;
    private static int percentReq;
    private static final String TAG_AFK = "quark:afk";
    private static final int AFK_MSG;
    private static final int SLEEP_MSG;

    @Override
    public void setupConfig() {
        enableAfk = this.loadPropBool("Enable AFK", "", true);
        afkTime = this.loadPropInt("Time for AFK", "How many ticks are required for a player to be marked AFK", 2400);
        percentReq = this.loadPropInt("Required Percentage", "The percentage of the (non-afk) server that needs to be sleeping for the time to change.", 100);
    }

    public static void updateAfk(EntityPlayer player, boolean afk) {
        if (!enableAfk) {
            return;
        }
        if (player.field_70170_p.field_73010_i.size() != 1) {
            if (afk) {
                player.getEntityData().func_74757_a(TAG_AFK, true);
                TextComponentTranslation text = new TextComponentTranslation("quarkmisc.nowAfk", new Object[0]);
                text.func_150256_b().func_150238_a(TextFormatting.AQUA);
                player.func_145747_a((ITextComponent)text);
                if (player instanceof EntityPlayerMP) {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSpamlessChat((ITextComponent)text, AFK_MSG), (EntityPlayerMP)player);
                }
            } else {
                player.getEntityData().func_74757_a(TAG_AFK, false);
                TextComponentTranslation text = new TextComponentTranslation("quarkmisc.leftAfk", new Object[0]);
                text.func_150256_b().func_150238_a(TextFormatting.AQUA);
                player.func_145747_a((ITextComponent)text);
                if (player instanceof EntityPlayerMP) {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSpamlessChat((ITextComponent)text, AFK_MSG), (EntityPlayerMP)player);
                }
            }
        }
    }

    public static int isEveryoneAsleep(World world) {
        if (!ModuleLoader.isFeatureEnabled(ImprovedSleeping.class)) {
            return 0;
        }
        Pair<Integer, Integer> counts = ImprovedSleeping.getPlayerCounts(world);
        int legitPlayers = (Integer)counts.getLeft();
        int sleepingPlayers = (Integer)counts.getRight();
        int reqPlayers = (int)((float)percentReq / 100.0f * (float)legitPlayers);
        boolean everybody = legitPlayers > 0 && (float)sleepingPlayers / (float)reqPlayers >= 1.0f;
        return everybody ? 2 : 1;
    }

    private static boolean doesPlayerCountForSleeping(EntityPlayer player) {
        return !player.func_175149_v() && !player.getEntityData().func_74767_n(TAG_AFK);
    }

    private static boolean isPlayerSleeping(EntityPlayer player) {
        return player.func_71026_bH();
    }

    private static Pair<Integer, Integer> getPlayerCounts(World world) {
        int legitPlayers = 0;
        int sleepingPlayers = 0;
        for (EntityPlayer player : world.field_73010_i) {
            if (!ImprovedSleeping.doesPlayerCountForSleeping(player)) continue;
            ++legitPlayers;
            if (!ImprovedSleeping.isPlayerSleeping(player)) continue;
            ++sleepingPlayers;
        }
        return Pair.of((Object)legitPlayers, (Object)sleepingPlayers);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        MinecraftServer server = world.func_73046_m();
        if (event.side == Side.CLIENT || world.field_73011_w.getDimension() != 0 || event.phase != TickEvent.Phase.END || server == null) {
            return;
        }
        ArrayList<String> sleepingPlayers = new ArrayList<String>();
        ArrayList<String> newSleepingPlayers = new ArrayList<String>();
        ArrayList<String> nonSleepingPlayers = new ArrayList<String>();
        int legitPlayers = 0;
        for (EntityPlayer player : world.field_73010_i) {
            if (!ImprovedSleeping.doesPlayerCountForSleeping(player)) continue;
            String name = player.func_70005_c_();
            if (ImprovedSleeping.isPlayerSleeping(player)) {
                if (!ImprovedSleeping.sleepingPlayers.contains(name)) {
                    newSleepingPlayers.add(name);
                }
                sleepingPlayers.add(name);
            } else {
                nonSleepingPlayers.add(name);
            }
            ++legitPlayers;
        }
        ImprovedSleeping.sleepingPlayers = sleepingPlayers;
        if (!newSleepingPlayers.isEmpty() && world.field_73010_i.size() != 1) {
            int requiredPlayers = Math.max((int)Math.ceil((float)(legitPlayers * percentReq) / 100.0f), 0);
            TextComponentString sibling = new TextComponentString("(" + sleepingPlayers.size() + "/" + requiredPlayers + ")");
            TextComponentString sleepingList = new TextComponentString("");
            for (String s : sleepingPlayers) {
                sleepingList.func_150257_a(new TextComponentString("\n\u2714 " + s).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
            for (String s : nonSleepingPlayers) {
                sleepingList.func_150257_a(new TextComponentString("\n\u2718 " + s).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            TextComponentTranslation hoverText = new TextComponentTranslation("quarkmisc.sleepingListHeader", new Object[]{sleepingList});
            for (String sleeper : newSleepingPlayers) {
                TextComponentTranslation message = new TextComponentTranslation("quarkmisc.personSleeping", new Object[]{sleeper});
                message.func_150256_b().func_150238_a(TextFormatting.GOLD);
                message.func_150258_a(" ");
                message.func_150257_a(sibling.func_150259_f());
                HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverText.func_150259_f());
                sibling.func_150256_b().func_150209_a(hover);
                sibling.func_150256_b().func_150228_d(Boolean.valueOf(true));
                for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSpamlessChat((ITextComponent)message, SLEEP_MSG), player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer lastPlayer;
        World logoutWorld = event.player.field_70170_p;
        List players = logoutWorld.field_73010_i;
        if (players.size() == 1 && (lastPlayer = (EntityPlayer)players.get(0)).getEntityData().func_74767_n(TAG_AFK)) {
            lastPlayer.getEntityData().func_74757_a(TAG_AFK, false);
            TextComponentTranslation text = new TextComponentTranslation("quarkmisc.leftAfk", new Object[0]);
            text.func_150256_b().func_150238_a(TextFormatting.AQUA);
            if (lastPlayer instanceof EntityPlayerMP) {
                NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSpamlessChat((ITextComponent)text, AFK_MSG), (EntityPlayerMP)lastPlayer);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.timeSinceKeystroke;
            if (this.timeSinceKeystroke == afkTime) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateAfk(true));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeystroke(InputEvent.KeyInputEvent event) {
        this.registerPress();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeystroke(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        this.registerPress();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerClick(PlayerInteractEvent event) {
        this.registerPress();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMousePress(InputEvent.MouseInputEvent event) {
        if (Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71462_r != null) {
            this.registerPress();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMousePress(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (Mouse.getEventButtonState() && Minecraft.func_71410_x().field_71462_r != null) {
            this.registerPress();
        }
    }

    private void registerPress() {
        if (this.timeSinceKeystroke >= afkTime) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateAfk(false));
        }
        this.timeSinceKeystroke = 0;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"morpheus", "sleepingoverhaul"};
    }

    static {
        AFK_MSG = "quark afk".hashCode();
        SLEEP_MSG = "quark sleep".hashCode();
    }
}

