/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.arl.block.tile.TileSimpleInventory;
import vazkii.quark.base.sounds.QuarkSounds;
import vazkii.quark.oddities.block.BlockPipe;
import vazkii.quark.oddities.feature.Pipes;

public class TilePipe
extends TileSimpleInventory
implements ITickable {
    private static final String TAG_PIPE_ITEMS = "pipeItems";
    private boolean needsSync = false;
    private boolean iterating = false;
    public final List<PipeItem> pipeItems = new LinkedList<PipeItem>();
    public final List<PipeItem> queuedItems = new LinkedList<PipeItem>();

    public static boolean isTheGoodDay(World world) {
        Calendar calendar = world.func_83015_S();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public void func_73660_a() {
        if (!this.isPipeEnabled() && this.field_145850_b.func_82737_E() % 10L == 0L && this.field_145850_b instanceof WorldServer) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.REDSTONE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 3, 0.2, 0.2, 0.2, 0.0, new int[0]);
        }
        IBlockState blockAt = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.isPipeEnabled() && blockAt.func_177230_c() instanceof BlockPipe) {
            IBlockState actualState = blockAt.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                BlockPos offset = this.field_174879_c.func_177972_a(side);
                if (this.field_145850_b.func_180495_p(offset).func_193401_d((IBlockAccess)this.field_145850_b, offset, side.func_176734_d()) != BlockFaceShape.UNDEFINED || this.field_145850_b.field_72995_K || BlockPipe.getType(actualState, side) != BlockPipe.ConnectionType.FLARE) continue;
                double minX = (double)this.field_174879_c.func_177958_n() + 0.25 + 0.5 * (double)Math.min(0, side.func_82601_c());
                double minY = (double)this.field_174879_c.func_177956_o() + 0.25 + 0.5 * (double)Math.min(0, side.func_96559_d());
                double minZ = (double)this.field_174879_c.func_177952_p() + 0.25 + 0.5 * (double)Math.min(0, side.func_82599_e());
                double maxX = (double)this.field_174879_c.func_177958_n() + 0.75 + 0.5 * (double)Math.max(0, side.func_82601_c());
                double maxY = (double)this.field_174879_c.func_177956_o() + 0.75 + 0.5 * (double)Math.max(0, side.func_96559_d());
                double maxZ = (double)this.field_174879_c.func_177952_p() + 0.75 + 0.5 * (double)Math.max(0, side.func_82599_e());
                EnumFacing opposite = side.func_176734_d();
                boolean any = false;
                for (EntityItem item : this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ), entity -> entity != null && entity.func_70089_S() && EnumFacing.func_176737_a((float)((float)entity.field_70159_w), (float)((float)entity.field_70181_x), (float)((float)entity.field_70179_y)) == opposite)) {
                    this.passIn(item.func_92059_d().func_77946_l(), side);
                    if (Pipes.doPipesWhoosh) {
                        if (TilePipe.isTheGoodDay(this.field_145850_b)) {
                            this.field_145850_b.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, QuarkSounds.BLOCK_PIPE_PICKUP_LENNY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        } else {
                            this.field_145850_b.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, QuarkSounds.BLOCK_PIPE_PICKUP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    any = true;
                    item.func_70106_y();
                }
                if (!any) continue;
                this.sync();
            }
        }
        int currentOut = this.getComparatorOutput();
        if (!this.pipeItems.isEmpty()) {
            if (Pipes.maxPipeItems > 0 && this.pipeItems.size() > Pipes.maxPipeItems && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175718_b(2001, this.field_174879_c, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c)));
                this.dropItem(new ItemStack(this.func_145838_q()));
                this.field_145850_b.func_175698_g(this.func_174877_v());
            }
            ListIterator<PipeItem> itemItr = this.pipeItems.listIterator();
            this.iterating = true;
            this.needsSync = false;
            while (itemItr.hasNext()) {
                PipeItem item = itemItr.next();
                EnumFacing lastFacing = item.outgoingFace;
                if (!item.tick(this)) continue;
                this.needsSync = true;
                itemItr.remove();
                if (item.valid) {
                    this.passOut(item);
                    continue;
                }
                this.dropItem(item.stack, lastFacing, true);
            }
            this.iterating = false;
            this.pipeItems.addAll(this.queuedItems);
            if (this.needsSync || !this.queuedItems.isEmpty()) {
                this.sync();
            }
            this.needsSync = false;
            this.queuedItems.clear();
        }
        if (this.getComparatorOutput() != currentOut) {
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_145838_q());
        }
    }

    public int getComparatorOutput() {
        return Math.min(15, this.pipeItems.size());
    }

    public Iterator<PipeItem> getItemIterator() {
        return this.pipeItems.iterator();
    }

    public boolean passIn(ItemStack stack, EnumFacing face, long seed, int time) {
        PipeItem item = new PipeItem(stack, face, seed);
        if (!this.iterating) {
            int currentOut = this.getComparatorOutput();
            this.pipeItems.add(item);
            item.timeInWorld = time;
            if (this.getComparatorOutput() != currentOut) {
                this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_145838_q());
            }
        } else {
            this.queuedItems.add(item);
        }
        return true;
    }

    public boolean passIn(ItemStack stack, EnumFacing face) {
        return this.passIn(stack, face, this.field_145850_b.field_73012_v.nextLong(), 0);
    }

    protected void passOut(PipeItem item) {
        BlockPos targetPos = this.func_174877_v().func_177972_a(item.outgoingFace);
        TileEntity tile = this.field_145850_b.func_175625_s(targetPos);
        boolean did = false;
        if (tile != null) {
            ItemStack result;
            if (tile instanceof TilePipe) {
                did = ((TilePipe)tile).passIn(item.stack, item.outgoingFace.func_176734_d(), item.rngSeed, item.timeInWorld);
            } else if (!this.field_145850_b.field_72995_K && (result = this.putIntoInv(item.stack, tile, item.outgoingFace.func_176734_d(), false)).func_190916_E() != item.stack.func_190916_E()) {
                did = true;
                if (!result.func_190926_b()) {
                    this.bounceBack(item, result);
                }
            }
        }
        if (!did) {
            this.bounceBack(item, null);
        }
    }

    private void bounceBack(PipeItem item, ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            this.passIn(stack == null ? item.stack : stack, item.outgoingFace, item.rngSeed, item.timeInWorld);
        }
    }

    public void dropItem(ItemStack stack) {
        this.dropItem(stack, null, false);
    }

    public void dropItem(ItemStack stack, EnumFacing facing, boolean playSound) {
        if (!this.field_145850_b.field_72995_K) {
            double posX = (double)this.field_174879_c.func_177958_n() + 0.5;
            double posY = (double)this.field_174879_c.func_177956_o() + 0.25;
            double posZ = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (facing != null) {
                posX -= (double)facing.func_82601_c() * 0.4;
                posY -= (double)facing.func_96559_d() * 0.65;
                posZ -= (double)facing.func_82599_e() * 0.4;
            }
            boolean shootOut = this.isPipeEnabled();
            float pitch = 1.0f;
            if (!shootOut) {
                pitch = 0.025f;
            }
            if (playSound && Pipes.doPipesWhoosh) {
                if (TilePipe.isTheGoodDay(this.field_145850_b)) {
                    this.field_145850_b.func_184148_a(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT_LENNY, SoundCategory.BLOCKS, 1.0f, pitch);
                } else {
                    this.field_145850_b.func_184148_a(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT, SoundCategory.BLOCKS, 1.0f, pitch);
                }
            }
            EntityItem entity = new EntityItem(this.field_145850_b, posX, posY, posZ, stack);
            entity.func_174869_p();
            double velocityMod = 0.5;
            if (!shootOut) {
                velocityMod = 0.125;
            }
            if (facing != null) {
                entity.field_70159_w = (double)(-facing.func_82601_c()) * velocityMod;
                entity.field_70181_x = (double)(-facing.func_96559_d()) * velocityMod;
                entity.field_70179_y = (double)(-facing.func_82599_e()) * velocityMod;
            }
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    public void dropAllItems() {
        for (PipeItem item : this.pipeItems) {
            this.dropItem(item.stack);
        }
        this.pipeItems.clear();
    }

    public void readSharedNBT(NBTTagCompound cmp) {
        super.readSharedNBT(cmp);
        NBTTagList pipeItemList = cmp.func_150295_c(TAG_PIPE_ITEMS, (int)cmp.func_74732_a());
        this.pipeItems.clear();
        pipeItemList.forEach(listCmp -> {
            PipeItem item = PipeItem.readFromNBT((NBTTagCompound)listCmp);
            this.pipeItems.add(item);
        });
    }

    public void writeSharedNBT(NBTTagCompound cmp) {
        super.writeSharedNBT(cmp);
        NBTTagList pipeItemList = new NBTTagList();
        for (PipeItem item : this.pipeItems) {
            NBTTagCompound listCmp = new NBTTagCompound();
            item.writeToNBT(listCmp);
            pipeItemList.func_74742_a((NBTBase)listCmp);
        }
        cmp.func_74782_a(TAG_PIPE_ITEMS, (NBTBase)pipeItemList);
    }

    protected boolean canFit(ItemStack stack, BlockPos pos, EnumFacing face) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TilePipe) {
            return ((TilePipe)tile).isPipeEnabled();
        }
        ItemStack result = this.putIntoInv(stack, tile, face, true);
        return result.func_190926_b();
    }

    protected boolean isPipeEnabled() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof BlockPipe && (Boolean)state.func_177229_b((IProperty)BlockPipe.ENABLED) != false;
    }

    protected ItemStack putIntoInv(ItemStack stack, TileEntity tile, EnumFacing face, boolean simulate) {
        IItemHandler handler = null;
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face)) {
            handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
        } else if (tile instanceof ISidedInventory) {
            handler = new SidedInvWrapper((ISidedInventory)tile, face);
        } else if (tile instanceof IInventory) {
            handler = new InvWrapper((IInventory)tile);
        }
        if (handler != null) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return index == direction.ordinal() && this.isPipeEnabled();
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        if (!itemstack.func_190926_b()) {
            EnumFacing side = EnumFacing.field_82609_l[i];
            this.passIn(itemstack, side);
            this.sync();
        }
    }

    public int func_70302_i_() {
        return 6;
    }

    protected boolean needsToSyncInventory() {
        return false;
    }

    public static class PipeItem {
        private static final String TAG_TICKS = "ticksInPipe";
        private static final String TAG_INCOMING = "incomingFace";
        private static final String TAG_OUTGOING = "outgoingFace";
        private static final String TAG_RNG_SEED = "rngSeed";
        private static final String TAG_TIME_IN_WORLD = "timeInWorld";
        private static final List<EnumFacing> HORIZONTAL_SIDES_LIST = Arrays.asList(EnumFacing.field_176754_o);
        public final ItemStack stack;
        public int ticksInPipe;
        public final EnumFacing incomingFace;
        public EnumFacing outgoingFace;
        public long rngSeed;
        public int timeInWorld = 0;
        public boolean valid = true;

        public PipeItem(ItemStack stack, EnumFacing face, long rngSeed) {
            this.stack = stack;
            this.ticksInPipe = 0;
            this.incomingFace = this.outgoingFace = face;
            this.rngSeed = rngSeed;
        }

        protected boolean tick(TilePipe pipe) {
            ++this.ticksInPipe;
            ++this.timeInWorld;
            if (!((TilePipe)pipe).field_145850_b.field_72995_K && this.ticksInPipe == Pipes.pipeSpeed / 2 - 1) {
                EnumFacing target = this.getTargetFace(pipe);
                if (this.outgoingFace != target) {
                    pipe.needsSync = true;
                }
                this.outgoingFace = target;
            }
            if (this.outgoingFace == null) {
                this.valid = false;
                return true;
            }
            return this.ticksInPipe >= Pipes.pipeSpeed;
        }

        protected EnumFacing getTargetFace(TilePipe pipe) {
            BlockPos pipePos = pipe.func_174877_v();
            if (this.incomingFace != EnumFacing.DOWN && pipe.canFit(this.stack, pipePos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP)) {
                return EnumFacing.DOWN;
            }
            EnumFacing incomingOpposite = this.incomingFace;
            if (this.incomingFace.func_176740_k() != EnumFacing.Axis.Y && pipe.canFit(this.stack, pipePos.func_177972_a(incomingOpposite = this.incomingFace.func_176734_d()), this.incomingFace)) {
                return incomingOpposite;
            }
            ArrayList<EnumFacing> sides = new ArrayList<EnumFacing>(HORIZONTAL_SIDES_LIST);
            sides.remove(this.incomingFace);
            sides.remove(incomingOpposite);
            Random rng = new Random(this.rngSeed);
            this.rngSeed = rng.nextLong();
            Collections.shuffle(sides, rng);
            for (EnumFacing side : sides) {
                if (!pipe.canFit(this.stack, pipePos.func_177972_a(side), side.func_176734_d())) continue;
                return side;
            }
            if (this.incomingFace != EnumFacing.UP && pipe.canFit(this.stack, pipePos.func_177972_a(EnumFacing.UP), EnumFacing.DOWN)) {
                return EnumFacing.UP;
            }
            return null;
        }

        public float getTimeFract(float partial) {
            return ((float)this.ticksInPipe + partial) / (float)Pipes.pipeSpeed;
        }

        public void writeToNBT(NBTTagCompound cmp) {
            this.stack.func_77955_b(cmp);
            cmp.func_74768_a(TAG_TICKS, this.ticksInPipe);
            cmp.func_74768_a(TAG_INCOMING, this.incomingFace.ordinal());
            cmp.func_74768_a(TAG_OUTGOING, this.outgoingFace.ordinal());
            cmp.func_74772_a(TAG_RNG_SEED, this.rngSeed);
            cmp.func_74768_a(TAG_TIME_IN_WORLD, this.timeInWorld);
        }

        public static PipeItem readFromNBT(NBTTagCompound cmp) {
            ItemStack stack = new ItemStack(cmp);
            EnumFacing inFace = EnumFacing.field_82609_l[cmp.func_74762_e(TAG_INCOMING)];
            long rngSeed = cmp.func_74763_f(TAG_RNG_SEED);
            PipeItem item = new PipeItem(stack, inFace, rngSeed);
            item.ticksInPipe = cmp.func_74762_e(TAG_TICKS);
            item.outgoingFace = EnumFacing.field_82609_l[cmp.func_74762_e(TAG_OUTGOING)];
            item.timeInWorld = cmp.func_74762_e(TAG_TIME_IN_WORLD);
            return item;
        }
    }
}

