/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.Feature;
import vazkii.quark.client.feature.ChestSearchBar;
import vazkii.quark.management.feature.RightClickAddToShulkerBox;

public class ShulkerBoxTooltip
extends Feature {
    public static final ResourceLocation WIDGET_RESOURCE = new ResourceLocation("quark", "textures/misc/shulker_widget.png");
    public static boolean useColors;
    public static boolean requireShift;
    public static List<ResourceLocation> shulkerBoxes;
    public static boolean dropoffAnyShulkerBox;
    private static final int[][] TARGET_RATIOS;
    private static final int CORNER = 5;
    private static final int BUFFER = 1;
    private static final int EDGE = 18;

    @Override
    public void setupConfig() {
        String[] shulkerArr = this.loadPropStringList("Shulker Boxes", "Blocks which should be interpreted as Shulker Boxes.", RightClickAddToShulkerBox.getBasicShulkerBoxes());
        shulkerBoxes = Arrays.stream(shulkerArr).map(ResourceLocation::new).collect(Collectors.toList());
        dropoffAnyShulkerBox = this.loadPropBool("Dropoff to Any Shulker Box", "Allow anything with 'shulker_box' in its item identifier to be treated as a shulker box?", true);
        useColors = this.loadPropBool("Use Colors", "", true);
        requireShift = this.loadPropBool("Needs Shift to be visible", "", false);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void makeTooltip(ItemTooltipEvent event) {
        if (RightClickAddToShulkerBox.isShulkerBox(event.getItemStack(), shulkerBoxes, dropoffAnyShulkerBox) && event.getItemStack().func_77942_o()) {
            Minecraft mc = Minecraft.func_71410_x();
            NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)event.getItemStack(), (String)"BlockEntityTag", (boolean)true);
            if (cmp != null) {
                TileEntity te;
                if (!cmp.func_150297_b("id", 8)) {
                    cmp = cmp.func_74737_b();
                    cmp.func_74778_a("id", "minecraft:shulker_box");
                }
                if ((te = TileEntity.func_190200_a((World)mc.field_71441_e, (NBTTagCompound)cmp)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    List tooltip = event.getToolTip();
                    ArrayList tooltipCopy = new ArrayList(tooltip);
                    for (int i = 1; i < tooltipCopy.size(); ++i) {
                        String s = (String)tooltipCopy.get(i);
                        if (s.startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                        tooltip.remove(s);
                    }
                    if (requireShift && !GuiScreen.func_146272_n()) {
                        tooltip.add(1, I18n.func_135052_a((String)"quarkmisc.shulkerBoxShift", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        if (RightClickAddToShulkerBox.isShulkerBox(event.getStack(), shulkerBoxes, dropoffAnyShulkerBox) && event.getStack().func_77942_o() && (!requireShift || GuiScreen.func_146272_n())) {
            Minecraft mc = Minecraft.func_71410_x();
            NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)event.getStack(), (String)"BlockEntityTag", (boolean)true);
            if (cmp != null) {
                TileEntity te;
                if (!cmp.func_150297_b("id", 8)) {
                    cmp = cmp.func_74737_b();
                    cmp.func_74778_a("id", "minecraft:shulker_box");
                }
                if ((te = TileEntity.func_190200_a((World)mc.field_71441_e, (NBTTagCompound)cmp)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    ScaledResolution res;
                    int right;
                    ItemStack currentBox = event.getStack();
                    int currentX = event.getX() - 5;
                    int currentY = event.getY() - 70;
                    IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    assert (capability != null);
                    int size = capability.getSlots();
                    int[] dims = new int[]{Math.min(size, 9), Math.max(size / 9, 1)};
                    for (int[] testAgainst : TARGET_RATIOS) {
                        if (testAgainst[0] * testAgainst[1] != size) continue;
                        dims = testAgainst;
                        break;
                    }
                    int texWidth = 10 + 18 * dims[0];
                    if (currentY < 0) {
                        currentY = event.getY() + event.getLines().size() * 10 + 5;
                    }
                    if ((right = currentX + texWidth) > (res = new ScaledResolution(mc)).func_78326_a()) {
                        currentX -= right - res.func_78326_a();
                    }
                    GlStateManager.func_179094_E();
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)700.0f);
                    mc.func_110434_K().func_110577_a(WIDGET_RESOURCE);
                    RenderHelper.func_74518_a();
                    int color = -1;
                    if (useColors) {
                        EnumDyeColor dye = ((BlockShulkerBox)((ItemBlock)currentBox.func_77973_b()).func_179223_d()).func_190956_e();
                        color = ItemDye.field_150922_c[dye.func_176767_b()];
                    }
                    ShulkerBoxTooltip.renderTooltipBackground(mc, currentX, currentY, dims[0], dims[1], color);
                    RenderItem render = mc.func_175599_af();
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179126_j();
                    for (int i = 0; i < size; ++i) {
                        ItemStack itemstack = capability.getStackInSlot(i);
                        int xp = currentX + 6 + i % 9 * 18;
                        int yp = currentY + 6 + i / 9 * 18;
                        if (!itemstack.func_190926_b()) {
                            render.func_180450_b(itemstack, xp, yp);
                            render.func_175030_a(mc.field_71466_p, itemstack, xp, yp);
                        }
                        if (ChestSearchBar.namesMatch(itemstack, ChestSearchBar.text)) continue;
                        GlStateManager.func_179097_i();
                        Gui.func_73734_a((int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)-1442840576);
                    }
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179101_C();
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    public static void renderTooltipBackground(Minecraft mc, int x, int y, int width, int height, int color) {
        mc.func_110434_K().func_110577_a(WIDGET_RESOURCE);
        GlStateManager.func_179124_c((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        RenderHelper.func_74518_a();
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)5, (int)5, (float)256.0f, (float)256.0f);
        Gui.func_146110_a((int)(x + 5 + 18 * width), (int)(y + 5 + 18 * height), (float)25.0f, (float)25.0f, (int)5, (int)5, (float)256.0f, (float)256.0f);
        Gui.func_146110_a((int)(x + 5 + 18 * width), (int)y, (float)25.0f, (float)0.0f, (int)5, (int)5, (float)256.0f, (float)256.0f);
        Gui.func_146110_a((int)x, (int)(y + 5 + 18 * height), (float)0.0f, (float)25.0f, (int)5, (int)5, (float)256.0f, (float)256.0f);
        for (int row = 0; row < height; ++row) {
            Gui.func_146110_a((int)x, (int)(y + 5 + 18 * row), (float)0.0f, (float)6.0f, (int)5, (int)18, (float)256.0f, (float)256.0f);
            Gui.func_146110_a((int)(x + 5 + 18 * width), (int)(y + 5 + 18 * row), (float)25.0f, (float)6.0f, (int)5, (int)18, (float)256.0f, (float)256.0f);
            for (int col = 0; col < width; ++col) {
                if (row == 0) {
                    Gui.func_146110_a((int)(x + 5 + 18 * col), (int)y, (float)6.0f, (float)0.0f, (int)18, (int)5, (float)256.0f, (float)256.0f);
                    Gui.func_146110_a((int)(x + 5 + 18 * col), (int)(y + 5 + 18 * height), (float)6.0f, (float)25.0f, (int)18, (int)5, (float)256.0f, (float)256.0f);
                }
                Gui.func_146110_a((int)(x + 5 + 18 * col), (int)(y + 5 + 18 * row), (float)6.0f, (float)6.0f, (int)18, (int)18, (float)256.0f, (float)256.0f);
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    static {
        TARGET_RATIOS = new int[][]{{1, 1}, {9, 3}, {9, 5}, {9, 6}, {9, 8}, {9, 9}, {12, 9}};
    }
}

