/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.potion;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.potion.effect.PotionBase;
import com.lothrazar.cyclicmagic.potion.effect.PotionBounce;
import com.lothrazar.cyclicmagic.potion.effect.PotionDropItems;
import com.lothrazar.cyclicmagic.potion.effect.PotionEnder;
import com.lothrazar.cyclicmagic.potion.effect.PotionFrostWalker;
import com.lothrazar.cyclicmagic.potion.effect.PotionMagnet;
import com.lothrazar.cyclicmagic.potion.effect.PotionSlowfall;
import com.lothrazar.cyclicmagic.potion.effect.PotionSnow;
import com.lothrazar.cyclicmagic.potion.effect.PotionStunned;
import com.lothrazar.cyclicmagic.potion.effect.PotionSwimSpeed;
import com.lothrazar.cyclicmagic.potion.effect.PotionWaterwalk;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.util.ArrayList;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionEffectRegistry {
    public static ArrayList<Potion> potions = new ArrayList();
    public static final PotionBase SLOWFALL = new PotionSlowfall();
    public static final PotionBase MAGNET = new PotionMagnet();
    public static final PotionBase ENDER = new PotionEnder();
    public static final PotionBase WATERWALK = new PotionWaterwalk();
    public static final PotionBase SNOW = new PotionSnow();
    public static final PotionBase SWIMSPEED = new PotionSwimSpeed();
    public static final PotionBase BOUNCE = new PotionBounce();
    public static final PotionBase FROSTW = new PotionFrostWalker();
    public static final PotionBase DROPS = new PotionDropItems();
    public static final PotionBase STUN = new PotionStunned();
    public static ArrayList<PotionBase> potionEffects = new ArrayList();

    private static void register() {
        PotionEffectRegistry.registerPotionEffect(MAGNET);
        PotionEffectRegistry.registerPotionEffect(ENDER);
        PotionEffectRegistry.registerPotionEffect(WATERWALK);
        PotionEffectRegistry.registerPotionEffect(SLOWFALL);
        PotionEffectRegistry.registerPotionEffect(SNOW);
        PotionEffectRegistry.registerPotionEffect(SWIMSPEED);
        PotionEffectRegistry.registerPotionEffect(BOUNCE);
        PotionEffectRegistry.registerPotionEffect(FROSTW);
        PotionEffectRegistry.registerPotionEffect(DROPS);
        PotionEffectRegistry.registerPotionEffect(STUN);
    }

    private static void registerPotionEffect(PotionBase effect) {
        effect.setIcon(effect.getIcon());
        effect.setRegistryName(new ResourceLocation("cyclicmagic", effect.func_76393_a()));
        potions.add(effect);
        potionEffects.add(effect);
        ModCyclic.instance.events.register((Object)effect);
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegistryEvent.Register<Potion> event) {
        PotionEffectRegistry.register();
        for (Potion b : potions) {
            event.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    public static String getStrForLevel(int lvl) {
        return UtilChat.lang("enchantment.level." + lvl);
    }

    public static enum PotionSize {
        NORMAL,
        POWERED,
        LONG;

    }
}

