/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.net.PacketMoveBlock;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPistonWand
extends BaseTool
implements IHasRecipe,
IContent {
    private static final int durability = 5000;
    private boolean enabled;

    public ItemPistonWand() {
        super(5000);
    }

    @Override
    public String getContentName() {
        return "tool_push";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName());
        ModCyclic.instance.events.register(this);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("PistonScepter", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.tool_mode, SoundCategory.PLAYERS);
            if (!player.func_130014_f_().field_72995_K) {
                ActionType.toggle(held);
                UtilChat.sendStatusMessage(player, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldObj, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState placeState;
        ItemStack stack = player.func_184586_b(hand);
        if (worldObj.field_72995_K) {
            ActionType action = ActionType.values()[ActionType.get(stack)];
            ModCyclic.network.sendToServer((IMessage)new PacketMoveBlock(pos, action, side));
        }
        if ((placeState = worldObj.func_180495_p(pos)).func_177230_c() != null) {
            UtilSound.playSoundPlaceBlock(player, pos, placeState.func_177230_c());
        }
        this.onUse(stack, player, worldObj, hand);
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gp", " bg", "b  ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), "gemQuartz", Character.valueOf('p'), Blocks.field_150320_F);
    }

    public static enum ActionType {
        PUSH,
        PULL,
        ROTATE;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static int get(ItemStack wand) {
            if (wand == null) {
                return 0;
            }
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            return tags.func_74762_e(NBT);
        }

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "tool.action." + ActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "tool.action." + PUSH.toString().toLowerCase();
            }
        }

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            if (++type > ROTATE.ordinal()) {
                type = PUSH.ordinal();
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }
    }
}

