/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.sorting;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.ITileStackWrapper;
import com.lothrazar.cyclicmagic.data.StackWrapper;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityItemCableSort
extends TileEntityBaseMachineInvo
implements ITileStackWrapper,
ITickable {
    private NonNullList<StackWrapper> stacksWrapped = NonNullList.func_191197_a((int)(8 * EnumFacing.values().length), (Object)new StackWrapper());
    public static final int FILTER_SIZE = 8;
    private static final int TICKS_TEXT_CACHED = 7;
    private static final int TIMER_SIDE_INPUT = 15;
    private Map<EnumFacing, Integer> mapIncoming = Maps.newHashMap();
    private Map<EnumFacing, Integer> allowEverything = Maps.newHashMap();
    private Map<EnumFacing, Integer> ignoreDamageIfOne = Maps.newHashMap();
    private BlockPos connectedInventory;
    private int labelTimer = 0;
    private String labelText = "";

    public TileEntityItemCableSort() {
        super(1);
        this.setSlotsForInsert(0);
        for (EnumFacing f : EnumFacing.values()) {
            this.mapIncoming.put(f, 0);
            this.allowEverything.put(f, 0);
            this.ignoreDamageIfOne.put(f, 0);
        }
    }

    public LockType getLockType(EnumFacing f) {
        return LockType.values()[this.allowEverything.get(f)];
    }

    private List<ItemStack> getFilterForSide(EnumFacing f) {
        int row = f.ordinal();
        int start = row * 8;
        int end = (row + 1) * 8;
        ArrayList<ItemStack> validForSide = new ArrayList<ItemStack>();
        for (int i = start; i < end; ++i) {
            if (((StackWrapper)this.stacksWrapped.get(i)).isEmpty()) continue;
            validForSide.add(((StackWrapper)this.stacksWrapped.get(i)).getStack());
        }
        return validForSide;
    }

    public String getLabelText() {
        return this.labelText;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readStackWrappers(this.stacksWrapped, compound);
        for (EnumFacing f : EnumFacing.values()) {
            this.mapIncoming.put(f, compound.func_74762_e(f.func_176610_l() + "_incoming"));
            this.allowEverything.put(f, compound.func_74762_e(f.func_176610_l() + "_toggle"));
            this.ignoreDamageIfOne.put(f, compound.func_74762_e(f.func_176610_l() + "_damage"));
        }
        this.labelText = compound.func_74779_i("label");
        this.labelTimer = compound.func_74762_e("labelt");
        this.connectedInventory = (BlockPos)new Gson().fromJson(compound.func_74779_i("connectedInventory"), new TypeToken<BlockPos>(){}.getType());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeStackWrappers(this.stacksWrapped, compound);
        for (EnumFacing f : EnumFacing.values()) {
            compound.func_74768_a(f.func_176610_l() + "_incoming", this.mapIncoming.get(f).intValue());
            compound.func_74768_a(f.func_176610_l() + "_toggle", this.allowEverything.get(f).intValue());
            compound.func_74768_a(f.func_176610_l() + "_damage", this.ignoreDamageIfOne.get(f).intValue());
        }
        compound.func_74778_a("label", this.labelText);
        compound.func_74768_a("labelt", this.labelTimer);
        return super.func_189515_b(compound);
    }

    public BlockPos getConnectedPos() {
        return this.connectedInventory;
    }

    public void setConnectedPos(BlockPos connectedInventory) {
        this.connectedInventory = connectedInventory;
    }

    public void updateIncomingFace(EnumFacing inputFrom) {
        this.mapIncoming.put(inputFrom, 15);
    }

    private boolean isIncomingFromFace(EnumFacing face) {
        return this.mapIncoming.get(face) > 0;
    }

    private List<EnumFacing> getValidSidesForStack(ItemStack stackToExport) {
        ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>();
        block0: for (EnumFacing f : EnumFacing.values()) {
            if (this.isIncomingFromFace(f) || this.getLockType(f) != LockType.FILTER) continue;
            List<ItemStack> inventoryContents = this.getFilterForSide(f);
            if (this.ignoreDamageIfOne.get(f) == 1) {
                for (ItemStack inFilter : inventoryContents) {
                    if (!inFilter.func_77973_b().equals(stackToExport.func_77973_b())) continue;
                    faces.add(f);
                    continue block0;
                }
                continue;
            }
            if (!OreDictionary.containsMatch((boolean)true, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])inventoryContents.toArray(new ItemStack[0])), (ItemStack[])new ItemStack[]{stackToExport})) continue;
            faces.add(f);
        }
        return faces;
    }

    private List<EnumFacing> getEverythingSides(ItemStack stackToExport) {
        ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>();
        for (EnumFacing f : EnumFacing.values()) {
            if (this.getLockType(f) != LockType.EVERYTHING) continue;
            faces.add(f);
        }
        return faces;
    }

    public void func_73660_a() {
        this.tickLabelText();
        this.tickDownIncomingFaces();
        ItemStack stackToExport = this.func_70301_a(0).func_77946_l();
        if (stackToExport.func_190926_b()) {
            return;
        }
        List<EnumFacing> targetFaces = this.getValidSidesForStack(stackToExport);
        if (targetFaces.size() > 0) {
            Collections.shuffle(targetFaces);
            this.tryExportToTheseFaces(targetFaces);
        } else {
            targetFaces = this.getEverythingSides(stackToExport);
            Collections.shuffle(targetFaces);
            this.tryExportToTheseFaces(targetFaces);
        }
    }

    public void tryExportToTheseFaces(List<EnumFacing> targetFaces) {
        for (EnumFacing f : targetFaces) {
            TileEntityBaseMachineInvo cable;
            BlockPos posTarget;
            TileEntity tileTarget;
            ItemStack stackToExport = this.func_70301_a(0).func_77946_l();
            if (stackToExport.func_190926_b()) {
                return;
            }
            if (this.isIncomingFromFace(f) || (tileTarget = this.field_145850_b.func_175625_s(posTarget = this.field_174879_c.func_177972_a(f))) == null) continue;
            boolean outputSuccess = false;
            ItemStack leftAfterDeposit = UtilItemStack.tryDepositToHandler(this.field_145850_b, posTarget, f.func_176734_d(), stackToExport);
            if (leftAfterDeposit.func_190916_E() < stackToExport.func_190916_E()) {
                this.func_70299_a(0, leftAfterDeposit);
                outputSuccess = true;
            }
            if (outputSuccess && this.field_145850_b.func_175625_s(posTarget) instanceof TileEntityItemCableSort) {
                cable = (TileEntityItemCableSort)this.field_145850_b.func_175625_s(posTarget);
                ((TileEntityItemCableSort)cable).updateIncomingFace(f.func_176734_d());
            }
            if (!outputSuccess || !(this.field_145850_b.func_175625_s(posTarget) instanceof TileEntityCableBase) || !((TileEntityCableBase)(cable = (TileEntityCableBase)this.field_145850_b.func_175625_s(posTarget))).isItemPipe()) continue;
            ((TileEntityCableBase)cable).updateIncomingItemFace(f.func_176734_d());
        }
    }

    private void tickLabelText() {
        --this.labelTimer;
        if (this.labelTimer <= 0) {
            this.labelTimer = 0;
            this.labelText = "";
            if (!this.func_70301_a(0).func_190926_b()) {
                this.labelText = this.func_70301_a(0).func_82833_r();
                this.labelTimer = 7;
            }
        }
    }

    public boolean hasAnyIncomingFaces() {
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncoming.get(f) <= 0) continue;
            return true;
        }
        return false;
    }

    public void tickDownIncomingFaces() {
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncoming.get(f) <= 0) continue;
            this.mapIncoming.put(f, this.mapIncoming.get(f) - 1);
        }
    }

    public String getIncomingStrings() {
        String in = "";
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncoming.get(f) <= 0) continue;
            in = in + f.name().toLowerCase() + " ";
        }
        return in.trim();
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(this.func_174890_g());
    }

    @Override
    public int func_174890_g() {
        return EnumFacing.values().length * 2;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id < EnumFacing.values().length) {
            EnumFacing enumID = EnumFacing.values()[id];
            return this.allowEverything.get(enumID);
        }
        EnumFacing enumID = EnumFacing.values()[id % EnumFacing.values().length];
        return this.ignoreDamageIfOne.get(enumID);
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id < EnumFacing.values().length) {
            EnumFacing enumID = EnumFacing.values()[id];
            this.allowEverything.put(enumID, value % LockType.values().length);
        } else {
            EnumFacing enumID = EnumFacing.values()[id % EnumFacing.values().length];
            this.ignoreDamageIfOne.put(enumID, value % 2);
        }
    }

    @Override
    public StackWrapper getStackWrapper(int i) {
        return (StackWrapper)this.stacksWrapped.get(i);
    }

    @Override
    public void setStackWrapper(int i, StackWrapper stack) {
        this.stacksWrapped.set(i, (Object)stack);
    }

    @Override
    public int getWrapperCount() {
        return this.stacksWrapped.size();
    }

    public static enum LockType {
        FILTER,
        EVERYTHING,
        NOTHING;


        public String nameLower() {
            return UtilChat.lang("tile.item_pipe_sort." + this.name().toLowerCase());
        }
    }
}

