/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.controlledminer;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.controlledminer.BlockMinerSmart;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.data.ITileStackWrapper;
import com.lothrazar.cyclicmagic.data.StackWrapper;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityControlledMiner
extends TileEntityBaseMachineInvo
implements ITileStackWrapper,
ITileRedstoneToggle,
ITilePreviewToggle,
ITickable {
    private static final String NBTMINING = "mining";
    private static final String NBTDAMAGE = "curBlockDamage";
    private static final String NBTPLAYERID = "uuid";
    private static final String NBTTARGET = "target";
    private static final String NBTHEIGHT = "h";
    private static final String NBT_LIST = "blacklistIfZero";
    private static final int MAX_SIZE = 9;
    public static final int TOOLSLOT_INDEX = 0;
    public static int TIMER_FULL = 100;
    public static int maxHeight = 10;
    private boolean isCurrentlyMining;
    private float curBlockDamage;
    private BlockPos targetPos = null;
    private int size = 4;
    private int height = 6;
    private int blacklistIfZero = 0;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;
    private NonNullList<StackWrapper> stacksWrapped = NonNullList.func_191197_a((int)4, (Object)new StackWrapper());

    public TileEntityControlledMiner() {
        super(1);
        this.initEnergy(new EnergyStore(64000), BlockMinerSmart.FUEL_COST);
        this.setSlotsForInsert(Arrays.asList(0));
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    private void verifyFakePlayer(WorldServer w) {
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer(w, this.uuid, "block_miner_smart");
            if (this.fakePlayer == null) {
                ModCyclic.logger.error("Fake player failed to init ");
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public void func_73660_a() {
        if (this.field_145850_b instanceof WorldServer) {
            this.verifyUuid(this.field_145850_b);
            this.verifyFakePlayer((WorldServer)this.field_145850_b);
            this.tryEquipItem();
            if (this.targetPos == null) {
                this.targetPos = this.field_174879_c.func_177972_a(this.getCurrentFacing());
            }
            if (this.isRunning()) {
                if (!this.updateEnergyIsBurning()) {
                    return;
                }
                if (this.updateMiningProgress()) {
                    this.timer = TIMER_FULL;
                }
            } else if (this.isCurrentlyMining) {
                this.isCurrentlyMining = false;
                this.resetProgress(this.targetPos);
            }
        }
    }

    private boolean updateMiningProgress() {
        if (!this.isCurrentlyMining) {
            this.updateTargetPos();
        }
        if (this.isTargetValid()) {
            this.isCurrentlyMining = true;
        } else {
            this.isCurrentlyMining = false;
            this.updateTargetPos();
            this.resetProgress(this.targetPos);
        }
        if (this.isCurrentlyMining) {
            IBlockState targetState = this.field_145850_b.func_180495_p(this.targetPos);
            this.curBlockDamage += UtilItemStack.getPlayerRelativeBlockHardness(targetState.func_177230_c(), targetState, (EntityPlayer)this.fakePlayer.get(), this.field_145850_b, this.targetPos);
            if (this.curBlockDamage >= 1.0f) {
                this.isCurrentlyMining = false;
                this.resetProgress(this.targetPos);
                if (this.fakePlayer.get() != null) {
                    return ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_180237_b(this.targetPos);
                }
            } else {
                this.field_145850_b.func_175715_c(this.uuid.hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
            }
        }
        return false;
    }

    private void tryEquipItem() {
        ItemStack equip = this.func_70301_a(0);
        if (equip.func_190916_E() == 0) {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
        if (equip.func_190926_b()) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        } else if (!equip.equals(((FakePlayer)this.fakePlayer.get()).func_184586_b(EnumHand.MAIN_HAND))) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, equip);
        }
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private boolean isTargetValid() {
        World world = this.func_145831_w();
        if (world.func_175623_d(this.targetPos) || world.func_180495_p(this.targetPos) == null) {
            return false;
        }
        IBlockState targetState = world.func_180495_p(this.targetPos);
        Block target = targetState.func_177230_c();
        if (this.blacklistIfZero == 0) {
            for (StackWrapper wrap : this.stacksWrapped) {
                ItemStack itemStack;
                if (wrap.isEmpty() || (itemStack = wrap.getStack().func_77946_l()).func_77973_b() != Item.func_150898_a((Block)target)) continue;
                return false;
            }
            return true;
        }
        int countEmpty = 0;
        for (StackWrapper wrap : this.stacksWrapped) {
            if (wrap.isEmpty()) {
                ++countEmpty;
                continue;
            }
            ItemStack itemStack = wrap.getStack().func_77946_l();
            if (itemStack.func_77973_b() != Item.func_150898_a((Block)target) && Block.func_149634_a((Item)itemStack.func_77973_b()) != target && !((ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b())).toString().equals(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)target)).toString())) continue;
            return true;
        }
        return this.getWrapperCount() == countEmpty;
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1);
    }

    private void updateTargetPos() {
        BlockPos center;
        this.targetPos = center = this.getTargetCenter();
        if (this.height == 0) {
            this.height = 6;
        }
        World world = this.func_145831_w();
        int rollHeight = world.field_73012_v.nextInt(this.height);
        if (rollHeight > 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.UP, rollHeight);
        }
        int randNS = world.field_73012_v.nextInt(this.size * 2 + 1) - this.size;
        int randEW = world.field_73012_v.nextInt(this.size * 2 + 1) - this.size;
        if (randNS > 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.NORTH, randNS);
        } else if (randNS < 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.SOUTH, -1 * randNS);
        }
        if (randEW > 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.EAST, randEW);
        } else if (randEW < 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.WEST, -1 * randEW);
        }
        this.curBlockDamage = 0.0f;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        this.writeStackWrappers(this.stacksWrapped, tags);
        tags.func_74768_a("redstone", this.needsRedstone);
        if (this.uuid != null) {
            tags.func_74778_a(NBTPLAYERID, this.uuid.toString());
        }
        if (this.targetPos != null) {
            tags.func_74783_a(NBTTARGET, new int[]{this.targetPos.func_177958_n(), this.targetPos.func_177956_o(), this.targetPos.func_177952_p()});
        }
        tags.func_74757_a(NBTMINING, this.isCurrentlyMining);
        tags.func_74776_a(NBTDAMAGE, this.curBlockDamage);
        tags.func_74768_a(NBTHEIGHT, this.height);
        tags.func_74768_a("size", this.size);
        tags.func_74768_a(NBT_LIST, this.blacklistIfZero);
        tags.func_74768_a("render", this.renderParticles);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        int[] coords;
        super.func_145839_a(tags);
        this.readStackWrappers(this.stacksWrapped, tags);
        this.needsRedstone = tags.func_74762_e("redstone");
        this.size = tags.func_74762_e("size");
        if (tags.func_74764_b(NBTPLAYERID)) {
            this.uuid = UUID.fromString(tags.func_74779_i(NBTPLAYERID));
        }
        if (tags.func_74764_b(NBTTARGET) && (coords = tags.func_74759_k(NBTTARGET)).length >= 3) {
            this.targetPos = new BlockPos(coords[0], coords[1], coords[2]);
        }
        this.isCurrentlyMining = tags.func_74767_n(NBTMINING);
        this.curBlockDamage = tags.func_74760_g(NBTDAMAGE);
        this.height = tags.func_74762_e(NBTHEIGHT);
        this.blacklistIfZero = tags.func_74762_e(NBT_LIST);
        this.renderParticles = tags.func_74762_e("render");
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isCurrentlyMining && this.uuid != null) {
            this.resetProgress(pos);
        }
    }

    private void resetProgress(BlockPos targetPos) {
        if (this.uuid != null) {
            this.func_145831_w().func_175715_c(this.uuid.hashCode(), targetPos, -1);
            this.curBlockDamage = 0.0f;
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case HEIGHT: {
                return this.getHeight();
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SIZE: {
                return this.size;
            }
            case LISTTYPE: {
                return this.blacklistIfZero;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case HEIGHT: {
                if (value > maxHeight) {
                    value = maxHeight;
                }
                this.setHeight(value);
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case SIZE: {
                if (value > 9) {
                    value = 0;
                }
                if (value < 0) {
                    value = 9;
                }
                this.size = value;
                break;
            }
            case LISTTYPE: {
                this.blacklistIfZero = value % 2;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
            }
        }
    }

    public void toggleListType() {
        this.blacklistIfZero = (this.blacklistIfZero + 1) % 2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int val) {
        this.height = val;
    }

    @Override
    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public List<BlockPos> getShape() {
        ArrayList<BlockPos> allPos = new ArrayList<BlockPos>();
        for (int i = 0; i < this.getHeight(); ++i) {
            allPos.addAll(UtilShape.squareHorizontalHollow(this.getTargetCenter().func_177981_b(i), this.size));
        }
        return allPos;
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    @Override
    public StackWrapper getStackWrapper(int i) {
        return (StackWrapper)this.stacksWrapped.get(i);
    }

    @Override
    public void setStackWrapper(int i, StackWrapper stack) {
        this.stacksWrapped.set(i, (Object)stack);
    }

    @Override
    public int getWrapperCount() {
        return this.stacksWrapped.size();
    }

    public static enum Fields {
        HEIGHT,
        REDSTONE,
        SIZE,
        LISTTYPE,
        RENDERPARTICLES;

    }
}

