/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.buildplacer;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class TileEntityPlacer
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    private static final int buildSpeed = 1;
    public static final int TIMER_FULL = 1;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;

    public TileEntityPlacer() {
        super(9);
        this.setSlotsForBoth();
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        return super.func_189515_b(tagCompound);
    }

    public boolean isFuelBurning() {
        return this.timer > 0 && this.timer < 1;
    }

    private void verifyFakePlayer(WorldServer w) {
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer(w, this.uuid, this.func_145838_q().func_149739_a());
            if (this.fakePlayer == null) {
                ModCyclic.logger.error("Fake player failed to init ");
            }
        }
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
    }

    public void func_73660_a() {
        ItemStack stack;
        this.shiftAllUp();
        boolean trigger = false;
        if (!this.isRunning()) {
            this.func_70296_d();
            return;
        }
        if (this.field_145850_b instanceof WorldServer) {
            this.verifyUuid(this.field_145850_b);
            this.verifyFakePlayer((WorldServer)this.field_145850_b);
        }
        if ((stack = this.func_70301_a(0)) == null) {
            this.timer = 1;
        } else {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 1;
                trigger = true;
            }
        }
        if (trigger) {
            if (stack.func_77973_b() instanceof ItemBlock && this.fakePlayer != null) {
                UtilEntity.setEntityFacing((EntityLivingBase)this.fakePlayer.get(), this.getCurrentFacing());
                try {
                    UtilPlaceBlocks.placeItemblock(this.field_145850_b, this.field_174879_c.func_177972_a(this.getCurrentFacing()), stack, (EntityPlayer)this.fakePlayer.get());
                }
                catch (Throwable e) {
                    ModCyclic.logger.error("Block could be not be placed : " + stack.func_77973_b().getRegistryName(), e);
                }
            } else {
                Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
                if (stuff != null && stuff != Blocks.field_150350_a && UtilPlaceBlocks.placeStateSafe(this.func_145831_w(), null, this.field_174879_c.func_177972_a(this.getCurrentFacing()), UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j()))) {
                    this.func_70298_a(0, 1);
                }
            }
        }
        this.func_70296_d();
    }

    @Override
    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE;

    }
}

