/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.buildershape;

import com.lothrazar.cyclicmagic.block.buildershape.ContainerBuilder;
import com.lothrazar.cyclicmagic.block.buildershape.TileEntityStructureBuilder;
import com.lothrazar.cyclicmagic.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.gui.button.ButtonTileEntityField;
import com.lothrazar.cyclicmagic.gui.button.ButtonTriggerWrapper;
import com.lothrazar.cyclicmagic.gui.component.EnergyBar;
import com.lothrazar.cyclicmagic.gui.component.GuiSliderInteger;
import com.lothrazar.cyclicmagic.util.Const;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.io.IOException;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class GuiBuilder
extends GuiBaseContainer {
    private TileEntityStructureBuilder tile;
    private ButtonTileEntityField btnSizeUp;
    private ButtonTileEntityField btnSizeDown;
    private ButtonTileEntityField btnHeightUp;
    private ButtonTileEntityField btnHeightDown;
    private static final int yRowTextbox = 50;
    private int xControlsStart = 158;
    private static final int xControlsSpacing = 14;
    private int yOffset = 18;
    private GuiSliderInteger sliderX;
    private GuiSliderInteger sliderY;
    private GuiSliderInteger sliderZ;

    public GuiBuilder(InventoryPlayer inventoryPlayer, TileEntityStructureBuilder tileEntity) {
        super(new ContainerBuilder(inventoryPlayer, tileEntity), tileEntity);
        this.tile = tileEntity;
        this.setScreenSize(Const.ScreenSize.LARGE);
        this.fieldRedstoneBtn = TileEntityStructureBuilder.Fields.REDSTONE.ordinal();
        this.fieldPreviewBtn = TileEntityStructureBuilder.Fields.RENDERPARTICLES.ordinal();
        this.energyBar = new EnergyBar(this);
        this.energyBar.setWidth(10).setY(4).setX(160).setHeight(42);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int id = 1;
        int maxOffset = 16;
        int width = 102;
        int h = 10;
        int x = this.field_147003_i + 24;
        int y = this.field_147009_r + 15;
        this.sliderX = new GuiSliderInteger(this.tile, id, x, y, width, h, -1 * maxOffset, maxOffset, TileEntityStructureBuilder.Fields.OX.ordinal());
        this.sliderX.setTooltip("X");
        this.func_189646_b(this.sliderX);
        this.sliderY = new GuiSliderInteger(this.tile, ++id, x, y += h + 1, width, h, -1 * maxOffset, maxOffset, TileEntityStructureBuilder.Fields.OY.ordinal());
        this.sliderY.setTooltip("Y");
        this.func_189646_b(this.sliderY);
        this.sliderZ = new GuiSliderInteger(this.tile, ++id, x, y += h + 1, width, h, -1 * maxOffset, maxOffset, TileEntityStructureBuilder.Fields.OZ.ordinal());
        this.sliderZ.setTooltip("Z");
        this.func_189646_b(this.sliderZ);
        ++id;
        x = this.field_147003_i + 8 + h;
        y = this.field_147009_r + this.yOffset + 8;
        h = width = 18;
        x = this.field_147003_i + 4;
        y = this.field_147009_r + 50;
        TileEntityStructureBuilder.Fields fld = TileEntityStructureBuilder.Fields.BUILDTYPE;
        int numInRow = 0;
        for (TileEntityStructureBuilder.BuildType shape : TileEntityStructureBuilder.BuildType.values()) {
            if (++numInRow == 7) {
                x = this.field_147003_i + 4;
                y += h + 4;
            }
            ButtonTileEntityField btnShape = new ButtonTileEntityField(id++, x, y, this.tile.func_174877_v(), fld.ordinal(), shape.ordinal(), width, h);
            String n = UtilChat.lang("buildertype." + shape.name().toLowerCase() + ".name");
            this.func_189646_b(btnShape).setTooltip((String)n).field_146126_j = shape.shortcode();
            btnShape.buttonMode = ButtonTileEntityField.ButtonMode.SET;
            x += width + 2;
            this.registerButtonDisableTrigger((GuiButton)btnShape, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, fld.ordinal(), shape.ordinal());
        }
        h = width = 12;
        int yTopRow = this.field_147009_r + 50;
        int yBottomRow = this.field_147009_r + 50 + this.yOffset + 8;
        fld = TileEntityStructureBuilder.Fields.SIZE;
        x = this.field_147003_i + this.xControlsStart;
        this.btnSizeUp = new ButtonTileEntityField(id++, x, yTopRow, this.tile.func_174877_v(), fld.ordinal(), 1, width, h);
        this.btnSizeUp.setTooltip("button." + fld.name().toLowerCase() + ".up");
        this.btnSizeUp.field_146126_j = "+";
        this.func_189646_b(this.btnSizeUp);
        this.registerButtonDisableTrigger((GuiButton)this.btnSizeUp, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, fld.ordinal(), TileEntityStructureBuilder.maxSize);
        this.btnSizeDown = new ButtonTileEntityField(id++, x, yBottomRow, this.tile.func_174877_v(), fld.ordinal(), -1, width, h);
        this.btnSizeDown.setTooltip("button." + fld.name().toLowerCase() + ".down");
        this.btnSizeDown.field_146126_j = "-";
        this.func_189646_b(this.btnSizeDown);
        this.registerButtonDisableTrigger((GuiButton)this.btnSizeDown, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, fld.ordinal(), 1);
        fld = TileEntityStructureBuilder.Fields.HEIGHT;
        x = this.field_147003_i + this.xControlsStart - 14;
        this.btnHeightUp = new ButtonTileEntityField(id++, x, yTopRow, this.tile.func_174877_v(), fld.ordinal(), 1, width, h);
        this.btnHeightUp.setTooltip("button." + fld.name().toLowerCase() + ".up");
        this.btnHeightUp.field_146126_j = "+";
        this.func_189646_b(this.btnHeightUp);
        this.registerButtonDisableTrigger((GuiButton)this.btnHeightUp, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, fld.ordinal(), TileEntityStructureBuilder.maxHeight);
        this.btnHeightDown = new ButtonTileEntityField(id++, x, yBottomRow, this.tile.func_174877_v(), fld.ordinal(), -1, width, h);
        this.btnHeightDown.setTooltip("button." + fld.name().toLowerCase() + ".down");
        this.btnHeightDown.field_146126_j = "-";
        this.func_189646_b(this.btnHeightDown);
        this.registerButtonDisableTrigger((GuiButton)this.btnHeightDown, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, fld.ordinal(), 1);
        fld = TileEntityStructureBuilder.Fields.ROTATIONS;
        x = this.field_147003_i + this.xControlsStart - 28;
        ButtonTileEntityField btnRotUp = new ButtonTileEntityField(id++, x, yTopRow, this.tile.func_174877_v(), fld.ordinal(), 1, width, h);
        btnRotUp.setTooltip("button." + fld.name().toLowerCase() + ".up");
        btnRotUp.field_146126_j = "+";
        this.func_189646_b(btnRotUp);
        ButtonTileEntityField btnRotDown = new ButtonTileEntityField(id++, x, yBottomRow, this.tile.func_174877_v(), fld.ordinal(), -1, width, h);
        btnRotDown.setTooltip("button." + fld.name().toLowerCase() + ".down");
        btnRotDown.field_146126_j = "-";
        this.func_189646_b(btnRotDown);
        this.registerButtonDisableTrigger((GuiButton)btnRotDown, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, fld.ordinal(), 0);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.sliderX.keyTyped(typedChar, keyCode);
        this.sliderY.keyTyped(typedChar, keyCode);
        this.sliderZ.keyTyped(typedChar, keyCode);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.sliderX.updateScreen();
        this.sliderY.updateScreen();
        this.sliderZ.updateScreen();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        String display;
        super.func_146979_b(mouseX, mouseY);
        String label = UtilChat.lang("buildertype." + this.tile.getBuildTypeEnum().name().toLowerCase() + ".name");
        this.drawString(label, 66, 76);
        int sp = 4;
        int x = this.xControlsStart + sp;
        int y = 50 + this.yOffset - sp;
        if (this.tile.getSize() > 0) {
            display = "" + this.tile.getSize();
            this.drawStringCenteredCheckLength(display, x, y);
        }
        x = this.xControlsStart - 14 + sp;
        if (this.tile.getHeight() > 0 && this.tile.getBuildTypeEnum().hasHeight()) {
            display = "" + this.tile.getHeight();
            this.drawStringCenteredCheckLength(display, x, y);
        }
        x = this.xControlsStart - 28 + sp;
        display = "" + this.tile.func_174887_a_(TileEntityStructureBuilder.Fields.ROTATIONS.ordinal());
        this.drawStringCenteredCheckLength(display, x, y);
        this.updateDisabledButtons();
    }

    private void updateDisabledButtons() {
        if (this.btnHeightDown != null) {
            this.btnHeightDown.field_146125_m = this.tile.getBuildTypeEnum().hasHeight();
        }
        if (this.btnHeightUp != null) {
            this.btnHeightUp.field_146125_m = this.tile.getBuildTypeEnum().hasHeight();
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        boolean u = false;
        boolean v = false;
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT);
        for (int k = 0; k < this.tile.func_70302_i_(); ++k) {
            Gui.func_146110_a((int)(this.field_147003_i + 8 - 1 + k * 18), (int)(this.field_147009_r + 94 - 1), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
    }
}

