/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.tiles;

import com.zeitheron.hammercore.net.props.IPropertyChangeHandler;
import com.zeitheron.hammercore.net.props.NetPropertyItemStack;
import com.zeitheron.hammercore.net.props.NetPropertyString;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.EnumRotation;
import com.zeitheron.thaumicadditions.api.seals.SealCombination;
import com.zeitheron.thaumicadditions.api.seals.SealInstance;
import com.zeitheron.thaumicadditions.api.seals.SealManager;
import com.zeitheron.thaumicadditions.init.BlocksTAR;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;

public class TileSeal
extends TileSyncableTickable
implements ITileDroppable {
    public final NetPropertyItemStack stack;
    private final NetPropertyString[] slots = new NetPropertyString[3];
    public EnumFacing orientation;
    public SealCombination combination;
    public SealInstance instance;
    public NBTTagCompound optInstNBT;
    public NetPropertyString placer;
    public boolean dirty = false;

    public TileSeal() {
        this.stack = new NetPropertyItemStack((IPropertyChangeHandler)this, ItemStack.field_190927_a);
        this.slots[0] = new NetPropertyString((IPropertyChangeHandler)this, null);
        this.slots[1] = new NetPropertyString((IPropertyChangeHandler)this, null);
        this.slots[2] = new NetPropertyString((IPropertyChangeHandler)this, null);
        this.placer = new NetPropertyString((IPropertyChangeHandler)this);
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            EntityItem ent = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.stack.get().func_77946_l());
            double mod = 0.1f;
            ent.field_70159_w = (player.field_70165_t - ent.field_70165_t) * mod;
            ent.field_70181_x = (player.field_70163_u - ent.field_70163_u) * mod;
            ent.field_70179_y = (player.field_70161_v - ent.field_70161_v) * mod;
            world.func_72838_d((Entity)ent);
        }
        if (this.instance != null) {
            this.instance.onSealBreak();
        }
    }

    public Aspect getSymbol(int slot) {
        return Aspect.getAspect((String)this.slots[slot].get());
    }

    public void func_70296_d() {
        this.dirty = true;
        super.func_70296_d();
    }

    public void readNBT(NBTTagCompound nbt) {
        if (this.instance != null) {
            this.instance.readFromNBT(nbt.func_74775_l("SealInstance"));
        } else {
            this.optInstNBT = nbt.func_74775_l("SealInstance");
        }
        this.dirty = true;
    }

    public void writeNBT(NBTTagCompound nbt) {
        if (this.instance != null) {
            nbt.func_74782_a("SealInstance", (NBTBase)this.instance.writeToNBT(new NBTTagCompound()));
        }
    }

    public void setSymbol(int index, Aspect aspect) {
        if (aspect == null) {
            this.slots[index].set(null);
        } else {
            this.slots[index].set((Object)aspect.getTag());
        }
        this.dirty = true;
        if (this.instance != null) {
            this.instance.onSealBreak();
        }
        this.instance = null;
        this.optInstNBT = null;
        this.combination = null;
    }

    public void tick() {
        SealCombination oldCombo;
        if (this.getLocation().getBlock() == BlocksTAR.SEAL) {
            this.orientation = (EnumFacing)this.getLocation().getState().func_177229_b((IProperty)EnumRotation.EFACING);
        }
        if (this.getLocation().getRedstone() > 0) {
            --this.ticksExisted;
        }
        if (this.dirty) {
            oldCombo = this.combination;
            this.combination = SealManager.getCombination(this);
            if (this.combination != oldCombo) {
                SealInstance old = this.instance;
                this.instance = SealManager.makeInstance(this, this.combination, this.optInstNBT);
                if (old != null) {
                    old.onSealBreak();
                }
            }
            this.optInstNBT = null;
            this.dirty = false;
        }
        if (this.instance != null) {
            this.instance.tick();
        }
        if (this.combination != null) {
            if (!this.combination.isValid(this)) {
                this.combination = null;
                this.dirty = true;
            }
        } else if (this.atTickRate(20)) {
            oldCombo = this.combination;
            this.combination = SealManager.getCombination(this);
            if (this.combination != oldCombo) {
                this.instance = SealManager.makeInstance(this, this.combination, null);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(4.0);
    }
}

