/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.thaumicadditions.api.AspectUtil;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;

public class TileCrystalBlock
extends TileSyncable
implements ITileDroppable {
    private Aspect aspect;

    public Aspect getAspect() {
        if (this.aspect == null) {
            Aspect[] asps = Aspect.aspects.values().toArray(new Aspect[0]);
            this.aspect = asps[new Random().nextInt(asps.length)];
        }
        return this.aspect;
    }

    public void setAspect(Aspect aspect) {
        this.aspect = aspect;
        this.getAspect();
        this.sendChangesToNearby();
    }

    public void writeNBT(NBTTagCompound nbt) {
        if (this.aspect != null) {
            nbt.func_74778_a("Aspect", this.aspect.getTag());
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Aspect", 8)) {
            this.aspect = Aspect.getAspect((String)nbt.func_74779_i("Aspect"));
        }
        this.getAspect();
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        if (!(world.field_72995_K || player != null && player.field_71075_bZ.field_75098_d || this.aspect == null)) {
            WorldUtil.spawnItemStack((World)world, (BlockPos)pos, (ItemStack)AspectUtil.crystalEssence(this.getAspect(), 9));
        }
    }

    public void addProperties(Map<String, Object> properties, RayTraceResult trace) {
        properties.put("Aspect", this.getAspect().getTag());
    }
}

