/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import com.zeitheron.thaumicadditions.TAReconstructed;
import com.zeitheron.thaumicadditions.api.AspectUtil;
import com.zeitheron.thaumicadditions.api.EdibleAspect;
import com.zeitheron.thaumicadditions.api.utils.ListenerList;
import com.zeitheron.thaumicadditions.init.ItemsTAR;
import com.zeitheron.thaumicadditions.inventory.container.ContainerAuraDisperser;
import com.zeitheron.thaumicadditions.inventory.gui.GuiAuraDisperser;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class TileAuraDisperser
extends TileSyncableTickable
implements ITileDroppable,
IInventory {
    public final InventoryDummy inventory = new InventoryDummy(9);
    public final ListenerList<TileAuraDisperser> listeners = new ListenerList<TileAuraDisperser>(this);
    public int tickTimer = 0;
    public int timer = 0;
    public AspectList aspects = null;
    public int secondsPerSalt = 20;
    private boolean auraApplied;

    public void tick() {
        ItemStack sel = this.select();
        if (!(this.field_145850_b.field_72995_K || sel.func_190926_b() || this.aspects != null && this.aspects.visSize() != 0)) {
            this.aspects = ItemsTAR.SALT_ESSENCE.getAspects(sel);
            sel.func_190918_g(1);
            this.timer = this.secondsPerSalt;
            this.tickTimer = this.timer * 20;
            this.sendChangesToNearby();
        }
        if (this.aspects != null && this.aspects.visSize() > 0 && this.getLocation().getRedstone() == 0) {
            this.applyAura();
        }
    }

    public void applyAura() {
        if (this.tickTimer > 0 && this.auraApplied) {
            --this.tickTimer;
        }
        if (!this.field_145850_b.field_72995_K && this.timer > 0 && this.aspects != null && this.atTickRate(20)) {
            EnumFacing face = WorldUtil.getFacing((IBlockState)this.getLocation().getState());
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c).func_72317_d((double)(face.func_82601_c() * 5), (double)(face.func_96559_d() * 4), (double)(face.func_82599_e() * 5)).func_72314_b(4.0, 3.0, 4.0);
            List ents = this.field_145850_b.func_72872_a(EntityLivingBase.class, aabb);
            boolean did = false;
            for (EntityLivingBase b : ents) {
                did |= EdibleAspect.execute(b, this.aspects).visSize() > 0;
            }
            if (did) {
                TAReconstructed.proxy.getFX().spawnAuraDisperserFX(this);
            }
            if (did) {
                --this.timer;
            }
            int tt = this.tickTimer;
            this.tickTimer = this.timer * 20;
            if (this.timer == 0) {
                this.aspects = null;
            }
            this.auraApplied = did;
            if (did || tt != this.tickTimer) {
                this.sendChangesToNearby();
            }
        }
    }

    public void addProperties(Map<String, Object> properties, RayTraceResult trace) {
        if (this.aspects != null) {
            properties.put("time_left", this.timer);
            properties.put("aspects", this.aspects.visSize());
            for (Aspect a : this.aspects.getAspectsSortedByName()) {
                properties.put(a.getName(), this.aspects.getAmount(a));
            }
        }
    }

    public boolean hasGui() {
        return true;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiAuraDisperser(player, this);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerAuraDisperser(player, this);
    }

    public ItemStack select() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i).func_190926_b() || this.inventory.func_70301_a(i).func_77973_b() != ItemsTAR.SALT_ESSENCE) continue;
            return this.inventory.func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    public void writeNBT(NBTTagCompound nbt) {
        this.listeners.update(0);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("Timer", this.timer);
        nbt.func_74768_a("TickTimer", this.tickTimer);
        nbt.func_74757_a("AuraApplied", this.auraApplied);
        AspectUtil.writeALToNBT(this.aspects, nbt);
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Aspects")) {
            this.aspects = new AspectList();
            this.aspects.readFromNBT(nbt);
        } else {
            this.aspects = null;
        }
        this.inventory.readFromNBT(nbt.func_74775_l("Items"));
        int ptimer = this.timer;
        this.timer = nbt.func_74762_e("Timer");
        this.tickTimer = nbt.func_74762_e("TickTimer");
        this.auraApplied = nbt.func_74767_n("AuraApplied");
        this.listeners.update(1);
        if (this.timer != ptimer) {
            this.listeners.update(11);
        }
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        this.inventory.drop(world, pos);
    }

    public String func_70005_c_() {
        return "A.D.";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.isUsableByPlayer(player, this.field_174879_c);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == ItemsTAR.SALT_ESSENCE;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }
}

