/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import com.zeitheron.thaumicadditions.inventory.container.ContainerAbstractSmelter;
import com.zeitheron.thaumicadditions.inventory.gui.GuiAbstractSmelter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.blocks.essentia.BlockSmelter;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.devices.TileBellows;
import thaumcraft.common.tiles.essentia.TileAlembic;
import thaumcraft.common.tiles.essentia.TileSmelter;

public abstract class TileAbstractSmelter
extends TileSyncableTickable
implements ISidedInventory {
    private static final int[] slots_bottom = new int[]{1};
    private static final int[] slots_top = new int[0];
    private static final int[] slots_sides = new int[]{0};
    public InventoryDummy inv = new InventoryDummy(2);
    public AspectList aspects = new AspectList();
    public int vis;
    public int smeltTime = 100;
    boolean speedBoost = false;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    int count = 0;
    int bellows = -1;

    public abstract float getEfficiency();

    public abstract int getSpeed();

    public abstract int getCapacity();

    public void readNBT(NBTTagCompound nbt) {
        this.speedBoost = nbt.func_74767_n("speedBoost");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.aspects.readFromNBT(nbt);
        this.vis = this.aspects.visSize();
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.currentItemBurnTime = nbt.func_74765_d("CurrentBurnTime");
        this.inv.readFromNBT(nbt.func_74775_l("Items"));
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CurrentBurnTime", (short)this.currentItemBurnTime);
        nbt.func_74757_a("speedBoost", this.speedBoost);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        this.aspects.writeToNBT(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.inv.writeToNBT(new NBTTagCompound()));
    }

    public boolean hasGui() {
        return true;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiAbstractSmelter(player.field_71071_by, this);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerAbstractSmelter(player.field_71071_by, this);
    }

    public void tick() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        ++this.count;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.bellows < 0) {
                this.checkNeighbours();
            }
            int speed = this.getSpeed();
            if (this.speedBoost) {
                speed = (int)((double)speed * 0.8);
            }
            if (this.count % (speed / 2) == 0 && this.aspects.size() > 0) {
                for (Aspect aspect : this.aspects.getAspects()) {
                    if (this.aspects.getAmount(aspect) <= 0 || !TileAbstractSmelter.processAlembics(this.func_145831_w(), this.func_174877_v(), aspect)) continue;
                    this.takeFromContainer(aspect, 1);
                    break;
                }
                block1: for (Aspect aspect : EnumFacing.field_176754_o) {
                    IBlockState aux = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a((EnumFacing)aspect));
                    if (aux.func_177230_c() != BlocksTC.smelterAux || BlockStateUtils.getFacing((IBlockState)aux) != aspect.func_176734_d()) continue;
                    for (Aspect aspect2 : this.aspects.getAspects()) {
                        if (this.aspects.getAmount(aspect2) <= 0 || !TileAbstractSmelter.processAlembics(this.func_145831_w(), this.func_174877_v().func_177972_a((EnumFacing)aspect), aspect2)) continue;
                        this.takeFromContainer(aspect2, 1);
                        continue block1;
                    }
                }
            }
            if (this.furnaceBurnTime == 0) {
                if (this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1));
                    if (this.furnaceBurnTime > 0) {
                        BlockSmelter.setFurnaceState((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (boolean)true);
                        flag1 = true;
                        this.speedBoost = false;
                        if (this.func_70301_a(1) != null) {
                            if (this.func_70301_a(1).func_77969_a(new ItemStack(ItemsTC.alumentum))) {
                                this.speedBoost = true;
                            }
                            ItemStack b4 = this.func_70301_a(1).func_77946_l();
                            this.func_70301_a(1).func_190918_g(1);
                            if (this.func_70301_a(1).func_190916_E() == 0) {
                                this.func_70299_a(1, b4.func_77973_b().getContainerItem(b4));
                            }
                        }
                    } else {
                        BlockSmelter.setFurnaceState((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (boolean)false);
                    }
                } else {
                    BlockSmelter.setFurnaceState((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (boolean)false);
                }
            }
            if (BlockStateUtils.isEnabled((int)this.func_145832_p()) && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime >= this.smeltTime) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)this.func_70301_a(0));
        if (al == null || al.size() == 0) {
            return false;
        }
        int vs = al.visSize();
        if (vs > this.getCapacity() - this.vis) {
            return false;
        }
        this.smeltTime = (int)((float)(vs * 2) * (1.0f - 0.125f * (float)this.bellows));
        return true;
    }

    public void checkNeighbours() {
        EnumFacing[] faces = EnumFacing.field_176754_o;
        try {
            if (BlockStateUtils.getFacing((int)this.func_145832_p()) == EnumFacing.NORTH) {
                faces = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
            }
            if (BlockStateUtils.getFacing((int)this.func_145832_p()) == EnumFacing.SOUTH) {
                faces = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST};
            }
            if (BlockStateUtils.getFacing((int)this.func_145832_p()) == EnumFacing.EAST) {
                faces = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST};
            }
            if (BlockStateUtils.getFacing((int)this.func_145832_p()) == EnumFacing.WEST) {
                faces = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bellows = TileBellows.getBellows((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing[])faces);
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            int flux = 0;
            AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)this.func_70301_a(0));
            for (Aspect a : al.getAspects()) {
                int q;
                int qq;
                if (this.getEfficiency() < 1.0f) {
                    qq = al.getAmount(a);
                    for (q = 0; q < qq; ++q) {
                        if (this.field_145850_b.field_73012_v.nextFloat() <= (a == Aspect.FLUX ? this.getEfficiency() * 0.66f : this.getEfficiency())) continue;
                        al.reduce(a, 1);
                        ++flux;
                    }
                } else if (this.getEfficiency() > 1.0f) {
                    qq = al.getAmount(a);
                    for (q = 0; q < qq; ++q) {
                        if (this.field_145850_b.field_73012_v.nextFloat() + 1.0f >= (a == Aspect.FLUX ? this.getEfficiency() * 0.66f : this.getEfficiency())) continue;
                        al.add(a, 1);
                    }
                }
                this.aspects.add(a, al.getAmount(a));
            }
            if (flux > 0) {
                int pp = 0;
                block3: for (int c = 0; c < flux; ++c) {
                    for (EnumFacing face : EnumFacing.field_176754_o) {
                        IBlockState vent = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(face));
                        if (vent.func_177230_c() != BlocksTC.smelterVent || BlockStateUtils.getFacing((IBlockState)vent) != face.func_176734_d() || (double)this.field_145850_b.field_73012_v.nextFloat() >= 0.333) continue;
                        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, face.func_176734_d().ordinal());
                        continue block3;
                    }
                    ++pp;
                }
                AuraHelper.polluteAura((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (float)pp, (boolean)true);
            }
            this.vis = this.aspects.visSize();
            this.func_70301_a(0).func_190918_g(1);
            if (this.func_70301_a(0).func_190916_E() <= 0) {
                this.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)par0ItemStack) > 0;
    }

    public boolean func_94041_b(int par1, ItemStack stack2) {
        AspectList al;
        if (par1 == 0 && (al = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack2)) != null && al.size() > 0) {
            return true;
        }
        return par1 == 1 ? TileSmelter.isItemFuel((ItemStack)stack2) : false;
    }

    public int[] func_180463_a(EnumFacing par1) {
        return par1 == EnumFacing.DOWN ? slots_bottom : (par1 == EnumFacing.UP ? slots_top : slots_sides);
    }

    public boolean func_180462_a(int par1, ItemStack stack2, EnumFacing par3) {
        return par3 == EnumFacing.UP ? false : this.func_94041_b(par1, stack2);
    }

    public boolean func_180461_b(int par1, ItemStack stack2, EnumFacing par3) {
        return par3 != EnumFacing.UP || par1 != 1 || stack2.func_77973_b() == Items.field_151133_ar;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.aspects != null && this.aspects.getAmount(tag) >= amount) {
            this.aspects.remove(tag, amount);
            this.vis = this.aspects.visSize();
            this.sendChangesToNearby();
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCookProgressScaled(int par1) {
        if (this.smeltTime <= 0) {
            this.smeltTime = 1;
        }
        return (float)(this.furnaceCookTime * par1) / (float)this.smeltTime;
    }

    @SideOnly(value=Side.CLIENT)
    public float getVisScaled(int par1) {
        if (this.getCapacity() == 0) {
            return 0.0f;
        }
        return (float)(this.vis * par1) / (float)this.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public float getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return (float)(this.furnaceBurnTime * par1) / (float)this.currentItemBurnTime;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b != null) {
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                EnumFacing d = EnumFacing.field_82609_l[j];
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5 + (double)d.func_176734_d().func_82601_c(), (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5 + (double)d.func_176734_d().func_82599_e(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.25f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f, true);
                for (int a = 0; a < 4; ++a) {
                    float fx = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    float fz = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    float fy = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    float fx2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    float fz2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    float fy2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    int color = 0xAAAAAA;
                    FXDispatcher.INSTANCE.drawVentParticles((double)((float)this.func_174877_v().func_177958_n() + 0.5f + fx + (float)d.func_176734_d().func_82601_c()), (double)((float)this.func_174877_v().func_177956_o() + 0.5f + fy), (double)((float)this.func_174877_v().func_177952_p() + 0.5f + fz + (float)d.func_176734_d().func_82599_e()), (double)((float)d.func_176734_d().func_82601_c() / 4.0f + fx2), (double)((float)d.func_176734_d().func_96559_d() / 4.0f + fy2), (double)((float)d.func_176734_d().func_82599_e() / 4.0f + fz2), color);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public static boolean processAlembics(World world, BlockPos pos, Aspect aspect) {
        TileAlembic alembic;
        TileEntity te;
        int deep = 1;
        while ((te = world.func_175625_s(pos.func_177981_b(deep))) != null && te instanceof TileAlembic) {
            alembic = (TileAlembic)te;
            if (alembic.amount > 0 && alembic.aspect == aspect && alembic.addToContainer(aspect, 1) == 0) {
                return true;
            }
            ++deep;
        }
        deep = 1;
        while ((te = world.func_175625_s(pos.func_177981_b(deep))) != null && te instanceof TileAlembic) {
            alembic = (TileAlembic)te;
            if ((alembic.aspectFilter == null || alembic.aspectFilter == aspect) && alembic.addToContainer(aspect, 1) == 0) {
                return true;
            }
            ++deep;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inv.isUsableByPlayer(player, this.field_174879_c);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }
}

