/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.proxy;

import com.zeitheron.hammercore.client.render.item.IItemRender;
import com.zeitheron.hammercore.client.render.item.ItemRenderingHandler;
import com.zeitheron.hammercore.internal.blocks.base.IBlockHorizontal;
import com.zeitheron.hammercore.internal.blocks.base.IBlockOrientable;
import com.zeitheron.hammercore.utils.NBTUtils;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import com.zeitheron.thaumicadditions.TAReconstructed;
import com.zeitheron.thaumicadditions.api.AspectUtil;
import com.zeitheron.thaumicadditions.api.EdibleAspect;
import com.zeitheron.thaumicadditions.api.fx.TARParticleTypes;
import com.zeitheron.thaumicadditions.blocks.BlockAbstractEssentiaJar;
import com.zeitheron.thaumicadditions.client.isr.ItemRenderJar;
import com.zeitheron.thaumicadditions.client.render.entity.RenderEntityChester;
import com.zeitheron.thaumicadditions.client.render.tile.TESRAspectCombiner;
import com.zeitheron.thaumicadditions.client.render.tile.TESRAuraCharger;
import com.zeitheron.thaumicadditions.client.render.tile.TESRAuraDisperser;
import com.zeitheron.thaumicadditions.client.render.tile.TESRCrystalBore;
import com.zeitheron.thaumicadditions.client.render.tile.TESRCrystalCrusher;
import com.zeitheron.thaumicadditions.client.render.tile.TESRFluxConcentrator;
import com.zeitheron.thaumicadditions.client.texture.TextureThaumonomiconBG;
import com.zeitheron.thaumicadditions.compat.ITARC;
import com.zeitheron.thaumicadditions.entity.EntityChester;
import com.zeitheron.thaumicadditions.events.ClientEventReactor;
import com.zeitheron.thaumicadditions.init.BlocksTAR;
import com.zeitheron.thaumicadditions.init.ItemsTAR;
import com.zeitheron.thaumicadditions.inventory.gui.GuiSealGlobe;
import com.zeitheron.thaumicadditions.items.ItemSealSymbol;
import com.zeitheron.thaumicadditions.items.ItemVisPod;
import com.zeitheron.thaumicadditions.items.ItemVisSeeds;
import com.zeitheron.thaumicadditions.proxy.CommonProxy;
import com.zeitheron.thaumicadditions.proxy.fx.FXHandler;
import com.zeitheron.thaumicadditions.proxy.fx.FXHandlerClient;
import com.zeitheron.thaumicadditions.tiles.TileAspectCombiner;
import com.zeitheron.thaumicadditions.tiles.TileAuraCharger;
import com.zeitheron.thaumicadditions.tiles.TileAuraDisperser;
import com.zeitheron.thaumicadditions.tiles.TileCrystalBore;
import com.zeitheron.thaumicadditions.tiles.TileCrystalCrusher;
import com.zeitheron.thaumicadditions.tiles.TileFluxConcentrator;
import com.zeitheron.thaumicadditions.tiles.TileSeal;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.blocks.essentia.BlockJarItem;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        ModelLoader.setCustomStateMapper((Block)BlocksTAR.CRYSTAL_WATER, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlocksTAR.ASPECT_COMBINER, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{IBlockHorizontal.FACING}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlocksTAR.CRYSTAL_BORE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{IBlockOrientable.FACING}).func_178441_a());
        RenderingRegistry.registerEntityRenderingHandler(EntityChester.class, (IRenderFactory)RenderEntityChester.FACTORY);
        OBJLoader.INSTANCE.addDomain("thaumadditions");
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)ClientEventReactor.REACTOR);
        for (ITARC a : TAReconstructed.arcs) {
            a.initClient();
        }
        Minecraft.func_71410_x().func_110434_K().func_110580_a(TEXTURE_THAUMONOMICON_BG, (ITickableTextureObject)new TextureThaumonomiconBG());
        Minecraft.func_71410_x().getItemColors().func_186730_a(ItemsTAR.SALT_ESSENCE::getItemColor, new Item[]{ItemsTAR.SALT_ESSENCE});
        Minecraft.func_71410_x().getItemColors().func_186730_a(ItemVisPod::getColor, new Item[]{ItemsTAR.VIS_POD});
        Minecraft.func_71410_x().getItemColors().func_186730_a(ItemVisSeeds::getColor, new Item[]{ItemsTAR.VIS_SEEDS});
        Minecraft.func_71410_x().getItemColors().func_186731_a((stack, layer) -> {
            if (layer == 1) {
                AspectList al = EdibleAspect.getSalt(stack);
                return al.visSize() > 0 ? AspectUtil.getColor(al, true) : 0xFF0000;
            }
            return 0xFFFFFF;
        }, new Block[]{BlocksTAR.CAKE});
        Minecraft.func_71410_x().getItemColors().func_186730_a(ItemsTAR.ENTITY_CELL::getColor, new Item[]{ItemsTAR.ENTITY_CELL});
        Minecraft.func_71410_x().getItemColors().func_186730_a(BlocksTAR.CRYSTAL_BLOCK::getColor, new Item[]{BlocksTAR.CRYSTAL_BLOCK.getItemBlock()});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, index) -> {
            Aspect a;
            return index == 0 && (a = ItemSealSymbol.getAspect(stack)) != null ? a.getColor() : 0xFFFFFF;
        }, new Item[]{ItemsTAR.SEAL_SYMBOL});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, layer) -> {
            if (layer == 1) {
                int[] rgb;
                int color = 0xFF0000;
                if (stack.func_77942_o() && (rgb = stack.func_77978_p().func_74759_k("RGB")) != null && rgb.length >= 3) {
                    color = rgb[0] << 16 | rgb[1] << 8 | rgb[2];
                }
                return color;
            }
            return 0xFFFFFF;
        }, new Item[]{Item.func_150898_a((Block)BlocksTAR.SEAL)});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(BlocksTAR.CRYSTAL_BLOCK::getColor, new Block[]{BlocksTAR.CRYSTAL_BLOCK});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(BlocksTAR.VIS_CROPS::getColor, new Block[]{BlocksTAR.VIS_CROPS});
        ClientRegistry.bindTileEntitySpecialRenderer(TileAuraDisperser.class, (TileEntitySpecialRenderer)new TESRAuraDisperser());
        ItemRenderingHandler.INSTANCE.applyItemRender((IItemRender)new ItemRenderJar(), i -> i instanceof BlockAbstractEssentiaJar.BlockAbstractJarItem || i instanceof BlockJarItem);
        TESRAspectCombiner acom = new TESRAspectCombiner();
        ClientRegistry.bindTileEntitySpecialRenderer(TileAspectCombiner.class, (TileEntitySpecialRenderer)acom);
        ItemRenderingHandler.INSTANCE.setItemRender(Item.func_150898_a((Block)BlocksTAR.ASPECT_COMBINER), (IItemRender)acom);
        Minecraft.func_71410_x().func_175599_af().func_175048_a(Item.func_150898_a((Block)BlocksTAR.ASPECT_COMBINER), 0, "chest");
        TESRAuraCharger cha = new TESRAuraCharger();
        ClientRegistry.bindTileEntitySpecialRenderer(TileAuraCharger.class, (TileEntitySpecialRenderer)cha);
        ItemRenderingHandler.INSTANCE.setItemRender(Item.func_150898_a((Block)BlocksTAR.AURA_CHARGER), (IItemRender)cha);
        Minecraft.func_71410_x().func_175599_af().func_175048_a(Item.func_150898_a((Block)BlocksTAR.AURA_CHARGER), 0, "chest");
        TESRCrystalCrusher crycr = new TESRCrystalCrusher();
        ClientRegistry.bindTileEntitySpecialRenderer(TileCrystalCrusher.class, (TileEntitySpecialRenderer)crycr);
        ItemRenderingHandler.INSTANCE.setItemRender(Item.func_150898_a((Block)BlocksTAR.CRYSTAL_CRUSHER), (IItemRender)crycr);
        Minecraft.func_71410_x().func_175599_af().func_175048_a(Item.func_150898_a((Block)BlocksTAR.CRYSTAL_CRUSHER), 0, "chest");
        TESRCrystalBore crybo = new TESRCrystalBore();
        ClientRegistry.bindTileEntitySpecialRenderer(TileCrystalBore.class, (TileEntitySpecialRenderer)crybo);
        ItemRenderingHandler.INSTANCE.setItemRender(Item.func_150898_a((Block)BlocksTAR.CRYSTAL_BORE), (IItemRender)crybo);
        Minecraft.func_71410_x().func_175599_af().func_175048_a(Item.func_150898_a((Block)BlocksTAR.CRYSTAL_BORE), 0, "chest");
        TESRFluxConcentrator fc = new TESRFluxConcentrator();
        ClientRegistry.bindTileEntitySpecialRenderer(TileFluxConcentrator.class, (TileEntitySpecialRenderer)fc);
        ItemRenderingHandler.INSTANCE.setItemRender(Item.func_150898_a((Block)BlocksTAR.FLUX_CONCENTRATOR), (IItemRender)fc);
        Minecraft.func_71410_x().func_175599_af().func_175048_a(Item.func_150898_a((Block)BlocksTAR.FLUX_CONCENTRATOR), 0, "chest");
        final ModelResourceLocation cryloc = new ModelResourceLocation(BlocksTAR.CRYSTAL_BLOCK.getRegistryName(), "normal");
        ModelLoader.setCustomStateMapper((Block)BlocksTAR.CRYSTAL_BLOCK, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return cryloc;
            }
        });
        ClientProxy.mapFluid((BlockFluidBase)BlocksTAR.CRYSTAL_WATER);
    }

    @Override
    public void postInit() {
        Minecraft.func_71410_x().field_71452_i.func_178929_a(TARParticleTypes.ITEMSTACK_CRACK.func_179348_c(), (particleID, worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, args) -> new ParticleColoredBreaking(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, new ItemStack(NBTUtils.toNBT((int[])args))));
        Minecraft.func_71410_x().field_71452_i.func_178929_a(TARParticleTypes.POLLUTION.func_179348_c(), (particleID, w, x, y, z, x2, y2, z2, args) -> {
            FXGeneric fb = new FXGeneric(w, x, y, z, (double)(w.field_73012_v.nextFloat() - w.field_73012_v.nextFloat()) * 0.005, 0.02, (double)(w.field_73012_v.nextFloat() - w.field_73012_v.nextFloat()) * 0.005);
            fb.func_187114_a(400 + w.field_73012_v.nextInt(100));
            fb.func_70538_b(1.0f, 0.3f, 0.9f);
            fb.setAlphaF(new float[]{0.5f, 0.0f});
            fb.setGridSize(16);
            fb.setParticles(56, 1, 1);
            fb.setScale(new float[]{2.0f, 5.0f});
            fb.setLayer(1);
            fb.setSlowDown(1.0);
            fb.setWind(0.001);
            fb.setRotationSpeed(w.field_73012_v.nextFloat(), w.field_73012_v.nextBoolean() ? -1.0f : 1.0f);
            ParticleEngine.addEffect((World)w, (Particle)fb);
            return null;
        });
        Minecraft.func_71410_x().field_71452_i.func_178929_a(TARParticleTypes.COLOR_CLOUD.func_179348_c(), (particleID, worldIn, x, y, z, x2, y2, z2, args) -> {
            int red = args.length > 1 ? args[0] : 255;
            int green = args.length > 2 ? args[1] : 255;
            int blue = args.length > 3 ? args[2] : 255;
            int alpha = args.length > 4 ? args[3] : 0;
            int a = 200 + worldIn.field_73012_v.nextInt(100);
            FXGeneric fb = new FXGeneric(worldIn, x, y, z, (x2 - x) / ((double)a * 0.9), (y2 - y) / ((double)a * 0.9), (z2 - z) / ((double)a * 0.9));
            fb.func_187114_a(a);
            fb.func_70538_b((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
            fb.setAlphaF(new float[]{alpha == 0 ? 0.3f : (float)alpha / 255.0f, 0.0f});
            fb.setGridSize(16);
            fb.setParticles(56, 1, 1);
            fb.setScale(new float[]{2.0f, 5.0f});
            fb.setLayer(0);
            fb.setSlowDown(1.0);
            fb.setNoClip(args.length > 5 ? args[4] > 0 : false);
            fb.setRotationSpeed(worldIn.field_73012_v.nextFloat(), worldIn.field_73012_v.nextBoolean() ? -1.0f : 1.0f);
            ParticleEngine.addEffect((World)worldIn, (Particle)fb);
            return null;
        });
    }

    @Override
    public int getItemColor(ItemStack stack, int layer) {
        return Minecraft.func_71410_x().getItemColors().func_186728_a(stack, layer);
    }

    @Override
    protected FXHandler createFX() {
        return new FXHandlerClient();
    }

    private static void mapFluid(BlockFluidBase fluidBlock) {
        Item item = Item.func_150898_a((Block)fluidBlock);
        assert (item != null);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("thaumadditions:fluid", fluidBlock.getFluid().getName());
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
        ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return modelResourceLocation;
            }
        });
    }

    @Nonnull
    public static TextureAtlasSprite getSprite(String path) {
        TextureMap m = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite s = m.getTextureExtry(path);
        if (s == null) {
            s = m.func_110572_b(path);
        }
        return s != null ? s : m.func_174944_f();
    }

    @Override
    public void viewSeal(TileSeal tile) {
        Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSealGlobe(tile)));
    }

    public static class ParticleColoredBreaking
    extends ParticleBreaking {
        protected ParticleColoredBreaking(World worldIn, double posXIn, double posYIn, double posZIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, ItemStack stack) {
            super(worldIn, posXIn, posYIn, posZIn, xSpeedIn, ySpeedIn, zSpeedIn, stack.func_77973_b(), stack.func_77952_i());
            int color = TAReconstructed.proxy.getItemColor(stack, 0);
            this.func_70538_b(ColorHelper.getRed((int)color), ColorHelper.getGreen((int)color), ColorHelper.getBlue((int)color));
        }
    }
}

