/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.inventory.gui;

import com.zeitheron.hammercore.client.gui.GuiCentered;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.thaumicadditions.items.ItemSealSymbol;
import com.zeitheron.thaumicadditions.tiles.TileSeal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;

public class GuiSealGlobe
extends GuiCentered {
    public final TileSeal seal;
    final List<String> tooltip = new ArrayList<String>();

    public GuiSealGlobe(TileSeal seal) {
        this.seal = seal;
        this.xSize = 192.0;
        this.ySize = 228.0;
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        String d;
        GlStateManager.func_179147_l();
        com.zeitheron.hammercore.client.utils.UtilsFX.bindTexture((String)"thaumadditions", (String)"textures/gui/seal_globe.png");
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.guiLeft, (double)(this.guiTop + 36.0), (double)0.0);
        GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
        RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)256.0, (double)256.0);
        GlStateManager.func_179121_F();
        float size = 32.0f;
        int total = 3;
        double gap = this.xSize / (double)total;
        for (int i = 0; i < total; ++i) {
            Aspect s = this.seal.getSymbol(i);
            com.zeitheron.hammercore.client.utils.UtilsFX.bindTexture((String)"thaumadditions", (String)"textures/gui/widgets.png");
            GlStateManager.func_179094_E();
            float x = (float)(this.guiLeft + (this.xSize - (double)size) / 2.0 + gap * (double)(i - 1));
            float y = (float)this.guiTop;
            boolean hover = (float)mouseX >= x && (float)mouseY >= y && (float)mouseX < x + size && (float)mouseY < y + size;
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)(size / 16.0f), (float)(size / 16.0f), (float)(size / 16.0f));
            RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            if (s == null) {
                if (hover) {
                    this.tooltip.add(I18n.func_135052_a((String)"gui.thaumadditions:null", (Object[])new Object[0]));
                }
                RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0);
            } else {
                ItemStack is = ItemSealSymbol.createItem(s, 1);
                this.field_146297_k.func_175599_af().func_180450_b(is, 0, 0);
                if (hover) {
                    this.tooltip.addAll(is.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL));
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)9.5, (double)9.5, (double)350.0);
                    GlStateManager.func_179139_a((double)0.3333333333333333, (double)0.3333333333333333, (double)0.3333333333333333);
                    UtilsFX.drawTag((int)0, (int)0, (Aspect)s, (float)0.0f, (int)0, (double)0.0, (int)771, (float)1.0f, (boolean)false);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
        String text = this.seal.combination == null ? I18n.func_135052_a((String)"seal.thaumadditions:none", (Object[])new Object[0]) : ((d = this.seal.combination.getDescription(this.seal)) != null ? d : I18n.func_135052_a((String)"seal.thaumadditions:unconfigured", (Object[])new Object[]{this.seal.combination.getModName(), this.seal.combination.getAuthor()}));
        int maxLength = 150;
        int height = this.field_146289_q.func_78267_b(text, maxLength);
        this.field_146289_q.func_78279_b(text, (int)(this.guiLeft + 26.25), (int)(this.guiTop + 36.0 + (this.ySize - 36.0 - (double)height) / 2.0), maxLength, -1);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.tooltip.isEmpty()) {
            this.func_146283_a(this.tooltip, mouseX, mouseY);
            this.tooltip.clear();
        }
    }
}

