/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.events;

import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.event.FoodEatenEvent;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.thaumicadditions.api.EdibleAspect;
import com.zeitheron.thaumicadditions.init.ItemsTAR;
import com.zeitheron.thaumicadditions.items.armor.ItemMithminiteDress;
import com.zeitheron.thaumicadditions.utils.Foods;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.research.ResearchManager;

@MCFBus
public class LivingEventsTAR {
    public static HashMap<Integer, Float> prevStep = new HashMap();

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        NBTTagCompound nbt = e.player.getEntityData();
        if (nbt.func_74767_n("TAR_Flight")) {
            e.player.field_71075_bZ.field_75101_c = true;
            nbt.func_74757_a("TAR_Flight", false);
        } else if (nbt.func_74764_b("TAR_Flight")) {
            e.player.field_71075_bZ.field_75101_c = false;
            e.player.field_71075_bZ.field_75100_b = false;
            nbt.func_82580_o("TAR_Flight");
        }
        if (nbt.func_74762_e("TAR_LockFOV") > 0) {
            int nl = nbt.func_74762_e("TAR_LockFOV") - 1;
            nbt.func_74768_a("TAR_LockFOV", nl);
            if (nl == 0) {
                nbt.func_82580_o("TAR_LockFOV");
            }
        }
        LivingEventsTAR.handleSpeedMods(e.player);
        IPlayerKnowledge ipk = ThaumcraftCapabilities.getKnowledge((EntityPlayer)e.player);
        if (ipk.isResearchComplete("BASEELDRITCH") && !ipk.isResearchComplete("TAR_ELDRITCH")) {
            ResearchManager.completeResearch((EntityPlayer)e.player, (String)"TAR_ELDRITCH", (boolean)true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void foodEaten(FoodEatenEvent e) {
        if (e.getEntityPlayer() instanceof EntityPlayerMP) {
            AspectList al;
            EntityPlayerMP mp = (EntityPlayerMP)e.getEntityPlayer();
            ItemStack item = e.getOriginStack();
            if (!item.func_190926_b() && Foods.isFood(item.func_77973_b()) && (al = EdibleAspect.getSalt(item)).visSize() > 0) {
                EdibleAspect.execute((EntityLivingBase)mp, al);
            }
        }
    }

    @SubscribeEvent
    public void itemPickupEvent(EntityItemPickupEvent ev) {
        EntityItem e;
        ItemStack stack;
        EntityPlayerMP mp;
        float fall = ev.getEntityPlayer().field_70143_R;
        if (ev.getEntityPlayer() instanceof EntityPlayerMP && (mp = (EntityPlayerMP)ev.getEntityPlayer()).func_174813_aQ() != null && fall >= 3.0f && ThaumcraftCapabilities.knowsResearch((EntityPlayer)mp, (String[])new String[]{"TAR_ESSENCE_SALT@2"}) && !(stack = (e = ev.getItem()).func_92059_d()).func_190926_b() && stack.func_77973_b() == ItemsTC.crystalEssence) {
            NBTTagCompound nbt = e.getEntityData();
            float crack = nbt.func_74760_g("CrystalCrack");
            crack += fall - 1.0f;
            int shrinks = 0;
            while (crack > 4.0f && !stack.func_190926_b()) {
                ++shrinks;
                crack -= 4.0f;
                stack.func_190918_g(1);
                ItemStack salt = new ItemStack((Item)ItemsTAR.SALT_ESSENCE);
                salt.func_77982_d(stack.func_77978_p().func_74737_b());
                EntityItem ni = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, salt);
                ni.field_70159_w = e.field_70159_w;
                ni.field_70181_x = e.field_70181_x;
                ni.field_70179_y = e.field_70179_y;
                if (stack.func_190926_b()) {
                    e.func_70106_y();
                    return;
                }
                e.field_70170_p.func_72838_d((Entity)ni);
                SoundUtil.playSoundEffect((World)e.field_70170_p, (String)SoundsTC.crystal.getRegistryName().toString(), (BlockPos)e.func_180425_c(), (float)1.0f, (float)0.8f, (SoundCategory)SoundCategory.PLAYERS);
            }
            nbt.func_74776_a("CrystalCrack", crack);
            if (shrinks == 0) {
                SoundUtil.playSoundEffect((World)e.field_70170_p, (String)SoundsTC.crystal.getRegistryName().toString(), (BlockPos)e.func_180425_c(), (float)1.0f, (float)0.2f, (SoundCategory)SoundCategory.PLAYERS);
            }
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent lde) {
        EntityPlayerMP mp;
        EntityLivingBase el = lde.getEntityLiving();
        if (el instanceof EntityPlayerMP && (mp = (EntityPlayerMP)el).func_146103_bH().getName().equalsIgnoreCase("zeitheron")) {
            int scales = 1 + mp.field_70170_p.field_73012_v.nextInt(6);
            EntityItem ei = mp.func_146097_a(new ItemStack((Item)ItemsTAR.ZEITH_SCALES, scales), true, false);
            ei.field_70159_w *= 0.2;
            ei.field_70179_y *= 0.2;
        }
    }

    @SubscribeEvent
    public void pickupXP(PlayerPickupXpEvent e) {
        EntityPlayerMP mp = (EntityPlayerMP)WorldUtil.cast((Object)e.getEntityPlayer(), EntityPlayerMP.class);
        if (mp != null && !mp.field_70170_p.field_72995_K && e.getOrb() != null) {
            int xp = e.getOrb().func_70526_d();
            ItemStack stack = mp.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMithminiteDress) {
                for (EnumHand hand : EnumHand.values()) {
                    ItemStack held = mp.func_184586_b(hand);
                    if (held.func_190926_b() || !held.func_77973_b().func_77645_m() || !held.func_77973_b().isDamaged(held)) continue;
                    held.func_77964_b(Math.max(0, held.func_77952_i() - xp));
                }
            }
        }
    }

    @SubscribeEvent
    public void fall(LivingFallEvent e) {
        ItemStack boots = e.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
        if (!boots.func_190926_b() && boots.func_77973_b() instanceof ItemMithminiteDress) {
            e.setDamageMultiplier(0.0f);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void hurt(LivingHurtEvent e) {
        ItemStack chest;
        DamageSource ds = e.getSource();
        if (ds != null && ds.func_76347_k() && !(chest = e.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemMithminiteDress) {
            e.setCanceled(true);
            e.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76426_n, 119, 0, true, false));
        }
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof EntityPlayer && ((EntityPlayer)event.getEntity()).func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemMithminiteDress) {
            event.getEntityLiving().field_70181_x += (double)0.275f;
        }
    }

    private static void handleSpeedMods(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && (player.func_70093_af() || !(player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemMithminiteDress)) && prevStep.containsKey(player.func_145782_y())) {
            player.field_70138_W = prevStep.get(player.func_145782_y()).floatValue();
            prevStep.remove(player.func_145782_y());
        }
    }
}

