/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.entity;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.utils.InterItemStack;
import com.zeitheron.hammercore.utils.ItemInsertionUtil;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import com.zeitheron.hammercore.utils.math.MathHelper;
import com.zeitheron.thaumicadditions.init.ItemsTAR;
import com.zeitheron.thaumicadditions.inventory.container.ContainerChester;
import com.zeitheron.thaumicadditions.items.tools.ItemBoneEye;
import com.zeitheron.thaumicadditions.net.PacketSyncEntity;
import com.zeitheron.thaumicadditions.net.PacketSyncTrunk;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import thaumcraft.api.aura.AuraHelper;

public class EntityChester
extends EntityAnimal {
    public static final DataParameter<Float> LID_ROTATION = EntityDataManager.func_187226_a(EntityChester.class, (DataSerializer)DataSerializers.field_187193_c);
    public final InventoryDummy inventory = new InventoryDummy(36);
    public boolean open;
    private int jumpDelay;
    private int eatDelay;
    public int angerLevel;
    public int attackTime;
    public boolean staying;
    public float prevLidRotation;
    public UUID owner;
    public float field_768_a;
    public float field_767_b;

    public EntityChester(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
    }

    public EntityChester(World world, EntityPlayer player, double x, double y, double z) {
        this(world);
        this.owner = player.func_146103_bH().getId();
        this.func_70634_a(x, y, z);
    }

    public float getLidRotation() {
        return ((Float)this.field_70180_af.func_187225_a(LID_ROTATION)).floatValue();
    }

    public float getCurrentLidRotation(float partialTime) {
        float c = this.getLidRotation();
        return this.prevLidRotation + (c - this.prevLidRotation) * partialTime;
    }

    public void setLidRotation(float lidRotation) {
        this.field_70180_af.func_187227_b(LID_ROTATION, (Object)Float.valueOf(lidRotation));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LID_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.staying = nbt.func_74767_n("Stay");
        this.inventory.readFromNBT(nbt.func_74775_l("Items"));
        this.owner = nbt.func_186857_a("Owner");
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        nbt.func_74757_a("Stay", this.staying);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        nbt.func_186854_a("Owner", this.owner);
        return super.func_189511_e(nbt);
    }

    public void resizeInventory(int slots) {
        NonNullList nev = NonNullList.func_191197_a((int)slots, (Object)ItemStack.field_190927_a);
        int min = Math.min(this.inventory.func_70302_i_(), slots);
        for (int i = 0; i < min; ++i) {
            nev.set(i, this.inventory.inventory.get(i));
        }
        this.inventory.inventory = nev;
    }

    public boolean func_70631_g_() {
        return false;
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
    }

    protected float func_70672_c(DamageSource source, float damage) {
        return 0.0f;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.inventory.drop(this.field_70170_p, this.func_180425_c());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i && !this.field_70128_L) {
            this.func_70106_y();
        }
        return false;
    }

    protected void func_70623_bb() {
    }

    public void func_70106_y() {
        this.inventory.drop(this.field_70170_p, this.func_180425_c());
        WorldUtil.spawnItemStack((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)new ItemStack((Item)ItemsTAR.CHESTER));
        super.func_70106_y();
    }

    public void eatItems() {
        if (this.func_110143_aJ() <= 25.0f && this.eatDelay == 0) {
            for (int a = 0; a < this.inventory.func_70302_i_(); ++a) {
                if (this.inventory.func_70301_a(a).func_190926_b() || !(this.inventory.func_70301_a(a).func_77973_b() instanceof ItemFood)) continue;
                ItemFood itemfood = (ItemFood)this.inventory.func_70301_a(a).func_77973_b();
                this.inventory.func_70301_a(a).func_190918_g(1);
                this.eatDelay = 10 + this.field_70146_Z.nextInt(15);
                if (this.func_110143_aJ() == 50.0f) {
                    HammerCore.audioProxy.playSoundAt(this.field_70170_p, "random.burp", this.func_180425_c(), 0.5f, this.field_70146_Z.nextFloat() * 0.5f + 0.5f, SoundCategory.AMBIENT);
                } else {
                    HammerCore.audioProxy.playSoundAt(this.field_70170_p, "random.eat", this.func_180425_c(), 0.5f, this.field_70146_Z.nextFloat() * 0.5f + 0.5f, SoundCategory.AMBIENT);
                }
                this.showHeartsOrSmokeFX(true);
                this.setLidRotation(0.15f);
                break;
            }
        }
    }

    private void pullItems() {
        if (this.eatDelay > 0) {
            return;
        }
        List items = this.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - 0.5, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5));
        for (EntityItem ei : items) {
            boolean changed;
            ItemStack leftover = ItemInsertionUtil.putStackInInventoryAllSlots((IInventory)this.inventory, (ItemStack)ei.func_92059_d().func_77946_l(), (EnumFacing)EnumFacing.UP);
            boolean bl = changed = InterItemStack.isStackNull((ItemStack)leftover) || !leftover.func_77969_a(ei.func_92059_d());
            if (InterItemStack.isStackNull((ItemStack)leftover)) {
                ei.func_70106_y();
            } else {
                ei.func_92058_a(leftover);
            }
            if (!changed) continue;
            this.eatDelay += 2 + this.field_70146_Z.nextInt(4);
            return;
        }
    }

    public void func_70071_h_() {
        this.field_767_b = this.field_768_a;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        this.updateEntity();
        this.eatItems();
        if (this.field_70122_E && !flag) {
            this.field_768_a = -0.5f;
        }
        this.field_768_a *= 0.6f;
        this.prevLidRotation = this.getLidRotation();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!player.func_146103_bH().getId().equals(this.owner) && !this.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.thaumadditions:chester.not_master", new Object[0]));
            return true;
        }
        ItemStack held = player.func_184586_b(hand);
        if (!held.func_190926_b() && held.func_77973_b() instanceof ItemFood && this.func_110143_aJ() < 50.0f) {
            held.func_190918_g(1);
            if (this.func_110143_aJ() == 50.0f) {
                HammerCore.audioProxy.playSoundAt(this.field_70170_p, "random.burp", this.func_180425_c(), 0.5f, this.field_70146_Z.nextFloat() * 0.5f + 0.5f, SoundCategory.AMBIENT);
            } else {
                HammerCore.audioProxy.playSoundAt(this.field_70170_p, "random.eat", this.func_180425_c(), 0.5f, this.field_70146_Z.nextFloat() * 0.5f + 0.5f, SoundCategory.AMBIENT);
            }
            this.showHeartsOrSmokeFX(true);
            this.setLidRotation(0.15f);
            return true;
        }
        if (!held.func_190926_b() && held.func_77973_b() instanceof ItemBoneEye && !this.field_70170_p.field_72995_K) {
            if (player.func_70093_af()) {
                this.func_70106_y();
                HammerCore.audioProxy.playSoundAt(this.field_70170_p, "thaumcraft:zap", this.func_180425_c(), 0.5f, 1.0f, SoundCategory.PLAYERS);
            } else {
                this.staying = !this.staying;
                HammerCore.audioProxy.playSoundAt(this.field_70170_p, "thaumcraft:key", this.func_180425_c(), 0.5f, 1.0f, SoundCategory.PLAYERS);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.thaumadditions:chester." + (this.staying ? "stay" : "follow"), new Object[0]), true);
                HCNet.INSTANCE.sendToAllAround((IPacket)new PacketSyncEntity((Entity)this), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
            }
            player.func_184609_a(hand);
            return true;
        }
        this.open = true;
        if (player instanceof EntityPlayerMP && !this.field_70170_p.field_72995_K) {
            HCNet.INSTANCE.sendTo((IPacket)new PacketSyncTrunk((Entity)this), (EntityPlayerMP)player);
            HammerCore.audioProxy.playSoundAt(this.field_70170_p, "block.chest.open", this.func_180425_c(), 0.1f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f, SoundCategory.AMBIENT);
        }
        player.field_71070_bA = new ContainerChester(this, player);
        player.func_184609_a(hand);
        return true;
    }

    void showHeartsOrSmokeFX(boolean flag) {
        EnumParticleTypes s = EnumParticleTypes.HEART;
        int amount = 1;
        if (!flag) {
            s = EnumParticleTypes.EXPLOSION_NORMAL;
            amount = 7;
        }
        for (int i = 0; i < amount; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70161_v + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
        }
    }

    protected void updateEntity() {
        EntityPlayerMP entityplayer;
        boolean sync = false;
        if (this.angerLevel > 0) {
            --this.angerLevel;
        }
        if (this.eatDelay > 0) {
            --this.eatDelay;
        }
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        MinecraftServer mc = this.func_184102_h();
        this.field_70143_R = 0.0f;
        EntityPlayerMP entityPlayerMP = entityplayer = mc != null ? mc.func_184103_al().func_177451_a(this.owner) : null;
        if (entityplayer != null) {
            if (!(entityplayer.field_71070_bA instanceof ContainerChester) && this.open) {
                this.open = false;
                HammerCore.audioProxy.playSoundAt(this.field_70170_p, "block.chest.close", this.func_180425_c(), 0.1f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f, SoundCategory.AMBIENT);
            }
            if (!this.staying && entityplayer != null && (this.func_70032_d((Entity)entityplayer) > 20.0f || this.field_70171_ac && this.func_70032_d((Entity)entityplayer) > 8.0f && !entityplayer.func_70090_H())) {
                int i = net.minecraft.util.math.MathHelper.func_76128_c((double)entityplayer.field_70165_t) - 2;
                int j = net.minecraft.util.math.MathHelper.func_76128_c((double)entityplayer.field_70161_v) - 2;
                int k = net.minecraft.util.math.MathHelper.func_76128_c((double)entityplayer.field_70163_u);
                block0: for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.field_70170_p.func_175677_d(new BlockPos(i + l, k - 1, j + i1), true) || this.field_70170_p.func_175677_d(new BlockPos(i + l, k, j + i1), true) || this.field_70170_p.func_175677_d(new BlockPos(i + l, k + 1, j + i1), true)) continue;
                        HammerCore.audioProxy.playSoundAt(this.field_70170_p, "entity.endermen.teleport", (double)(i + l) + 0.5, (double)k, (double)(j + i1) + 0.5, 0.5f, 1.0f, SoundCategory.AMBIENT);
                        this.func_70634_a((double)(i + l) + 0.5, k, (double)(j + i1) + 0.5);
                        this.showHeartsOrSmokeFX(false);
                        this.func_70624_b(null);
                        this.angerLevel = 0;
                        AuraHelper.polluteAura((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)0.1f, (boolean)true);
                        break block0;
                    }
                }
            }
            boolean move = false;
            if (this.angerLevel > 0 && this.func_70638_az() != null && this.func_70638_az() != entityplayer) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 20.0f);
                move = true;
                if (this.attackTime <= 0 && this.func_70068_e((Entity)this.func_70638_az()) < 1.5 && this.func_70638_az().func_174813_aQ().field_72337_e > this.func_174813_aQ().field_72338_b && this.func_70638_az().func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                    float damage = 0.0f;
                    this.attackTime = 10 + this.field_70146_Z.nextInt(5);
                    if (damage > 0.0f) {
                        this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
                    }
                    this.setLidRotation(this.getLidRotation() + 0.015f);
                    HammerCore.audioProxy.playSoundAt(this.field_70170_p, "entity.blaze.hit", this.func_180425_c(), 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f, SoundCategory.HOSTILE);
                }
                if (this.func_70638_az().field_70128_L) {
                    this.func_70624_b(null);
                    this.angerLevel = 5;
                }
            }
            if (entityplayer != null && this.func_70032_d((Entity)entityplayer) > 4.0f && this.angerLevel == 0 && !this.staying) {
                this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
                move = true;
            }
            if (this.field_70122_E && this.jumpDelay-- <= 0 && move) {
                this.jumpDelay = this.field_70146_Z.nextInt(10) + 5;
                this.jumpDelay /= 3;
                this.field_70703_bu = true;
                this.field_768_a = 1.0f;
                this.field_70702_br = 0.0f;
                this.field_191988_bg = 0.0f;
                this.field_70747_aH = 0.03f;
                double div = 0.2;
                this.field_70159_w = MathHelper.clip((double)((entityplayer.field_70165_t - this.field_70165_t) / 16.0), (double)(-div), (double)div);
                this.field_70179_y = MathHelper.clip((double)((entityplayer.field_70161_v - this.field_70161_v) / 16.0), (double)(-div), (double)div);
                this.func_70664_aZ();
                HammerCore.audioProxy.playSoundAt(this.field_70170_p, "block.chest.close", this.func_180425_c(), 0.1f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f, SoundCategory.AMBIENT);
            } else {
                this.field_70703_bu = false;
                if ((this.field_70181_x < 0.0 || this.open) && this.getLidRotation() < 0.5f) {
                    this.setLidRotation(this.getLidRotation() + 0.015f);
                    sync = true;
                }
                if (this.getLidRotation() > 0.5f) {
                    this.setLidRotation(0.5f);
                    sync = true;
                }
                if (this.field_70122_E) {
                    this.field_191988_bg = 0.0f;
                    this.field_70702_br = 0.0f;
                    if (!this.open) {
                        if (this.getLidRotation() > 0.0f) {
                            this.setLidRotation(this.getLidRotation() - 0.1f);
                            sync = true;
                        }
                        if (this.getLidRotation() < 0.0f) {
                            this.setLidRotation(0.0f);
                            sync = true;
                        }
                    }
                }
            }
            if (this.open) {
                this.setLidRotation(this.getLidRotation() + 0.035f);
                sync = true;
            }
            if (this.getLidRotation() > 0.5f) {
                this.setLidRotation(0.5f);
                sync = true;
            }
        }
        if (sync && !this.field_70170_p.field_72995_K) {
            HCNet.INSTANCE.sendToAllAround((IPacket)new PacketSyncEntity((Entity)this), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
        }
    }

    private float updateRotation(float f, float f1, float f2) {
        float f3;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }
}

