/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.client.seal;

import com.zeitheron.hammercore.client.utils.texture.TexLocUploader;
import com.zeitheron.thaumicadditions.config.ConfigsTAR;
import com.zeitheron.thaumicadditions.tiles.TileSeal;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PortalRenderer {
    public int frameBuffer;
    public static int renderRecursion;
    public int portalTexture;
    public boolean doRender = false;
    public ByteBuffer texture;

    public static void createPortalView(PortalRenderer portalRenderer, TileSeal current, TileSeal target) {
        if (!ConfigsTAR.portalGfx) {
            return;
        }
        ++renderRecursion;
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)portalRenderer.frameBuffer);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)1, (int)1);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glViewport((int)0, (int)0, (int)512, (int)512);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)6);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        for (int oh = 0; oh <= 10; ++oh) {
            double aa = Math.PI * 2 * (double)oh / 10.0;
            GL11.glVertex2f((float)((float)Math.cos(aa)), (float)((float)Math.sin(aa)));
        }
        GL11.glEnd();
        GL11.glStencilFunc((int)514, (int)1, (int)1);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glEnable((int)3553);
        EntityPlayerSP player = mc.field_71439_g;
        Entity rve = mc.func_175606_aa();
        mc.func_175607_a((Entity)new EntityPlayer((World)mc.field_71441_e, mc.func_110432_I().func_148256_e()){

            public boolean func_175149_v() {
                return true;
            }

            public boolean func_184812_l_() {
                return false;
            }
        });
        float yaw = 0.0f;
        float pitch = 0.0f;
        switch (target.orientation.ordinal()) {
            case 0: {
                pitch = 90.0f;
                break;
            }
            case 1: {
                pitch = -90.0f;
                break;
            }
            case 2: {
                yaw = 180.0f;
                break;
            }
            case 3: {
                yaw = 0.0f;
                break;
            }
            case 4: {
                yaw = 90.0f;
                break;
            }
            case 5: {
                yaw = 270.0f;
            }
        }
        int xm = 0;
        int zm = 0;
        int ym = 0;
        switch (target.orientation.ordinal()) {
            case 0: {
                ym = -1;
                break;
            }
            case 1: {
                ym = 1;
                break;
            }
            case 2: {
                zm = -1;
                break;
            }
            case 3: {
                zm = 1;
                break;
            }
            case 4: {
                xm = -1;
                break;
            }
            case 5: {
                xm = 1;
            }
        }
        mc.func_175606_aa().func_70080_a((double)target.func_174877_v().func_177958_n() + 0.5 + (double)xm, (double)((float)target.func_174877_v().func_177956_o() - 0.5f + (float)ym), (double)target.func_174877_v().func_177952_p() + 0.5 + (double)zm, yaw, pitch);
        boolean di = mc.field_71474_y.field_74330_P;
        mc.field_71474_y.field_74330_P = false;
        float fov = mc.field_71474_y.field_74334_X;
        int width = mc.field_71443_c;
        int height = mc.field_71440_d;
        int tpv = mc.field_71474_y.field_74320_O;
        mc.field_71443_c = 512;
        mc.field_71440_d = 512;
        mc.field_71474_y.field_74320_O = 0;
        mc.field_71474_y.field_74334_X = 1.0f;
        mc.func_175606_aa().field_70177_z = yaw;
        mc.func_175606_aa().field_70125_A = pitch;
        boolean hg = mc.field_71474_y.field_74319_N;
        mc.field_71474_y.field_74319_N = true;
        mc.field_71460_t.func_78471_a(1.0f, 0L);
        mc.func_175607_a(rve);
        mc.field_71443_c = width;
        mc.field_71440_d = height;
        mc.field_71474_y.field_74330_P = di;
        mc.field_71474_y.field_74319_N = hg;
        mc.field_71474_y.field_74334_X = fov;
        mc.field_71474_y.field_74320_O = tpv;
        GL11.glViewport((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        GL11.glPopMatrix();
        GL11.glDisable((int)2960);
        --renderRecursion;
    }

    public PortalRenderer() {
        if (!ConfigsTAR.portalGfx) {
            return;
        }
        try {
            int newTextureId = GL11.glGenTextures();
            TexLocUploader.cleanCallbacks.add(() -> GL11.glDeleteTextures((int)newTextureId));
            GlStateManager.func_179144_i((int)newTextureId);
            int quality = 512;
            GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)quality, (int)quality, (int)0, (int)6407, (int)5121, (ByteBuffer)BufferUtils.createByteBuffer((int)(3 * quality * quality)));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            this.portalTexture = newTextureId;
        }
        catch (IllegalStateException e) {
            System.out.println("[TAR] Error found with see-through portals. Disabling them this session.");
            ConfigsTAR.portalGfx = false;
        }
    }
}

