/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.blocks;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.api.ITileBlock;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.utils.EnumRotation;
import com.zeitheron.hammercore.utils.NBTUtils;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.color.ColorNamePicker;
import com.zeitheron.thaumicadditions.TAReconstructed;
import com.zeitheron.thaumicadditions.api.seals.SealInstance;
import com.zeitheron.thaumicadditions.api.seals.SealManager;
import com.zeitheron.thaumicadditions.blocks.def.BlockRendered;
import com.zeitheron.thaumicadditions.init.ItemsTAR;
import com.zeitheron.thaumicadditions.items.ItemSealSymbol;
import com.zeitheron.thaumicadditions.tiles.TileSeal;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.items.ItemsTC;

public class BlockSeal
extends BlockRendered
implements ITileEntityProvider,
ITileBlock<TileSeal> {
    public static final AxisAlignedBB[] SEAL_BOUNDS = new AxisAlignedBB[]{new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.0625, 0.6875), new AxisAlignedBB(0.3125, 0.875, 0.3125, 0.6875, 1.0, 0.6875), new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.0625), new AxisAlignedBB(0.3125, 0.3125, 0.875, 0.6875, 0.6875, 1.0), new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.0625, 0.6875, 0.6875), new AxisAlignedBB(0.875, 0.3125, 0.3125, 1.0, 0.6875, 0.6875)};
    private static final int[] RGBs = new int[]{255, 0, 0};

    public BlockSeal() {
        super(Material.field_151576_e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_149663_c("seal");
        this.setHarvestLevel("pickaxe", -1);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        int[] rgb = RGBs;
        String col = "#FFFFFF";
        if (stack.func_77942_o()) {
            rgb = stack.func_77978_p().func_74759_k("RGB");
        }
        if (rgb == null || rgb.length < 3) {
            rgb = RGBs;
        }
        if (rgb.length >= 3) {
            col = "#" + Integer.toHexString(rgb[0] << 16 | rgb[1] << 8 | rgb[2]);
        }
        String name = ColorNamePicker.getColorNameFromRgb((int)rgb[0], (int)rgb[1], (int)rgb[2]);
        tooltip.add(I18n.func_135052_a((String)(this.func_149739_a() + ".desc"), (Object[])new Object[0]).replace("@COLOR", advanced.func_194127_a() ? name + " (" + col.toUpperCase() + ")" : name));
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return this.canStay(worldIn, pos, side);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return false;
    }

    public boolean canStay(World world, BlockPos pos, EnumFacing face) {
        if (world == null || face == null || pos == null || !world.func_175667_e(pos.func_177972_a(face.func_176734_d()))) {
            return true;
        }
        return world.func_180495_p(pos.func_177972_a(face.func_176734_d())).isSideSolid((IBlockAccess)world, pos, face);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRotation.EFACING});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSeal();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SEAL_BOUNDS[((EnumFacing)state.func_177229_b((IProperty)EnumRotation.EFACING)).func_176734_d().ordinal()];
    }

    public ItemStack getDrop(WorldLocation loc) {
        TileSeal seal = (TileSeal)loc.getTileOfType(TileSeal.class);
        if (seal != null) {
            return seal.stack.get().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Arrays.asList(new ItemStack[0]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)EnumRotation.EFACING)).ordinal();
    }

    @Override
    public String getParticleSprite(World world, BlockPos pos) {
        return "thaumadditions:blocks/seal_base";
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDrop(new WorldLocation(world, pos));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)EnumRotation.EFACING, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EnumRotation.EFACING, (Comparable)EnumFacing.field_82609_l[meta % 6]);
    }

    public Class<TileSeal> getTileClass() {
        return TileSeal.class;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileSeal ts = (TileSeal)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TileSeal.class));
        if (ts != null && ts.orientation != null && !this.canStay(worldIn, pos, ts.orientation)) {
            BlockSeal.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getDrop(new WorldLocation(worldIn, pos)));
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileSeal seal = (TileSeal)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TileSeal.class));
        if (seal != null && !playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() == ItemsTAR.SEAL_GLOBE) {
            TAReconstructed.proxy.viewSeal(seal);
            if (!worldIn.field_72995_K) {
                HammerCore.audioProxy.playSoundAt(worldIn, "thaumadditions:rune_set", pos, 0.5f, 1.0f, SoundCategory.PLAYERS);
            }
            return true;
        }
        if (seal != null && !worldIn.field_72995_K) {
            SealInstance i;
            Aspect a;
            ItemStack stack = playerIn.func_184586_b(hand);
            Aspect aspect = a = stack.func_190926_b() || stack.func_77973_b() != ItemsTAR.SEAL_SYMBOL ? null : ItemSealSymbol.getAspect(stack);
            if (a != null && seal.getSymbol(2) == null) {
                if (seal.getSymbol(0) == null) {
                    seal.setSymbol(0, a);
                } else if (seal.getSymbol(1) == null) {
                    seal.setSymbol(1, a);
                } else {
                    seal.setSymbol(2, a);
                }
                playerIn.func_184586_b(hand).func_190918_g(1);
                HammerCore.audioProxy.playSoundAt(worldIn, "thaumadditions:rune_set", pos, 0.5f, 1.0f, SoundCategory.BLOCKS);
                HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)hand);
                SealInstance old = seal.instance;
                seal.instance = SealManager.makeInstance(seal, seal.combination, seal.optInstNBT);
                if (old != null) {
                    old.onSealBreak();
                }
                return false;
            }
            if (!playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() == ItemsTC.casterBasic && seal.getSymbol(0) != null) {
                for (int i2 = 2; i2 >= 0; --i2) {
                    if (seal.getSymbol(i2) == null || seal.getSymbol(i2) == null) continue;
                    Aspect as = seal.getSymbol(i2);
                    seal.setSymbol(i2, null);
                    if (worldIn.field_73012_v.nextInt(100) > 10) {
                        WorldUtil.spawnItemStack((World)worldIn, (BlockPos)pos, (ItemStack)ItemSealSymbol.createItem(as, 1));
                    } else {
                        HammerCore.audioProxy.playSoundAt(worldIn, "thaumadditions:fizz", pos, 0.5f, 1.0f, SoundCategory.BLOCKS);
                    }
                    HammerCore.audioProxy.playSoundAt(worldIn, "thaumcraft:zap", pos, 0.5f, 1.0f, SoundCategory.BLOCKS);
                    HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)hand);
                    return false;
                }
            }
            if ((i = seal.instance) != null && i.onSealActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
                HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)hand);
            }
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileSeal seal = (TileSeal)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TileSeal.class));
        if (seal == null) {
            seal = new TileSeal();
            worldIn.func_175690_a(pos, (TileEntity)seal);
        }
        if (seal != null) {
            ItemStack stack2 = stack.func_77946_l();
            stack2.func_190920_e(1);
            seal.stack.set(stack2);
            seal.placer.set((Object)placer.func_70005_c_());
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileSeal tile = (TileSeal)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TileSeal.class));
        if (tile != null && tile.instance != null) {
            tile.instance.onEntityCollisionWithSeal(worldIn, pos, state, entityIn);
        }
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        EnumHand hand = e.getHand();
        ItemStack held = player.func_184586_b(hand);
        BlockPos pos = e.getPos();
        if (!held.func_190926_b() && held.func_77973_b() == Item.func_150898_a((Block)this)) {
            int fill;
            ItemStack copy = held.func_77946_l();
            copy.func_190920_e(1);
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150383_bp && (fill = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0 && copy.func_77942_o() && copy.func_77978_p().func_150297_b("RGB", 11)) {
                held.func_190918_g(1);
                player.field_70170_p.func_180501_a(pos, state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(fill - 1)), 3);
                NBTUtils.removeTagFromItemStack((ItemStack)copy, (String)"RGB");
                SoundUtil.playSoundEffect((World)player.field_70170_p, (String)"item.bucket.fill", (BlockPos)pos, (float)0.5f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                if (!player.field_71071_by.func_70441_a(copy) && !player.field_70170_p.field_72995_K) {
                    WorldUtil.spawnItemStack((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)copy);
                }
                e.setCancellationResult(EnumActionResult.SUCCESS);
                e.setCanceled(true);
            }
        }
    }
}

