/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.thaumicadditions.blocks;

import com.zeitheron.hammercore.internal.blocks.IItemBlock;
import com.zeitheron.hammercore.internal.blocks.base.BlockDeviceHC;
import com.zeitheron.hammercore.internal.blocks.base.IBlockOrientable;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.thaumicadditions.api.AspectUtil;
import com.zeitheron.thaumicadditions.tiles.TileCrystalBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.crafting.IInfusionStabiliserExt;

public class BlockCrystal
extends BlockDeviceHC<TileCrystalBlock>
implements IBlockOrientable,
IInfusionStabiliserExt,
IItemBlock {
    public final ItemCrystalBlock itemBlock = new ItemCrystalBlock();

    public BlockCrystal() {
        super(Material.field_151576_e, TileCrystalBlock.class, "crystal_block");
    }

    public int getColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        TileCrystalBlock tcb = (TileCrystalBlock)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TileCrystalBlock.class));
        if (tcb != null) {
            return tcb.getAspect().getColor();
        }
        return 0xFFFFFF;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        return AspectUtil.getAspectFromCrystalBlockStack(stack).getColor();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        super.func_149666_a(itemIn, items);
        for (Aspect a : Aspect.aspects.values()) {
            items.add((Object)AspectUtil.crystalBlock(a));
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)IBlockOrientable.FACING, (Comparable)facing);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileCrystalBlock tcb = (TileCrystalBlock)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TileCrystalBlock.class));
        if (tcb == null) {
            tcb = new TileCrystalBlock();
        }
        tcb.setAspect(AspectUtil.getAspectFromCrystalBlockStack(stack));
        worldIn.func_175690_a(pos, (TileEntity)tcb);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileCrystalBlock tcb = (TileCrystalBlock)((Object)WorldUtil.cast((Object)world.func_175625_s(pos), TileCrystalBlock.class));
        return tcb != null ? AspectUtil.crystalBlock(tcb.getAspect()) : super.getPickBlock(state, target, world, pos, player);
    }

    public boolean canStabaliseInfusion(World worldIn, BlockPos pos) {
        return true;
    }

    public float getStabilizationAmount(World world, BlockPos pos) {
        return 0.015f;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public class ItemCrystalBlock
    extends ItemBlock {
        public ItemCrystalBlock() {
            super((Block)BlockCrystal.this);
        }

        public String func_77653_i(ItemStack stack) {
            return super.func_77653_i(stack).replace("@ASPECT", AspectUtil.getAspectFromCrystalBlockStack(stack).getName());
        }
    }
}

